package org.lsst.ccs.subsystem.demo.gui.plugins.monitor;

import java.awt.BorderLayout;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;

/**
 *****************************************************************
 *
 *  Implements the rafts control panel / monitor panel assembly.
 *
 *  @author Owen Saxton
 *
 *****************************************************************
 */
public class DemoMonitorAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    
    public DemoMonitorAssembly(DemoMonitorGui gui) {
        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);
    }

    public void setSubsystems(String... names) {
        mon.setSubsystems(names);
    }

    @Override
    public void disableSystem(String name, int id) {
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof MonitorFullState) {
            MonitorFullState r = (MonitorFullState)d;
            mon.updateTableModel(name, r);
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key, Object d) {
        mon.handleData(name, key, d);
    }

    private static final long serialVersionUID = 1L;
}
