package org.lsst.ccs.subsystem.demo.gui.plugins.monitor;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;

/**
 * Demo monitoring filter.
 *
 * @author onoprien
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Demo filter",
               path="Demo/Demo Subsystem/DemoFilter",
               description="Demo filter packaged with the demo subsystem.")
public class DemoFilter implements AgentChannelsFilter {

    @Override
    public String getOriginPath(String displayPath) {
        return "demo-subsystem-with-monitoring/"+ displayPath.replace("//", "/");
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        int i1 = originPath.indexOf("/");
        int i2 = originPath.indexOf("/", i1+1);
        if (i1 == -1 || i2 == -1) return Collections.emptyList();
        String displayPath = originPath.substring(i1 + 1, i2) +"//"+ originPath.substring(i2 + 1);
        return Collections.singletonList(displayPath);
    }

}
