/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.states.AlertState;

public final class RaisedAlertHistory
implements Serializable {
    private static final long serialVersionUID = 883621057372902934L;
    private Alert latestAlert;
    private final List<RaisedAlertInstance> instances;
    private AlertState highestSeverity = AlertState.NOMINAL;

    public RaisedAlertHistory() {
        this.instances = new ArrayList<RaisedAlertInstance>(1);
    }

    public Alert getLatestAlert() {
        return this.latestAlert;
    }

    public void addAlertInstance(AlertState severity, Alert alert, long timestamp, String cause) {
        this.addAlertInstance(severity, alert, timestamp, cause, 1);
    }

    public void addAlertInstance(AlertState severity, Alert alert, long timestamp, String cause, int count) {
        if (severity.compareTo(this.highestSeverity) > 0) {
            this.highestSeverity = severity;
        }
        this.instances.add(new RaisedAlertInstance(severity, timestamp, cause, count));
        this.latestAlert = alert;
    }

    public int getNumberOfInstances() {
        return this.instances.size();
    }

    public int getAccumulatedNumberOfInstances() {
        return this.instances.stream().collect(Collectors.summingInt(RaisedAlertInstance::getCount));
    }

    public AlertState getLatestAlertState() {
        int n = this.getNumberOfInstances();
        switch (n) {
            case 0: {
                return AlertState.NOMINAL;
            }
        }
        return this.instances.get(n - 1).getAlertState();
    }

    public long getLatestAlertTimestamp() {
        int n = this.getNumberOfInstances();
        switch (n) {
            case 0: {
                return -1L;
            }
        }
        return this.instances.get(n - 1).getTimestamp();
    }

    public String getLatestAlertCause() {
        int n = this.getNumberOfInstances();
        switch (n) {
            case 0: {
                return "";
            }
        }
        return this.instances.get(n - 1).getCause();
    }

    public RaisedAlertInstance getLatestAlertInstance() {
        int n = this.getNumberOfInstances();
        switch (n) {
            case 0: {
                return null;
            }
        }
        return this.instances.get(n - 1);
    }

    public AlertState getHighestAlertState() {
        return this.highestSeverity;
    }

    public ArrayList<RaisedAlertInstance> getRaisedAlertInstancesList() {
        return new ArrayList<RaisedAlertInstance>(this.instances);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Raised Alarms for id ").append(this.getLatestAlert().getAlertId()).append("\n");
        sb.append("Overall Severity: ").append(this.getHighestAlertState());
        return sb.toString();
    }
}

