/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.logging.Handler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.lsst.ccs.CommandHelper;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.LookupInjectUtils;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentAlerts;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.CCSVersions;
import org.lsst.ccs.bus.data.DistributionInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.messaging.LogBusHandler;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentMBeanService;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.CCSLogManager;
import org.lsst.ccs.utilities.logging.Log4JConfiguration;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;
import org.lsst.ccs.utilities.tracers.Names;

public class Agent
implements CommandExecutor,
ServiceLifecycle {
    private AgentInfo agentInfo;
    private final AtomicBoolean isAlive = new AtomicBoolean(true);
    protected final AtomicBoolean jvmShutdown = new AtomicBoolean(false);
    private static final Logger log;
    private static final java.util.logging.Logger generalLogger;
    private volatile AgentMessagingLayer messagingAccess;
    private static volatile Agent environmentAgent;
    protected LogBusHandler logBusHandler;
    private final Scheduler scheduler;
    protected final Object commandExecutorLock = new Object();
    private final ExecutorService queryExecutor;
    protected final Set<RunningCommand> currentQueries;
    private final ExecutorService actionExecutor;
    protected volatile RunningCommand currentAction;
    private final ExecutorService signalExecutor;
    protected final Set<RunningCommand> currentSignals;
    private final ThreadGroup commandGroup = new ThreadGroup("Command Threads");
    private final ConcurrentHashMap<String, CommandSet> commandSetMap = new ConcurrentHashMap();
    private HashMap<String, CommandSet> finalizedCommandSetMap = null;
    private HashMap<String, Dictionary> dictionaries = null;
    private List<String> commandTargets = null;
    private final ThreadLocal<RunningCommand> currentCommand = new ThreadLocal();
    private volatile boolean isConnectedToTheBuses = false;
    private ComponentLookup componentLookupService;
    protected volatile boolean treeComponentInitialized = false;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AgentPeriodicTaskService agentPeriodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private ConfigurationService subsystemConfigurationEnvironment;
    private PersistencyService subsystemPersistencyService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AgentMBeanService mbeanService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<AgentService> agentServices = new ArrayList<AgentService>();
    private final Map<Class, AgentService> agentServicesByClass = new HashMap<Class, AgentService>();
    public static final String AGENT_HEARTBEAT_TASK = "heartbeat";
    public static final String AGENT_RUNTIMEINFO_TASK = "runtimeInfo";
    private final List<CommandObjectToAdd> commandObjectsToAdd = new ArrayList<CommandObjectToAdd>();
    private int jmxPort = -1;

    public Agent(String name, AgentInfo.AgentType agentType) {
        switch (agentType) {
            case CONSOLE: 
            case LISTENER: {
                name = Names.almostUniqueAgentName((String)name);
                break;
            }
        }
        this.agentInfo = new AgentInfo(name, agentType);
        this.scheduler = new Scheduler("Scheduler for " + name, 3);
        this.scheduler.setLogger(log);
        this.queryExecutor = Executors.newCachedThreadPool(this.createThreadFactory("CommandExecutor (QUERY)"));
        this.currentQueries = ConcurrentHashMap.newKeySet(3);
        this.actionExecutor = Executors.newSingleThreadExecutor(this.createThreadFactory("CommandExecutor (ACTION)"));
        this.signalExecutor = Executors.newCachedThreadPool(this.createThreadFactory("CommandExecutor (SIGNAL)"));
        this.currentSignals = ConcurrentHashMap.newKeySet(3);
    }

    @Override
    public void preBuild() {
        this.messagingAccess = AgentMessagingLayer.createInstance((AgentInfo)this.agentInfo, (LockLevelService)this.agentLockService);
        this.stateService.updateInternalState(new AgentState[]{CommandState.READY, OperationalState.ENGINEERING_OK, AlertState.NOMINAL});
    }

    @Override
    public void preInit() {
        long heartbeatPeriod = this.agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0 ? 1L : 5L;
        AgentPeriodicTask heartbeatPublisher = new AgentPeriodicTask(AGENT_HEARTBEAT_TASK, () -> this.broadcastStatus()).withPeriod(Duration.ofSeconds(heartbeatPeriod));
        this.agentPeriodicTaskService.scheduleAgentPeriodicTask(heartbeatPublisher);
    }

    protected final void populateComponentLookup(ComponentLookup lookup) {
        if (this.treeComponentInitialized) {
            throw new RuntimeException("populateComponentLookup must be called exactly once");
        }
        this.treeComponentInitialized = true;
        this.componentLookupService = lookup;
        for (CommandObjectToAdd cmdObjToAdd : this.commandObjectsToAdd) {
            this.addCommandSet(cmdObjToAdd.getPath(), cmdObjToAdd.getObject());
        }
        this.commandObjectsToAdd.clear();
        ComponentNode agentComponentNode = this.componentLookupService.getTopComponentNode();
        ServiceLoader<AgentService> agentServiceLoader = ServiceLoader.load(AgentService.class);
        for (AgentService agentService : agentServiceLoader) {
            if (!agentService.startForAgent(this.agentInfo)) continue;
            log.debug((Object)("Starting service " + agentService.getAgentServiceName()));
            this.componentLookupService.addComponentNodeToLookup(agentComponentNode, new ComponentNode(agentService.getAgentServiceName(), (Object)agentService));
        }
        this.subsystemPersistencyService = PersistencyService.create(this);
        LookupInjectUtils.injectComponents(this.componentLookupService);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, n -> n.preBuild(), null);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, n -> n.build(), n -> n.postBuild());
        boolean useFullPaths = "true".equals(this.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
        LookupInjectUtils.injectComponents(this.componentLookupService, useFullPaths, true);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, n -> n.preInit(), null);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, n -> n.init(), n -> n.postInit());
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, n -> n.afterInit(), null);
    }

    public final List<AgentService> getAgentServices() {
        return this.agentServices;
    }

    public final <T extends AgentService> T getAgentService(Class<T> agentClass) {
        AgentService foundService;
        if (!this.agentServicesByClass.containsKey(agentClass)) {
            for (AgentService service : this.agentServices) {
                if (!agentClass.isInstance(service)) continue;
                this.agentServicesByClass.put(agentClass, service);
            }
        }
        if ((foundService = this.agentServicesByClass.get(agentClass)) == null) {
            throw new RuntimeException("Service of type " + agentClass + " does not exist in this Agent");
        }
        return (T)((AgentService)agentClass.cast(foundService));
    }

    public final ComponentLookup getComponentLookup() {
        return this.componentLookupService;
    }

    protected CommandHelper createHelper() {
        return new CommandHelper(this);
    }

    public CommandHelper helper() {
        return this.createHelper();
    }

    @Deprecated
    public final AgentPeriodicTaskService getAgentPeriodicTaskService() {
        return this.getAgentService(AgentPeriodicTaskService.class);
    }

    @Deprecated
    public final AgentStatusAggregatorService getAgentStatusAggregatorService() {
        return this.getAgentService(AgentStatusAggregatorService.class);
    }

    public final void setAgentName(String alias) {
        if (this.treeComponentInitialized) {
            throw new RuntimeException("Too late to change the Agent name.");
        }
        if (alias != null) {
            this.agentInfo = new AgentInfo(alias, this.agentInfo.getType());
        }
    }

    @Deprecated
    public void startAgent(String alias) {
        this.startAgent();
    }

    public void startAgent() {
        if (!this.treeComponentInitialized) {
            this.populateComponentLookup(new ComponentLookup(new ComponentNode(this.getName(), (Object)this)));
        }
        TreeWalkerUtils.proceduralNodeWalk(this.componentLookupService, null, n -> {
            Object o = n.getComponent();
            String key = n.getKey();
            String fullPath = o instanceof Monitor || o instanceof ConfigurationService || o instanceof AlertService || o instanceof PersistencyService ? "" : n.getPath();
            this.addCommandSet(fullPath, o);
        }, null);
        this.finalizedCommandSetMap = new HashMap<String, CommandSet>(this.commandSetMap);
        this.dictionaries = new HashMap(this.finalizedCommandSetMap.size() * 2);
        this.finalizedCommandSetMap.forEach((name, commandSet) -> {
            Dictionary dict = commandSet.getCommandDictionary();
            for (Map.Entry<String, Dictionary> d : this.dictionaries.entrySet()) {
                if (!DictionaryUtils.areDictionariesEqual((Dictionary)d.getValue(), (Dictionary)dict)) continue;
                dict = d.getValue();
                break;
            }
            this.dictionaries.put((String)name, dict);
        });
        this.commandTargets = new ArrayList<String>(this.finalizedCommandSetMap.size() * 2);
        this.finalizedCommandSetMap.forEach((name, commandSet) -> this.commandTargets.add((String)name));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.jvmShutdown.set(true);
            try {
                if (this.stateService.getState(PhaseState.class) != null && !this.stateService.isInState((Enum)PhaseState.OFF_LINE)) {
                    this.shutdownAgent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        this.connectToTheBuses();
        this.stateService.updateInternalState(new AgentState[]{PhaseState.INITIALIZING, CommandState.READY, OperationalState.ENGINEERING_OK, AlertState.NOMINAL, ConfigurationState.INITIAL_SAFE});
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, ServiceLifecycle::preStart, null);
        AlertState alertState = this.getAgentInfo().getType().equals((Object)AgentInfo.AgentType.CONSOLE) ? AlertState.WARNING : AlertState.NOMINAL;
        this.getMessagingAccess().setClusterDeserializationErrorHandler(s -> {
            HashMap<String, String> alertData = new HashMap<String, String>();
            alertData.put("sender", s);
            alertData.put("receiver", this.getName());
            this.getAlertService().raiseAlert(AgentAlerts.ClusterAlert.getAlert(alertData), alertState, this.getName() + "and " + s + " are running incompatible core versions");
        });
        this.internalCheckHardware();
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, HasLifecycle::start, null);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, HasLifecycle::postStart, null);
        this.stateService.updateInternalState(new AgentState[]{PhaseState.OPERATIONAL});
    }

    private void terminate() {
        if (this.isAlive.getAndSet(false)) {
            log.fine((Object)("Subsystem " + this.getName() + " final shutdown"));
            if (this.logBusHandler != null) {
                generalLogger.removeHandler((Handler)this.logBusHandler);
                this.logBusHandler.close();
            }
            this.scheduler.shutdownNow();
            this.queryExecutor.shutdownNow();
            this.actionExecutor.shutdownNow();
            this.signalExecutor.shutdownNow();
            this.getMessagingAccess().shutdownBusAccess();
        }
    }

    @Command(name="shutdown", description="shutdown", type=Command.CommandType.ACTION)
    public Object shutdownAgent() throws Exception {
        log.info((Object)(this.getName() + " is shutting down"));
        this.stateService.updateInternalState(new AgentState[]{PhaseState.CLOSING});
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, ServiceLifecycle::preShutdown, null);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, HasLifecycle::shutdown, HasLifecycle::postShutdown);
        try {
            this.checkAllHardwareStopped();
            this.getLogger().fine((Object)"Hardware is stopped");
        }
        catch (HardwareException exc) {
            this.getAlertService().raiseAlert(new Alert("Problems stopping hardware", exc.getMessage()), AlertState.ALARM, "Internl Shutdown exception: " + exc.getMessage());
            this.getLogger().error((Object)"Problems stopping hardware", (Throwable)((Object)exc));
            throw new RuntimeException((Throwable)((Object)exc));
        }
        this.getMessagingAccess().setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler.DEFAULT);
        this.stateService.updateInternalState(new AgentState[]{PhaseState.OFF_LINE});
        if (Thread.currentThread().getThreadGroup() != this.commandGroup) {
            this.terminate();
        }
        CCSLogManager.doReset();
        return "OK";
    }

    public Logger getLogger() {
        return log;
    }

    public final String getName() {
        return this.agentInfo.getName();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public int getCommandCount(Command.CommandType ... types) {
        if (types.length == 0) {
            return this.currentQueries.size() + (this.currentAction == null ? 0 : 1) + this.currentSignals.size();
        }
        int out = 0;
        for (Command.CommandType type : types) {
            out += this.getCommandCount(type);
        }
        return out;
    }

    public int getStatusBroadcastPeriod() {
        return (int)this.agentPeriodicTaskService.getPeriodicTaskPeriod(AGENT_HEARTBEAT_TASK).getSeconds();
    }

    @Command(description="is the system in engineering mode ?", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public boolean isInEngineeringMode() {
        Enum em = this.stateService.getState(OperationalState.class);
        return em != null && em.compareTo(OperationalState.ENGINEERING_OK) >= 0;
    }

    @Command(description="Get the CCS Versions for the current CCS Environment", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public CCSVersions getCCSVersions() {
        CCSVersions ccsVersions = new CCSVersions();
        List agents = this.getMessagingAccess().getAgentPresenceManager().listConnectedAgents();
        ConcurrentMessagingUtils concurrentMessagingUtils = new ConcurrentMessagingUtils(this.getMessagingAccess());
        for (AgentInfo a : agents) {
            CommandRequest request = new CommandRequest(a.getName(), "getDistributionInfo");
            try {
                Object distInfo = concurrentMessagingUtils.sendSynchronousCommand(request, Duration.ofMillis(1000L));
                if (distInfo == null) continue;
                ccsVersions.add(a, (DistributionInfo)distInfo);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ccsVersions.add(this.getAgentInfo(), new DistributionInfo());
        return ccsVersions;
    }

    @Command(description="Get the Agent's DistributionInfo object.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public DistributionInfo getDistributionInfo() {
        return new DistributionInfo();
    }

    @Command(description="get the command dictionary for the subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public HashMap<String, Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    @Command(description="Get the list of command targets", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public List<String> getCommandTargets() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.commandTargets);
        return result;
    }

    @Command(description="Print component lookup", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public String printComponentNodeTree() {
        StringBuilder sb = new StringBuilder();
        TreeWalkerUtils.proceduralNodeWalk(this.componentLookupService, null, n -> sb.append(n.getPath()).append("\n"), null);
        return sb.toString();
    }

    protected CommandSet getCommandSet(String name) {
        if (this.finalizedCommandSetMap.containsKey(name)) {
            return this.finalizedCommandSetMap.get(name);
        }
        String componentName = name.substring(name.lastIndexOf(47));
        for (Map.Entry<String, CommandSet> entry : this.finalizedCommandSetMap.entrySet()) {
            if (!entry.getKey().endsWith(componentName)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected void addCommandSet(String fullPath, Object obj) {
        if (this.finalizedCommandSetMap != null) {
            throw new RuntimeException("Not possible to add a CommandSet at this point. The list of CommandSets has already been finalized.");
        }
        if (!this.treeComponentInitialized) {
            this.commandObjectsToAdd.add(new CommandObjectToAdd(fullPath, obj));
        } else {
            CommandSet commandSet = new CommandSetBuilder().buildCommandSet(obj);
            if (commandSet.getCommandDictionary().size() == 0) {
                return;
            }
            if (fullPath == null) {
                fullPath = "";
            }
            int depth = !fullPath.isEmpty() ? fullPath.split("/").length : 0;
            Dictionary dict = commandSet.getCommandDictionary();
            for (DictionaryCommand c : dict) {
                for (Field field : c.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    try {
                        int value;
                        if (!field.getName().equals("level") || (value = ((Integer)field.get(c)).intValue()) != 99999) continue;
                        field.setInt(c, depth);
                        log.fine((Object)("Changing undefined level on command " + c.getCommandName() + " to value " + depth));
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (fullPath.startsWith("main/") || fullPath.equals("main")) {
                fullPath = fullPath.replaceFirst("main", "");
            }
            fullPath = this.getName() + (fullPath.isEmpty() || fullPath.startsWith("/") ? fullPath : "/" + fullPath);
            CompositeCommandSet cmdSet = (CompositeCommandSet)this.commandSetMap.getOrDefault(fullPath, (CommandSet)new CompositeCommandSet());
            cmdSet.add(commandSet);
            this.commandSetMap.put(fullPath, (CommandSet)cmdSet);
        }
    }

    public void addCommandsFromObject(Object obj, String path) {
        this.addCommandSet(path, obj);
    }

    @Deprecated
    public void setAgentProperty(String property, String value) {
        if (this.getAgentService(AgentPropertiesService.class) == null) {
            throw new RuntimeException("Too early to invoke setAgentProperty. This cannot be done from the constructor. It must be done in the following phases: HasLifecycle::build or HasLifecycle::init.");
        }
        this.getAgentService(AgentPropertiesService.class).setAgentProperty(property, value);
    }

    public AgentMessagingLayer getMessagingAccess() {
        if (this.messagingAccess == null) {
            throw new RuntimeException("The messaging access instance has not been created yet.");
        }
        return this.messagingAccess;
    }

    private static void setEnvironmentAgent(Agent a) {
        if (environmentAgent == null) {
            environmentAgent = a;
        } else if ("false".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false"))) {
            throw new RuntimeException("*** Should not have two agents running in same JVM");
        }
    }

    public static AgentMessagingLayer getEnvironmentMessagingAccess() {
        if (environmentAgent == null) {
            throw new IllegalStateException("The environment has not been initialized yet");
        }
        return environmentAgent.getMessagingAccess();
    }

    public static AgentLockService getEnvironmentLockService() {
        if (environmentAgent == null) {
            throw new IllegalStateException("The environment has not been initialized yet");
        }
        return environmentAgent.getAgentLockService();
    }

    public boolean isConnectedToTheBuses() {
        return this.isConnectedToTheBuses;
    }

    private synchronized void connectToTheBuses() {
        if (this.isConnectedToTheBuses) {
            throw new RuntimeException("This agent is already connected to the buses");
        }
        this.isConnectedToTheBuses = true;
        this.getMessagingAccess().connectToBuses();
        Agent.setEnvironmentAgent(this);
        this.initLogBusHandler();
        this.getMessagingAccess().setCommandExecutor((CommandExecutor)this);
        try {
            if (this.mbeanService != null) {
                this.mbeanService.registerMBean(this.messagingAccess, new ObjectName("org.lsst.ccs.mbean:type=MessagingLayer"));
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    private void initLogBusHandler() {
        if (this.logBusHandler == null) {
            this.logBusHandler = new LogBusHandler(this.getMessagingAccess());
            generalLogger.addHandler((Handler)this.logBusHandler);
        }
    }

    public final void publishSubsystemDataOnStatusBus(KeyValueData keyValueData) {
        StatusSubsystemData message = new StatusSubsystemData(keyValueData, this.stateService.getState());
        this.getMessagingAccess().sendStatusMessage((StatusMessage)message);
    }

    protected final void broadcastStatus() {
        StatusHeartBeat s = new StatusHeartBeat(this.getStatusBroadcastPeriod(), this.stateService.getState());
        this.updateHeartBeat(s);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)s);
    }

    protected void updateHeartBeat(StatusHeartBeat heartBeat) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommandRequest(CommandRequest request) {
        Object object = this.commandExecutorLock;
        synchronized (object) {
            try {
                boolean notTopCommand;
                PhaseState phase = (PhaseState)this.stateService.getState(PhaseState.class);
                if (phase == null || phase == PhaseState.OFF_LINE) {
                    CommandNack nack = new CommandNack(request, (Serializable)((Object)("Cannot accept command: OFF_LINE or NULL phase state " + this.currentAction)));
                    log.warning((Object)("sending nack " + nack));
                    if (this.isConnectedToTheBuses()) {
                        this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    }
                    return;
                }
                String destination = request.getDestination();
                boolean bl = notTopCommand = destination.contains("/") && !destination.endsWith("/main");
                if (notTopCommand && this.stateService.getState(OperationalState.class).compareTo(OperationalState.ENGINEERING_OK) < 0) {
                    CommandNack nack = new CommandNack(request, (Serializable)((Object)"can't access lower level component (not named \"main\") if not in ENGINEERING MODE"));
                    log.warning((Object)("sending nack " + nack));
                    this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                BasicCommand basicCommand = request.getBasicCommand();
                CommandSet commandSet = this.getCommandSet(destination);
                if (commandSet == null) {
                    throw new RuntimeException("Unknown destination " + destination);
                }
                DictionaryCommand dictionaryCommand = commandSet.getCommandDictionary().findCommand(basicCommand);
                if (dictionaryCommand == null) {
                    throw new RuntimeException("Could not find command " + basicCommand);
                }
                if (dictionaryCommand.getType().equals((Object)Command.CommandType.QUERY)) {
                    log.fine((Object)("Received command request from " + request.getOriginAgentInfo().getName() + ": " + (String)request.getEncodedData()));
                } else {
                    log.info((Object)("Received command request from " + request.getOriginAgentInfo().getName() + ": " + (String)request.getEncodedData()));
                }
                if (dictionaryCommand.getLevel() > 0 || dictionaryCommand.getType().compareTo((Enum)Command.CommandType.QUERY) > 0) {
                    AgentLock lock = request.getLock();
                    if (lock == null) {
                        log.warning((Object)("Command : " + dictionaryCommand.getCommandName() + " requires a lock. Sender should first lock this agent"));
                    }
                    int desiredLevel = request.getLevel();
                    if (!this.agentLockService.validateLock(lock)) {
                        throw new RuntimeException("Invalid lock : " + lock);
                    }
                    if (desiredLevel < dictionaryCommand.getLevel()) {
                        log.warning((Object)("Command level is " + dictionaryCommand.getLevel() + " which is higher than the sender's level : " + desiredLevel));
                    }
                }
                Command.CommandType type = dictionaryCommand.getType();
                switch (type) {
                    case QUERY: {
                        RunningCommand runningCommand = new RunningCommand(request, dictionaryCommand, commandSet);
                        this.currentQueries.add(runningCommand);
                        this.queryExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    case CONFIGURATION: {
                        if (this.stateService.getState(OperationalState.class).compareTo(OperationalState.ENGINEERING_OK) < 0) {
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"CONFIGURATION commands are only accepted in ENGINEERING mode"));
                            log.warning((Object)("sending nack " + nack));
                            this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                            return;
                        }
                    }
                    case ACTION: {
                        RunningCommand runningCommand;
                        if (!this.stateService.isInState((Enum)CommandState.READY)) {
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"ACTION and CONFIGURATION commands are only accepted in READY state"));
                            log.warning((Object)(type + " sending nack " + nack));
                            this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                            return;
                        }
                        this.stateService.updateInternalState(new AgentState[]{CommandState.ACTIVE});
                        this.currentAction = runningCommand = new RunningCommand(request, dictionaryCommand, commandSet);
                        this.actionExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    case SIGNAL: {
                        long dueTime;
                        long currentTime = dueTime = System.currentTimeMillis();
                        DictionaryArgument[] arguments = dictionaryCommand.getArguments();
                        if (basicCommand.getArguments().length > 0 && "Long".equalsIgnoreCase(arguments[0].getSimpleType())) {
                            String argAsString = String.valueOf(basicCommand.getArguments()[0]);
                            Long expectedMaxDelay = Long.valueOf(argAsString);
                            dueTime = currentTime + expectedMaxDelay;
                        }
                        for (RunningCommand rc : this.currentSignals) {
                            if (rc.timeout >= dueTime) continue;
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"SIGNAL with shorter deadline is already running"));
                            log.warning((Object)(type + " sending nack " + nack));
                            this.getMessagingAccess().sendCommandReply((CommandReply)nack);
                            return;
                        }
                        this.stateService.updateInternalState(new AgentState[]{CommandState.ACTIVE});
                        log.fine((Object)("Received Signal from " + request.getOriginAgentInfo().getName() + " for running action " + this.currentAction));
                        RunningCommand runningCommand = new RunningCommand(request, dictionaryCommand, commandSet);
                        this.currentSignals.add(runningCommand);
                        this.signalExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    default: {
                        assert (false) : "Unknown command type :" + type;
                        break;
                    }
                }
            }
            catch (EmbeddedObjectDeserializationException ex) {
                CommandNack nack = new CommandNack(request, (Serializable)((Object)ex));
                log.error((Object)("sending nack " + nack), (Throwable)ex);
                this.getMessagingAccess().sendCommandReply((CommandReply)nack);
            }
            catch (RuntimeException | CommandArgumentMatchException t) {
                CommandNack nack = new CommandNack(request, (Serializable)t);
                log.error((Object)"Error processing command request ", t);
                this.getMessagingAccess().sendCommandReply((CommandReply)nack);
            }
        }
    }

    private ThreadFactory createThreadFactory(String name) {
        return run -> {
            Thread thread = new Thread(this.commandGroup, run, name);
            thread.setUncaughtExceptionHandler((t, x) -> log.error((Object)("Uncaught exception in command thread " + t.getName()), x));
            return thread;
        };
    }

    public boolean sendNack(Serializable reason) {
        RunningCommand command = this.currentCommand.get();
        if (command != null && command.dictionaryCommand.isAutoAck()) {
            throw new RuntimeException("sendNack cannot be invoked while executing a command that is not annotated with \"autoAck=false\".");
        }
        if (command == null || command.reply != null) {
            return false;
        }
        command.reply = new CommandNack(command.request, reason);
        log.warning((Object)("sending nack " + command.reply));
        this.getMessagingAccess().sendCommandReply(command.reply);
        return true;
    }

    public boolean sendAck(Duration timeout) {
        RunningCommand command = this.currentCommand.get();
        if (command != null && command.dictionaryCommand.isAutoAck()) {
            throw new RuntimeException("sendAck cannot be invoked while executing a command that is not annotated with \"autoAck=false\".");
        }
        if (command == null || command.reply != null) {
            return false;
        }
        command.reply = new CommandAck(command.request, timeout);
        this.getMessagingAccess().sendCommandReply(command.reply);
        return true;
    }

    public RunningCommand getCurrentAction() {
        return this.currentAction;
    }

    @Deprecated
    public Monitor getMonitor() {
        return this.getAgentService(Monitor.class);
    }

    @Deprecated
    public final ConfigurationService getConfigurationService() {
        return this.getAgentService(ConfigurationService.class);
    }

    @Deprecated
    public final AlertService getAlertService() {
        return this.getAgentService(AlertService.class);
    }

    @Deprecated
    public final DataProviderDictionaryService getDataProviderDictionaryService() {
        return this.getAgentService(DataProviderDictionaryService.class);
    }

    @Deprecated
    public final AgentLockService getAgentLockService() {
        return this.getAgentService(AgentLockService.class);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(Object obj) {
        String name = this.getComponentLookup().getNameOfComponent(obj);
        return this.getComponentConfigurationEnvironmentByName(name);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironmentByName(String name) {
        return this.subsystemConfigurationEnvironment.getComponentConfigurationEnvironment(name);
    }

    public PersistencyService getAgentPersistenceService() {
        return this.subsystemPersistencyService;
    }

    public String getDescription() {
        return this.subsystemConfigurationEnvironment.getTag();
    }

    private int getCommandCount(Command.CommandType type) {
        switch (type) {
            case QUERY: {
                return this.currentQueries.size();
            }
            case CONFIGURATION: 
            case ACTION: {
                RunningCommand current = this.currentAction;
                if (current.type == null) {
                    return 0;
                }
                return current.type == type ? 1 : 0;
            }
            case SIGNAL: {
                return this.currentSignals.size();
            }
        }
        assert (false) : "Unknown command type " + type;
        return 0;
    }

    protected void internalCheckHardware() {
        HashMap exceptionsMap = new HashMap();
        HardwareException[] exc = new HardwareException[]{null};
        TreeWalkerUtils.treeWalk(this.getComponentLookup(), null, HardwareController.class, hc -> {
            try {
                return hc.checkHardware();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)((Object)e), exc[0]);
                exceptionsMap.put(this.getComponentLookup().getNameOfComponent(hc), e.toString());
                if (e.isFatal()) {
                    return TreeWalkerDiag.STOP;
                }
                return TreeWalkerDiag.GO;
            }
        }, null);
        if (exc[0] != null) {
            this.getLogger().error((Object)"check hardware problem ", (Throwable)((Object)exc[0]));
            this.stateService.updateInternalState(new AgentState[]{OperationalState.ENGINEERING_FAULT});
        }
        if (!exceptionsMap.isEmpty() && this.stateService.isInState((Enum)AlertState.NOMINAL)) {
            this.getAlertService().raiseAlert(AgentAlerts.HardwareAlert.getAlert(exceptionsMap), AlertState.ALARM, "HardwareExceptions were raised during hardware intialization.");
        }
    }

    public void checkAllHardwareStopped() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HardwareController.class, hc -> {
            try {
                hc.checkStopped();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)((Object)e), exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    @Deprecated
    public boolean isInState(Enum state) {
        return this.stateService.isInState(state);
    }

    @Deprecated
    public boolean isInState(StateBundle state) {
        return this.stateService.isInState(state);
    }

    @Deprecated
    public Enum getState(Class stateClass) {
        return this.stateService.getState(stateClass);
    }

    @Deprecated
    public StateBundle getState() {
        return this.stateService.getState();
    }

    @Deprecated
    public void updateAgentState(Enum ... stateChanges) {
        this.stateService.updateAgentState(stateChanges);
    }

    @Deprecated
    public void updateAgentState(StateBundle stateChanges) {
        this.stateService.updateAgentState(stateChanges);
    }

    @Deprecated
    public void updateAgentComponentState(Object component, Enum ... stateChanges) {
        this.stateService.updateAgentComponentState(component, stateChanges);
    }

    @Deprecated
    public final boolean waitFor(Predicate<StateBundle> target, long timeout, TimeUnit unit) throws InterruptedException {
        return this.stateService.waitFor(target, timeout, unit);
    }

    @Deprecated
    public void addStateChangeListener(StateChangeListener stateChangeListener, Class ... states) {
        this.stateService.addStateChangeListener(stateChangeListener, states);
    }

    @Deprecated
    public void removeStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateService.removeStateChangeListener(stateChangeListener);
    }

    static {
        Log4JConfiguration.initialize();
        log = Logger.getLogger((String)"org.lsst.ccs.subsystem");
        generalLogger = java.util.logging.Logger.getLogger("org.lsst.ccs");
        environmentAgent = null;
    }

    private class CommandObjectToAdd {
        private final String path;
        private final Object obj;

        CommandObjectToAdd(String path, Object obj) {
            this.path = path;
            this.obj = obj;
        }

        String getPath() {
            return this.path;
        }

        Object getObject() {
            return this.obj;
        }
    }

    public final class RunningCommand {
        protected final CommandRequest request;
        protected final Command.CommandType type;
        protected final CommandSet commandSet;
        protected final DictionaryCommand dictionaryCommand;
        protected final long timeout;
        protected Serializable result;
        protected CommandReply reply;
        private final FutureTask<Object> task;

        RunningCommand(CommandRequest request, DictionaryCommand dictionaryCommand, CommandSet commandSet) {
            this(request, dictionaryCommand, commandSet, 0L);
        }

        RunningCommand(CommandRequest request, DictionaryCommand dictionaryCommand, CommandSet commandSet, long timeout) {
            this.request = request;
            this.dictionaryCommand = dictionaryCommand;
            this.type = dictionaryCommand.getType();
            this.commandSet = commandSet;
            this.timeout = timeout;
            this.task = new FutureTask<Object>(() -> {
                Agent.this.currentCommand.set(this);
                if (dictionaryCommand.isAutoAck()) {
                    this.reply = new CommandAck(request, dictionaryCommand.getTimeout());
                    Agent.this.getMessagingAccess().sendCommandReply(this.reply);
                }
                BasicCommand basicCommand = request.getBasicCommand();
                try {
                    this.result = (Serializable)commandSet.invoke(basicCommand);
                    if (dictionaryCommand.getType().equals((Object)Command.CommandType.QUERY)) {
                        log.fine((Object)("Command execution result:" + this.result));
                    } else {
                        log.info((Object)("Command execution result:" + this.result));
                    }
                }
                catch (Exception t) {
                    log.info((Object)("Command execution error:" + basicCommand.getCommand() + Arrays.toString(basicCommand.getArguments())), (Throwable)t);
                    this.result = t;
                }
                Object t = Agent.this.commandExecutorLock;
                synchronized (t) {
                    switch (this.type) {
                        case QUERY: {
                            Agent.this.currentQueries.remove(this);
                            break;
                        }
                        case CONFIGURATION: 
                        case ACTION: {
                            Agent.this.currentAction = null;
                            if (!Agent.this.currentSignals.isEmpty()) break;
                            Agent.this.stateService.updateInternalState(new AgentState[]{CommandState.READY});
                            break;
                        }
                        case SIGNAL: {
                            Agent.this.currentSignals.remove(this);
                            if (Agent.this.currentAction != null || !Agent.this.currentSignals.isEmpty()) break;
                            Agent.this.stateService.updateInternalState(new AgentState[]{CommandState.READY});
                            break;
                        }
                        default: {
                            assert (false) : "Unknown command type :" + this.type;
                            break;
                        }
                    }
                }
                if (this.reply == null) {
                    this.reply = new CommandAck(request, dictionaryCommand.getTimeout());
                    Agent.this.getMessagingAccess().sendCommandReply(this.reply);
                }
                if (!(this.reply instanceof CommandNack)) {
                    this.reply = new CommandResult(request, this.result);
                    Agent.this.getMessagingAccess().sendCommandReply(this.reply);
                }
                if (Agent.this.stateService.isInState((Enum)PhaseState.OFF_LINE) && Agent.this.currentAction == null && Agent.this.currentSignals.isEmpty()) {
                    Thread shutdownThread = new Thread(() -> Agent.this.terminate(), "Agent shutdown thread");
                    shutdownThread.start();
                }
                Agent.this.currentCommand.set(null);
                return this.result;
            });
        }

        private FutureTask<Object> getTask() {
            return this.task;
        }

        public CommandRequest getCommandRequest() {
            return this.request;
        }

        public Command.CommandType getType() {
            return this.type;
        }

        public CommandReply getReply() {
            return this.reply;
        }

        public void cancel() {
            this.task.cancel(true);
        }

        public String toString() {
            return "Command(" + this.type.name() + ") from " + this.request.getOriginAgentInfo().getName() + ": " + (String)this.request.getEncodedData();
        }
    }
}

