/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationParameterInfo
implements Serializable {
    private static final long serialVersionUID = 85957367834684384L;
    private String pathName;
    private String categoryName;
    private String configuredValue;
    private String currentValue;
    private boolean dirty;
    private Boolean isFinal;
    private Boolean isReadOnly;
    private String componentName;
    private String parameterName;
    @Deprecated
    private String typeName;
    @Deprecated
    private String description;
    @Deprecated
    private String units;
    private Type actualType;

    public String getPathName() {
        return this.pathName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getConfiguredValue() {
        return this.configuredValue;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Deprecated
    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public String getUnits() {
        return this.units;
    }

    @Deprecated
    public String getType() {
        return this.typeName;
    }

    public Type getActualType() {
        return this.actualType;
    }

    public Object getCurrentValueObject() {
        return InputConversionEngine.convertArgToType((String)this.currentValue, (Type)this.actualType);
    }

    public Object getConfiguredValueObject() {
        return InputConversionEngine.convertArgToType((String)this.configuredValue, (Type)this.actualType);
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String toString() {
        return "ConfigurationParameterInfo{pathName=" + this.pathName + ", categoryName=" + this.categoryName + ", configuredValue=" + this.configuredValue + ", currentValue=" + this.currentValue + ", isDirty=" + this.dirty + '}';
    }

    static Type convertTypeIfNeeded(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Serializable) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            return new ConfigurationParameterizedType((ParameterizedType)type);
        }
        throw new IllegalArgumentException("Cannot deal with Type: " + type);
    }

    public static class ConfigurationParameterizedType
    implements ParameterizedType,
    Serializable {
        private final Type[] actualTypeArguments;
        private final Type rawType;
        private final Type ownerType;

        ConfigurationParameterizedType(ParameterizedType type) {
            this.ownerType = ConfigurationParameterInfo.convertTypeIfNeeded(type.getOwnerType());
            this.rawType = ConfigurationParameterInfo.convertTypeIfNeeded(type.getRawType());
            int typeIndex = 0;
            this.actualTypeArguments = new Type[type.getActualTypeArguments().length];
            for (Type t : type.getActualTypeArguments()) {
                this.actualTypeArguments[typeIndex++] = ConfigurationParameterInfo.convertTypeIfNeeded(t);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }
    }

    static class Builder {
        private ConfigurationParameterInfo cpi = new ConfigurationParameterInfo();

        Builder() {
        }

        Builder addParameter(ParameterPath path, Type type, String category, String description, String units, boolean isFinal, boolean isReadOnly) {
            this.cpi.pathName = path.toString();
            this.cpi.componentName = path.getComponentName();
            this.cpi.parameterName = path.getParameterName();
            this.cpi.typeName = type.getTypeName();
            this.cpi.categoryName = category;
            this.cpi.description = description;
            this.cpi.units = units;
            this.cpi.isFinal = isFinal;
            this.cpi.isReadOnly = isReadOnly;
            this.cpi.actualType = ConfigurationParameterInfo.convertTypeIfNeeded(type);
            return this;
        }

        Builder updateParameter(String configuredValue, String currentValue, boolean dirty) {
            this.cpi.configuredValue = configuredValue;
            this.cpi.currentValue = currentValue;
            this.cpi.dirty = dirty;
            return this;
        }

        ConfigurationParameterInfo build() {
            return this.cpi;
        }
    }
}

