package org.lsst.ccs.subsystem.demo.gui.plugins.trending;

import java.awt.event.ActionEvent;
import java.util.*;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.plugins.trending.RenamingFilter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingFilter;

/**
 * Demo Plugin - trending sources and filters.
 *
 * @author onoprien
 */
@Plugin(name = "LSST CCS Plugin Demo - Trending",
        id = "trend-demo",
        description = "LSST CCS Plugin that demonstrates the use of trending sources and filters.",
        loadAtStart = false)
public class TrendingSourcesManagingDemoPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private DemoSource source;
    private TrendingFilter filter1, filter2;

// -- Life cycle : -------------------------------------------------------------
    
    public TrendingSourcesManagingDemoPlugin() {
        
    }

    @Override
    public void initialize() {
    
        Action act = new AbstractAction("Extra source") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (source == null) {
                    source = new DemoSource();
                    getConsole().getConsoleLookup().add(source);
                } else {
                    getConsole().getConsoleLookup().remove(source);
                    source = null;
                }
            }
        };
        act.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(act, "Demo", "Trending:1");
    
        act = new AbstractAction("Renaming Filter 1") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (filter1 == null) {
                    ArrayList<String[]> names = new ArrayList<>();
                    names.add(new String[] {"/localdb/runtimeInfo/totalMemory", "/Runtime Info/Total memory", "Total Memory"});
                    names.add(new String[] {"/localdb/runtimeInfo/freeMemory", "/Runtime Info/Free memory", "Free Memory"});
                    names.add(new String[] {"/localdb/runtimeInfo/processCpuLoad"});
                    names.add(new String[] {"/localdb/runtimeInfo/systemCpuLoad", "/localdb/runtimeInfo/totalCpuLoad"});
                    filter1 = new RenamingFilter(names);
                    getConsole().getConsoleLookup().add(filter1);
                } else {
                    getConsole().getConsoleLookup().remove(filter1);
                    filter1 = null;
                }
            }
        };
        act.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(act, "Demo", "Trending:2");
    
        act = new AbstractAction("Renaming Filter 2") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (filter2 == null) {
                    Map<TrendingChannel, String> nameMap = new HashMap<>();
                    nameMap.put(new TrendingChannel("/Critical/N threads", "Number of threads"), "/localdb/runtimeInfo/nThreads");
                    nameMap.put(new TrendingChannel("/Critical/Free memory", "Free Memory"), "/localdb/runtimeInfo/freeMemory");
                    filter2 = new RenamingFilter(nameMap);
                    getConsole().getConsoleLookup().add(filter2);
                } else {
                    getConsole().getConsoleLookup().remove(filter2);
                    filter2 = null;
                }
            }
        };
        act.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(act, "Demo", "Trending:3");
    }

    @Override
    public void start() {
    }

// -----------------------------------------------------------------------------
}
