/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cache.internal.StandardQueryCache;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.NaturalIdCacheStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataGroup;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;

public class CacheStatistics {
    private static final String[] NAMED_QUERIES = new String[]{"findAlertDesc", "findInnerStateDesc", "findDataDesc", "findStatData", "findStatDesc", "findDataGroup", "findStateBundleDesc"};
    private static final Class[] CACHED_ENTITIES = new Class[]{AlertDesc.class, InnerStateDesc.class, DataDesc.class, AgentState.class, StatTimeInterval.class, StatData.class, StatDesc.class, StateBundleDesc.class, DataGroup.class};
    private static final Class[] SECOND_LEVEL_CACHE = new Class[]{AlertDesc.class, InnerStateDesc.class, DataDesc.class, AgentState.class, StatTimeInterval.class, StatData.class, StatDesc.class, StateBundleDesc.class, DataGroup.class, StandardQueryCache.class};
    private final KeyValueDataList dataList = new KeyValueDataList("statistics");

    public CacheStatistics(SessionFactory fac) {
        Statistics stats = fac.getStatistics();
        try (Session sess = fac.openSession();){
            String entitiesPath;
            for (String string : NAMED_QUERIES) {
                String queryPath = "statistics/queries/" + string + "/";
                QueryStatistics queryStats = stats.getQueryStatistics(sess.getNamedQuery(string).getQueryString());
                this.dataList.addData(queryPath + "hit", (Serializable)Long.valueOf(queryStats.getCacheHitCount()));
                this.dataList.addData(queryPath + "miss", (Serializable)Long.valueOf(queryStats.getCacheMissCount()));
                this.dataList.addData(queryPath + "put", (Serializable)Long.valueOf(queryStats.getCachePutCount()));
                this.dataList.addData(queryPath + "avgExec", (Serializable)Long.valueOf(queryStats.getExecutionAvgTime()));
            }
            for (Class clazz : SECOND_LEVEL_CACHE) {
                String slcPath = "statistics/slc/" + clazz.getSimpleName() + "/";
                SecondLevelCacheStatistics slcStats = stats.getSecondLevelCacheStatistics(clazz.getName());
                this.dataList.addData(slcPath + "count", (Serializable)Long.valueOf(slcStats.getElementCountInMemory()));
                this.dataList.addData(slcPath + "hit", (Serializable)Long.valueOf(slcStats.getHitCount()));
                this.dataList.addData(slcPath + "miss", (Serializable)Long.valueOf(slcStats.getMissCount()));
                this.dataList.addData(slcPath + "put", (Serializable)Long.valueOf(slcStats.getPutCount()));
            }
            for (Class clazz : CACHED_ENTITIES) {
                entitiesPath = "statistics/entities/" + clazz.getSimpleName() + "/";
                EntityStatistics entityStats = stats.getEntityStatistics(clazz.getName());
                this.dataList.addData(entitiesPath + "load", (Serializable)Long.valueOf(entityStats.getLoadCount()));
                this.dataList.addData(entitiesPath + "fetch", (Serializable)Long.valueOf(entityStats.getFetchCount()));
            }
            for (Class clazz : new Class[]{StatTimeInterval.class, AgentState.class}) {
                entitiesPath = "statistics/naturalId/" + clazz.getSimpleName() + "/";
                NaturalIdCacheStatistics natIdStats = stats.getNaturalIdCacheStatistics(clazz.getName() + "##NaturalId");
                this.dataList.addData(entitiesPath + "hit", (Serializable)Long.valueOf(natIdStats.getHitCount()));
                this.dataList.addData(entitiesPath + "miss", (Serializable)Long.valueOf(natIdStats.getMissCount()));
                this.dataList.addData(entitiesPath + "put", (Serializable)Long.valueOf(natIdStats.getPutCount()));
                this.dataList.addData(entitiesPath + "count", (Serializable)Long.valueOf(natIdStats.getElementCountInMemory()));
            }
            this.dataList.addData("statistics/sessionStats/connectCount", (Serializable)Long.valueOf(stats.getConnectCount()));
            this.dataList.addData("statistics/sessionStats/flushCount", (Serializable)Long.valueOf(stats.getFlushCount()));
            this.dataList.addData("statistics/sessionStats/sessionOpenCount", (Serializable)Long.valueOf(stats.getSessionOpenCount()));
            this.dataList.addData("statistics/sessionStats/sessionCloseCount", (Serializable)Long.valueOf(stats.getSessionCloseCount()));
            this.dataList.addData("statistics/sessionStats/transactionCount", (Serializable)Long.valueOf(stats.getTransactionCount()));
            this.dataList.addData("statistics/sessionStats/successfulTransactionCount", (Serializable)Long.valueOf(stats.getSuccessfulTransactionCount()));
            stats.clear();
        }
    }

    public KeyValueDataList getStatData() {
        return this.dataList;
    }
}

