/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.TreeView;

@Plugin(name="Optional Page Demo Plugin", id="opt-page-demo", description="Demo for adding optional pages.", loadAtStart=false)
public class OptionalPageDemoPlugin
extends ConsolePlugin {
    private final OptionalPage opt1 = new OptPage1();
    private final OptionalPage opt2 = new OptPage2();
    private AbstractAction act2;
    private final OptionalPage opt3m = new OptPage3Monitor();
    private final OptionalPage opt3c = new OptPage3Control();

    public void initialize() {
        AbstractAction act = new AbstractAction("Page-per-subsystem"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    Console.getConsole().getOptionalPageService().add(OptionalPageDemoPlugin.this.opt1);
                } else {
                    Console.getConsole().getOptionalPageService().remove(OptionalPageDemoPlugin.this.opt1);
                }
            }
        };
        act.putValue("SwingSelectedKey", false);
        this.getServices().addMenu((Action)act, new String[]{" CCS Tools ", "Demo", "Optional Page"});
        this.act2 = new AbstractAction("Page-lists-all"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    Console.getConsole().getOptionalPageService().add(OptionalPageDemoPlugin.this.opt2);
                } else {
                    Console.getConsole().getOptionalPageService().remove(OptionalPageDemoPlugin.this.opt2);
                }
            }
        };
        this.act2.putValue("SwingSelectedKey", false);
        this.getServices().addMenu((Action)this.act2, new String[]{" CCS Tools ", "Demo", "Optional Page"});
        act = new AbstractAction("Two-for-each-subsystem"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    Console.getConsole().getOptionalPageService().add(OptionalPageDemoPlugin.this.opt3m);
                    Console.getConsole().getOptionalPageService().add(OptionalPageDemoPlugin.this.opt3c);
                } else {
                    Console.getConsole().getOptionalPageService().remove(OptionalPageDemoPlugin.this.opt3m);
                    Console.getConsole().getOptionalPageService().remove(OptionalPageDemoPlugin.this.opt3c);
                }
            }
        };
        act.putValue("SwingSelectedKey", false);
        this.getServices().addMenu((Action)act, new String[]{" CCS Tools ", "Demo", "Optional Page"});
    }

    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        try {
            Descriptor d = (Descriptor)storageBean;
            boolean installed = d.isInstalled();
            if (installed != (Boolean)this.act2.getValue("SwingSelectedKey")) {
                this.act2.putValue("SwingSelectedKey", installed);
                this.act2.actionPerformed(null);
            }
            if (installed) {
                this.opt2.restore(d.getOpen());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return true;
    }

    public Descriptor save() {
        Descriptor d = new Descriptor();
        d.setInstalled((Boolean)this.act2.getValue("SwingSelectedKey"));
        d.setOpen(this.opt2.save());
        return d;
    }

    static class OptPage3Control
    implements OptionalPage {
        private final HashMap<String, JLabel> labels = new HashMap();

        OptPage3Control() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public boolean isAutoSave() {
            return true;
        }

        public String getPage(AgentInfo agent) {
            return "CCS Subsystems/Demo/Two-for-each-subsystem/" + agent.getName() + "/Control";
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            JLabel label;
            if (existingComponent == null) {
                existingComponent = Box.createHorizontalBox();
                existingComponent.add(Box.createHorizontalGlue());
                label = new JLabel(agent.getName() + " control");
                existingComponent.add(label);
                existingComponent.add(Box.createHorizontalGlue());
                existingComponent.setName(agent.getName() + " control");
            } else {
                existingComponent.removeAll();
                existingComponent.add(Box.createHorizontalGlue());
                label = new JLabel(agent.getName() + " control (re-connected)");
                existingComponent.add(label);
                existingComponent.add(Box.createHorizontalGlue());
                existingComponent.setName(agent.getName() + " control");
            }
            this.labels.put(this.getPage(agent), label);
            return existingComponent;
        }

        public void closed(String page) {
            this.labels.remove(page);
        }

        public boolean agentDisconnected(AgentInfo agent) {
            JLabel label = this.labels.get(this.getPage(agent));
            if (label != null) {
                label.setText(agent.getName() + " control (disconnected)");
            }
            return false;
        }
    }

    static class OptPage3Monitor
    implements OptionalPage {
        private HashMap<String, MonitorView> views = new HashMap();

        OptPage3Monitor() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public boolean isAutoSave() {
            return true;
        }

        public String getPage(AgentInfo agent) {
            return "CCS Subsystems/Demo/Two-for-each-subsystem/" + agent.getName() + "/Monitor";
        }

        public JComponent open(final AgentInfo agent, JComponent existingComponent) {
            TreeView view = new TreeView();
            AbstractChannelsFilter filter = new AbstractChannelsFilter(){

                public List<String> getAgents() {
                    return Collections.singletonList(agent.getName());
                }
            };
            view.setFilter((AgentChannelsFilter)filter);
            view.setName(agent.getName() + " monitor");
            this.views.put(this.getPage(agent), (MonitorView)view);
            return view.getPanel();
        }

        public void opened(String page) {
            MonitorView view = this.views.get(page);
            if (view != null) {
                view.install();
            }
        }

        public void closed(String page) {
            MonitorView view = this.views.remove(page);
            if (view != null) {
                view.uninstall();
            }
        }

        public boolean agentDisconnected(AgentInfo agent) {
            return false;
        }
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private boolean installed;
        private HashMap<String, Boolean> open;

        public boolean isInstalled() {
            return this.installed;
        }

        public void setInstalled(boolean installed) {
            this.installed = installed;
        }

        public HashMap<String, Boolean> getOpen() {
            return this.open;
        }

        public void setOpen(HashMap<String, Boolean> open) {
            this.open = open;
        }
    }

    static class OptPage2
    implements OptionalPage {
        private final JLabel label = new JLabel();
        private final ArrayList<String> agents = new ArrayList();

        OptPage2() {
        }

        public String getPage(AgentInfo agent) {
            return "CCS Subsystems/Demo/Page-lists-all";
        }

        public JComponent open(AgentInfo agent, JComponent component) {
            if (component == null) {
                component = new JPanel(new BorderLayout());
                component.add((Component)this.label, "Center");
            }
            if (agent != null) {
                this.agents.add(agent.getName());
            }
            this.updateLabel();
            return component;
        }

        public void closed(String page) {
            this.agents.clear();
        }

        public boolean agentDisconnected(AgentInfo agent) {
            this.agents.remove(agent.getName());
            this.updateLabel();
            return false;
        }

        private void updateLabel() {
            StringBuilder sb = new StringBuilder("<html><h4>Connected subsystems:</h4>");
            this.agents.forEach(a -> sb.append((String)a).append("<p>"));
            this.label.setText(sb.toString());
        }
    }

    static class OptPage1
    implements OptionalPage {
        OptPage1() {
        }

        public boolean isAutoSave() {
            return true;
        }

        public String getPage(AgentInfo agent) {
            StringBuilder sb = new StringBuilder("CCS Subsystems/Demo/Page-per-subsystem");
            if (agent.getName().equals("demo-subsystem")) {
                sb.append(":2");
            }
            return sb.append("/").append(agent.getName()).toString();
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            JLabel label = new JLabel(agent.getName());
            box.add(label);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        public boolean agentDisconnected(AgentInfo agent) {
            return !agent.getName().equals("demo-subsystem");
        }
    }
}

