/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer.filters;

import java.util.Arrays;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilterFactory;
import org.lsst.ccs.gconsole.plugins.tracer.filters.AbstractMessageFilter;

public class HeartBeatSelector
implements MessageFilterFactory {
    @Override
    public String getDescription() {
        return "Filter that selects or rejects heartbeat status messages.<p><b>Optional parameters:</b><dl><dt>invert</dt><dd>If checked, heartbeats are accepted and all other messages rejected.</dd></dl>";
    }

    @Override
    public String getPath() {
        return "BuiltIn/Remove HeartBeat";
    }

    @Override
    public String getName() {
        return "HeartBeat Selector";
    }

    @Override
    public MessageFilter get(String[] parameters) {
        if (parameters == null || parameters.length != 1) {
            throw new IllegalArgumentException("Illegal parameters: " + Arrays.toString(parameters));
        }
        return new Filter("true".equalsIgnoreCase(parameters[0]));
    }

    public MessageFilter getInstance(boolean invert) {
        return new Filter(invert);
    }

    private class Filter
    extends AbstractMessageFilter {
        private final boolean invert;

        public Filter(boolean invert) {
            this.invert = invert;
        }

        @Override
        public FilteredMessage test(FilteredMessage filteredMessage) {
            boolean accept = filteredMessage.getBusMessage().getClass().getName().contains("StatusHeartBeat");
            return this.invert ^ accept ? filteredMessage : null;
        }

        @Override
        public String getDescription() {
            return HeartBeatSelector.this.getDescription();
        }

        @Override
        public String getPath() {
            return HeartBeatSelector.this.getPath();
        }

        @Override
        public String getName() {
            return HeartBeatSelector.this.getName();
        }
    }
}

