package org.lsst.ccs.subsystem.demo.gui.configurationview;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;

@   org.lsst.ccs.gconsole.annotations.Plugin(name="Demo Configuration plugin", description="A Demo Configuration plugin")
public class SubsystemConfigurationViewPlugin extends ConsolePlugin {

    private JComponent page;
    private Action act;

    @Override
    public void initialize() {
        act = new AbstractAction("Subsystem configuration") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if ((Boolean)getValue(Action.SELECTED_KEY)) {
                    startConfiguration();
                    act.putValue(Action.SELECTED_KEY, true);
                } else {
                    stopConfiguration();
                    act.putValue(Action.SELECTED_KEY, false);
                }
            }
        };
        act.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(act, "Demo Plugins");
    }
    
    private void startConfiguration() {
        page = new SubsystemConfigurationViewTopPanel(getConsole().getMessagingAccess());
        
        PanelManager pm = getConsole().getPanelManager();
        pm.open(page, "Subsystem Configuration");
        pm.addListener(e -> {
            if (e.hasKey(Panel.OPEN) && (Boolean) e.getNewValue() == false) {
                stopConfiguration();
            }
        });
    }
    
    private void stopConfiguration() {
        getConsole().getPanelManager().close(page);
        page = null;
    }
}
