/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jline.console.ConsoleReader;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.AgentLockServiceCommands;
import org.lsst.ccs.subsystem.shell.BusCommandSet;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleSocketConnection;

public class ConsoleCommandShell
implements AgentPresenceListener,
AgentLockService.AgentLevelListener,
AgentLockService.AgentLockUpdateListener {
    private final AgentMessagingLayer messagingAccess;
    private final RouteSelectionCommandSet rsc;
    private final ConcurrentMessagingUtils sci;
    private final BusMasterCommands busMasterCommands = new BusMasterCommands();
    private final CompositeCommandSet builtInsCommandSet;
    private static final int timeoutMillis = 10000;
    private JythonConsoleSocketConnection jythonConsoleSocketConnection = null;
    private String showJythonOutput = "false";
    private final Agent agent;

    ConsoleCommandShell(Agent agent) {
        this.messagingAccess = agent.getMessagingAccess();
        this.sci = new ConcurrentMessagingUtils(this.messagingAccess, Duration.ofMillis(10000L));
        this.rsc = new RouteSelectionCommandSet();
        CommandSetBuilder builder = new CommandSetBuilder();
        this.builtInsCommandSet = new CompositeCommandSet();
        this.builtInsCommandSet.add(builder.buildCommandSet((Object)this.busMasterCommands));
        this.builtInsCommandSet.add(builder.buildCommandSet((Object)new AgentLockServiceCommands(agent.getAgentLockService())));
        this.rsc.add((CommandSet)this.builtInsCommandSet);
        this.rsc.getCommandDictionary().setVisibilityForTypes(Command.CommandType.values());
        this.agent = agent;
    }

    void init() {
        this.agent.getAgentLockService().addAgentLevelListener(this);
        this.agent.getAgentLockService().addAgentLockUpdateListener(this);
        AgentPresenceManager apMan = this.messagingAccess.getAgentPresenceManager();
        apMan.addAgentPresenceListener((AgentPresenceListener)this);
    }

    public RouteSelectionCommandSet getConsoleCommandSet() {
        return this.rsc;
    }

    public void connecting(AgentInfo agent) {
        if (!(agent.getType().equals((Object)AgentInfo.AgentType.LISTENER) || agent.getType().equals((Object)AgentInfo.AgentType.CONSOLE) || this.rsc.containsPath(agent.getName()))) {
            AddSubsystem add = new AddSubsystem(agent);
            Thread t = new Thread(add);
            t.start();
        }
    }

    public synchronized void disconnecting(AgentInfo agent) {
        String agentName = agent.getName();
        this.rsc.removeRoute(agentName);
    }

    @Override
    public void onAgentLevelChange(String agentName, int level) {
        if (this.rsc.containsPath(agentName)) {
            this.rsc.setRouteLevel(agentName, level);
        }
    }

    @Override
    public void onAgentLockUpdate(String agentName, AgentLock lock) {
        if (this.rsc.containsPath(agentName)) {
            String consoleName = this.messagingAccess.getAgentInfo().getName();
            if (lock != null && lock.getOwnerAgentNames().contains(consoleName)) {
                this.rsc.setRouteCommandTypeVisibility(agentName, Command.CommandType.values());
            } else {
                this.rsc.setRouteCommandTypeVisibility(agentName, new Command.CommandType[]{Command.CommandType.QUERY});
            }
        }
    }

    BusMasterCommands getBusMasterCommands() {
        return this.busMasterCommands;
    }

    public static JLineShell createJLineShell(Agent agent, ConsoleReader reader) throws IOException {
        ConsoleCommandShell comShell = new ConsoleCommandShell(agent);
        comShell.init();
        return new JLineShell((CommandSet)comShell.getConsoleCommandSet(), reader, "${target} ccs>");
    }

    public static ConsoleCommandShell createConsoleCommandShell(Agent agent) {
        ConsoleCommandShell comShell = new ConsoleCommandShell(agent);
        comShell.init();
        return comShell;
    }

    public static void main(String[] argv) throws Exception {
        BusMaster busMaster = new BusMaster("ccs-shell");
        busMaster.startAgent();
        ConsoleCommandShell comShell = new ConsoleCommandShell(busMaster);
        JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        comShell.init();
        shell.run();
        System.exit(0);
    }

    private class AddSubsystem
    implements Runnable {
        private final AgentInfo agent;

        AddSubsystem(AgentInfo agentInfo) {
            this.agent = agentInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CommandRequest getDictionaryCommand = new CommandRequest(this.agent.getName(), "getDictionaries");
                HashMap dictionaries = (HashMap)ConsoleCommandShell.this.sci.sendSynchronousCommand(getDictionaryCommand);
                ConsoleCommandShell consoleCommandShell = ConsoleCommandShell.this;
                synchronized (consoleCommandShell) {
                    Command.CommandType[] commandTypeArray;
                    for (String path : dictionaries.keySet()) {
                        int last;
                        int first;
                        String useLongPathsProperty = this.agent.getAgentProperty("use.full.paths");
                        boolean useLongPaths = useLongPathsProperty != null && useLongPathsProperty.toLowerCase().equals("true");
                        String route = path;
                        if (!useLongPaths && (first = path.indexOf("/")) != (last = path.lastIndexOf("/"))) {
                            route = path.substring(0, first) + path.substring(last);
                        }
                        ConsoleCommandShell.this.rsc.addRoutingCommandSet(route, path, (CommandSet)new BusCommandSet(ConsoleCommandShell.this.sci, path, (Dictionary)dictionaries.get(path)));
                    }
                    String agentName = this.agent.getName();
                    int dictionaryLevel = ConsoleCommandShell.this.messagingAccess.getAgentLockService().getLevelForAgent(agentName);
                    AgentLock lock = ConsoleCommandShell.this.messagingAccess.getAgentLockService().getLockForAgent(agentName);
                    ConsoleCommandShell.this.rsc.setRouteLevel(agentName, dictionaryLevel);
                    RouteSelectionCommandSet routeSelectionCommandSet = ConsoleCommandShell.this.rsc;
                    if (lock != null) {
                        commandTypeArray = Command.CommandType.values();
                    } else {
                        Command.CommandType[] commandTypeArray2 = new Command.CommandType[1];
                        commandTypeArray = commandTypeArray2;
                        commandTypeArray2[0] = Command.CommandType.QUERY;
                    }
                    routeSelectionCommandSet.setRouteCommandTypeVisibility(agentName, commandTypeArray);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public class BusMasterCommands {
        public List<String> listSubsystems() {
            return this.listSubsystems("", "Worker", true);
        }

        @Command(name="listSubsystems", description="List the subsystems on the CCS buses for a given Agent type", alias="ls")
        public List<String> listSubsystems(@Argument(name="Options", defaultValue="") String options, @Argument(name="Agent type", defaultValue="Worker") String agentType, @Argument(defaultValue="true") boolean allTypesAbove) {
            AgentInfo.AgentType referenceType = AgentInfo.AgentType.valueOf((String)agentType.toUpperCase());
            ArrayList<String> result = new ArrayList<String>();
            for (AgentInfo agent : ConsoleCommandShell.this.messagingAccess.getAgentPresenceManager().listConnectedAgents()) {
                if ((!allTypesAbove || agent.getType().ordinal() < referenceType.ordinal()) && agent.getType().ordinal() != referenceType.ordinal()) continue;
                result.add(this.getAgentInformation(agent, options));
            }
            return result;
        }

        private String getAgentInformation(AgentInfo agentInfo, String options) {
            StringBuilder sb = new StringBuilder();
            sb.append(agentInfo.getName());
            if (options.contains("h")) {
                sb.append("[");
                String host = agentInfo.getAgentProperty("org.lsst.ccs.agent.hostname");
                if (host != null && !host.isEmpty()) {
                    sb.append("host=").append(host);
                    String jmxport = agentInfo.getAgentProperty("org.lsst.ccs.agent.jmxport");
                    if (jmxport != null && !jmxport.isEmpty()) {
                        sb.append(":").append(jmxport);
                    }
                }
                sb.append("]");
            }
            return sb.toString();
        }

        @Command(description="Set Console parameters")
        public void set(@Argument(name="item") ConsoleParameters what, @Argument(name="value") String value) {
            if (what == ConsoleParameters.TIMEOUT) {
                ConsoleCommandShell.this.sci.setDefaultTimeout(Duration.ofMillis(Long.valueOf(value)));
            } else if (what == ConsoleParameters.SHOW_JYTHON_OUTPUT) {
                if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                    ConsoleCommandShell.this.jythonConsoleSocketConnection.setPrintStream(value.equals("true") ? System.out : null);
                }
                ConsoleCommandShell.this.showJythonOutput = value;
            }
        }

        @Command(description="Get a Console parameter")
        public String get(@Argument(name="item") ConsoleParameters what) {
            if (what == ConsoleParameters.TIMEOUT) {
                return String.valueOf(ConsoleCommandShell.this.sci.getDefaultTimeout().toMillis());
            }
            if (what == ConsoleParameters.SHOW_JYTHON_OUTPUT) {
                return ConsoleCommandShell.this.showJythonOutput;
            }
            return null;
        }

        @Command(description="Execute a Jython script")
        public void executeScript(@Argument(name="scriptPath") String scriptPath, String ... args) throws IOException {
            JythonScriptExecutorUtils.executeScript(scriptPath, args);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void connectToJythonConsole(@Argument(name="host", defaultValue="localhost") String host, @Argument(name="port", defaultValue="4444") int port) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                throw new RuntimeException("There is already a connection established. There can be only one! Please \"closeConnectionWithJythonConsole\" before opening a new one.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection = new JythonConsoleSocketConnection("CommandShellConnection_" + System.currentTimeMillis(), port, host);
            ConsoleCommandShell.this.jythonConsoleSocketConnection.setPrintStream(ConsoleCommandShell.this.showJythonOutput.equals("true") ? System.out : null);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void submitScript(@Argument(name="scriptPath") String scriptPath, String ... args) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("No connection was established with a JythonConsole. Please invoke \"connectToJythonConsole\" first");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.asynchFileExecution(scriptPath, args);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void closeConnectionWithJythonConsole() throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("There is open connection to a JythonConsole.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.close();
            ConsoleCommandShell.this.jythonConsoleSocketConnection = null;
        }
    }

    public static enum ConsoleParameters {
        TIMEOUT,
        SHOW_JYTHON_OUTPUT;

    }
}

