/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.adapter;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IManagedObject;
import hep.aida.ITuple;
import hep.aida.ref.event.Connectable;
import hep.aida.ref.tree.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAObjectProvider;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeObjectProvider;
import org.freehep.jas.plugin.tree.FTreeNodeTextChangeEvent;
import org.freehep.jas.plugin.tree.FTreePath;

public class ManagedObjectAdapter
extends DefaultFTreeNodeAdapter {
    private AIDAPlugin plugin;
    private Studio app;
    private Tree aidaMasterTree;

    public ManagedObjectAdapter(AIDAPlugin plugin, Studio app) {
        super(50, (FTreeNodeObjectProvider)new AIDAObjectProvider(plugin));
        this.plugin = plugin;
        this.app = app;
        this.aidaMasterTree = plugin.aidaMasterTree();
    }

    public String text(FTreeNode node, String oldText) {
        Object o;
        if (this.plugin.isShowNamesAndTitles() && (o = node.objectForClass(IManagedObject.class)) != null) {
            String name;
            IManagedObject obj = (IManagedObject)o;
            String title = name = obj.name();
            if (obj instanceof IBaseHistogram) {
                title = ((IBaseHistogram)obj).title();
            } else if (obj instanceof IDataPointSet) {
                title = ((IDataPointSet)obj).title();
            } else if (obj instanceof ITuple) {
                title = ((ITuple)obj).title();
            } else if (obj instanceof IFunction) {
                title = ((IFunction)obj).title();
            }
            if (!title.equals(name)) {
                name = name + " [" + title + "]";
            }
            return name;
        }
        return null;
    }

    public Component treeCellRendererComponent(Component component, FTreeNode node, boolean sel, boolean expanded, boolean leaf, boolean hasFocus) {
        try {
            IManagedObject obj = this.getObjectForPath(this.plugin.fullPath(node.path()));
            Font font = ((JLabel)component).getFont();
            boolean connected = true;
            if (obj instanceof Connectable) {
                boolean normal;
                connected = ((Connectable)obj).isConnected();
                boolean bl = normal = !font.isItalic();
                if (connected != normal) {
                    int size = font.getSize();
                    int style = connected ? 0 : 2;
                    String name = font.getName();
                    Font newFont = new Font(name, style, size);
                    ((JLabel)component).setFont(newFont);
                }
                if (connected) {
                    ((JLabel)component).setForeground(Color.black);
                } else {
                    ((JLabel)component).setForeground(Color.red);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return component;
    }

    public boolean canTextBeChanged(FTreeNodeTextChangeEvent evt, boolean oldCanBeRenamed) {
        return true;
    }

    public boolean acceptNewText(FTreeNodeTextChangeEvent evt, boolean oldAcceptNewName) {
        IManagedObject obj = null;
        try {
            obj = this.aidaMasterTree.find(this.newFullPath(evt));
        }
        catch (Exception e) {
            // empty catch block
        }
        return obj == null;
    }

    public void nodeTextChanged(FTreeNodeTextChangeEvent evt) {
        this.aidaMasterTree.mv(this.oldFullPath(evt), this.newFullPath(evt));
        evt.consume();
    }

    private String newFullPath(FTreeNodeTextChangeEvent evt) {
        String newName = evt.newText();
        FTreeNode node = evt.node();
        FTreePath parentPath = node.path().getParentPath();
        FTreePath newPath = parentPath == null ? new FTreePath(newName) : parentPath.pathByAddingChild(newName);
        return this.plugin.fullPath(newPath);
    }

    private String oldFullPath(FTreeNodeTextChangeEvent evt) {
        FTreeNode node = evt.node();
        FTreePath path = node.path();
        return this.plugin.fullPath(path);
    }

    private IManagedObject getObjectForPath(String pathString) {
        IManagedObject mo = null;
        mo = this.aidaMasterTree.findObject(pathString);
        return mo;
    }
}

