/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;

public class MonitorTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean ensureWidth = false;
    private boolean ensureHeight = false;

    public void setEnsureWidth(boolean ensureWidth) {
        this.ensureWidth = ensureWidth;
    }

    public void setEnsureHeight(boolean ensureHeight) {
        this.ensureHeight = ensureHeight;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int h;
        TableColumn c;
        int w;
        if (value instanceof FormattedValue) {
            FormattedValue fv = (FormattedValue)value;
            super.getTableCellRendererComponent(table, fv.getText(), false, false, row, column);
            this.setBackground(fv.getBgColor());
            this.setForeground(fv.getFgColor());
            this.setHorizontalAlignment(fv.getHorizontalAlignment());
            this.setToolTipText(fv.getToolTip());
        } else if (value == null) {
            super.getTableCellRendererComponent(table, "", false, false, row, column);
            this.setBackground(MonitorFormat.COLOR_OFF);
        } else {
            super.getTableCellRendererComponent(table, value.toString(), false, false, row, column);
            this.setHorizontalAlignment(0);
        }
        if (this.ensureWidth && (w = this.getMinimumSize().width + 2) > (c = table.getColumnModel().getColumn(column)).getMinWidth()) {
            c.setMinWidth(w);
        }
        if (this.ensureHeight && (h = this.getMinimumSize().height) > table.getRowHeight(row)) {
            table.setRowHeight(row, h);
        }
        return this;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

