/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;

class AgentDictionaries
implements Serializable {
    final AgentInfo ai;
    final Map<String, Dictionary> dictionaries = new HashMap<String, Dictionary>();
    final Map<String, CommandSet> commandSets = new HashMap<String, CommandSet>();

    AgentDictionaries(AgentInfo ai) {
        this.ai = ai;
    }

    void update(RouteSelectionCommandSet rsc) {
        this.commandSets.clear();
        this.dictionaries.clear();
        for (Map.Entry entry : rsc.getCommandSetsForRoute(this.ai.getName()).entrySet()) {
            this.commandSets.put((String)entry.getKey(), (CommandSet)entry.getValue());
            this.dictionaries.put((String)entry.getKey(), ((CommandSet)entry.getValue()).getCommandDictionary());
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.ai);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentDictionaries other = (AgentDictionaries)obj;
        return Objects.equals(this.ai, other.ai);
    }
}

