/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.adapter;

import hep.aida.ITree;
import hep.aida.ref.tree.Tree;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreePlugin;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.images.ImageHandler;

public class FolderAdapter
extends DefaultFTreeNodeAdapter {
    private static final Icon nonSelectedLeafIcon = ImageHandler.getIcon((String)"images/NonSelectedLeafNodeIcon.gif", FTreePlugin.class);
    private static final Icon selectedLeafIcon = ImageHandler.getIcon((String)"images/SelectedLeafIcon.gif", FTreePlugin.class);
    protected AIDAPlugin plugin;
    protected Studio app;
    protected Commands commands;
    protected boolean showEmptyFolderAsLeaf;
    protected Tree aidaMasterTree;

    public FolderAdapter(AIDAPlugin plugin, Studio app) {
        this(100, plugin, app);
    }

    public FolderAdapter(int priority, AIDAPlugin plugin, Studio app) {
        super(priority);
        this.plugin = plugin;
        this.app = app;
        this.commands = new Commands();
        this.showEmptyFolderAsLeaf = false;
        this.aidaMasterTree = (Tree)app.getLookup().lookup(ITree.class);
    }

    public void setShowEmptyFolderAsLeaf(boolean b) {
        this.showEmptyFolderAsLeaf = b;
    }

    public boolean getShowEmptyFolderAsLeaf() {
        return this.showEmptyFolderAsLeaf;
    }

    public void checkForChildren(FTreeNode node) {
        Object obj = node.value((Object)"folderChildrenChecked");
        if (obj == null) {
            node.addKey((Object)"folderChildrenChecked", (Object)new Boolean(true));
            this.plugin.checkForChildrenForNode(node.path());
        }
    }

    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        this.commands.setPath(this.plugin.fullPath(nodes[0].path()));
        if (menu.getSubElements().length != 0) {
            menu.addSeparator();
        }
        JMenuItem item = new JMenuItem("Make Current Directory");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Clear All");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Delete");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        return menu;
    }

    public boolean allowsChildren(FTreeNode node, boolean allowsChildren) {
        return true;
    }

    public Icon icon(FTreeNode node, Icon oldIcon, boolean selected, boolean expanded) {
        return oldIcon;
    }

    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        FTreeNode[] nodes = selectedNodes;
        this.commands.setPath(this.plugin.fullPath(nodes[0].path()));
        return this.commands;
    }

    public class Commands
    extends CommandProcessor {
        private String path;
        ITree masterTree;

        public Commands() {
            this.masterTree = (ITree)FolderAdapter.this.app.getLookup().lookup(ITree.class);
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void onMakeCurrentDirectory() {
            this.masterTree.cd(this.path);
        }

        public void enableMakeCurrentDirectory(CommandState state) {
            state.setEnabled(!this.masterTree.pwd().equals(this.path));
        }

        public void onDelete() {
            this.masterTree.rmdir(this.path);
        }
    }
}

