package org.lsst.ccs.subsystem.demo.bus;

/**
 * A Demo State
 * @author The LSST CCS Team
 */

public enum DemoState {

    /**
     * The NOMINAL AlertState signifies that a given quantity has gone back
     * within acceptable limits. Alerts are not raised when the AlertState
     * is NOMINAL. There is no effect on the AlertState of the agent.
     * 
     */
    NOMINAL,

    /**
     * The WARNING AlertState signifies that a given quantity has reached
     * the warning level. The corresponding Alert is raised and the AlertState
     * of the Agent will switch to WARNING if it was previously NOMINAL, 
     * otherwise the AlertState of the agent will remain unchanged.
     * 
     */
    WARNING,
    
    /**
     * The ALARM AlertState signifies that a given quantity has reached
     * the alarm level. The corresponding Alert is raised and the AlertState
     * of the agent will switch to ALARM if it was previously either NOMINAL or 
     * WARNING, otherwise the AlertState of the agent will remain unchanged.
     * 
     */
    ALARM;    
}
