package org.lsst.ccs.subsystem.demo.bus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 *
 * @author The LSST CCS Team
 */
public class DemoData implements Serializable {

    static Random r = new Random();

    private final double temp, value, sine;
    
    private final Map<String, Double> otherData = new HashMap<>();

    public DemoData(int size) {
        temp = r.nextDouble();
        value = r.nextGaussian();
        double currentTime = System.currentTimeMillis();
        double period = 5 * 60 * 1000;
        double dt = currentTime % period;
        sine = 20 * Math.sin(2 * Math.PI / period * dt) + 2*r.nextDouble()-1;        
        for ( int i = 0; i < size; i++ ) {            
            otherData.put(String.valueOf(i), new Double(i));
        }     
    }
    
    public double getSineValue() {
        return sine;
    }
}
