/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.utilities.location.Location;

public class StoreSimulation {
    private final List<TriggerListener> listeners = new CopyOnWriteArrayList<TriggerListener>();
    private static final StoreSimulation singleton = new StoreSimulation();

    private StoreSimulation() {
    }

    public static StoreSimulation instance() {
        return singleton;
    }

    public void addTriggerListener(TriggerListener listener) {
        this.listeners.add(listener);
    }

    public void removeTriggerListener(TriggerListener listener) {
        this.listeners.remove(listener);
    }

    void fireTrigger(int opcode, ImageMetaData meta, Map<Location.LocationType, int[]> registerLists) {
        for (TriggerListener l : this.listeners) {
            l.trigger(opcode, meta, registerLists);
        }
    }

    public static interface TriggerListener {
        public void trigger(int var1, ImageMetaData var2, Map<Location.LocationType, int[]> var3);
    }
}

