/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control.event;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEvent;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.threadpool.PoolConfiguration;
import org.apache.commons.jcs3.utils.threadpool.ThreadPoolManager;

public class ElementEventQueue
implements IElementEventQueue {
    private static final String THREAD_PREFIX = "JCS-ElementEventQueue-";
    private static final Log log = LogManager.getLog(ElementEventQueue.class);
    private boolean destroyed = false;
    private ExecutorService queueProcessor = ThreadPoolManager.getInstance().createPool(new PoolConfiguration(false, 0, 1, 1, 0, PoolConfiguration.WhenBlockedPolicy.RUN, 1), "JCS-ElementEventQueue-");

    public ElementEventQueue() {
        log.debug("Constructed: {0}", this);
    }

    @Override
    public void dispose() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.queueProcessor.shutdownNow();
            this.queueProcessor = null;
            log.info("Element event queue destroyed: {0}", this);
        }
    }

    @Override
    public <T> void addElementEvent(IElementEventHandler hand, IElementEvent<T> event) throws IOException {
        log.debug("Adding Event Handler to QUEUE, !destroyed = {0}", !this.destroyed);
        if (this.destroyed) {
            log.warn("Event submitted to disposed element event queue {0}", event);
        } else {
            ElementEventRunner runner = new ElementEventRunner(hand, event);
            log.debug("runner = {0}", runner);
            this.queueProcessor.execute(runner);
        }
    }

    private class ElementEventRunner
    extends AbstractElementEventRunner {
        private final IElementEventHandler hand;
        private final IElementEvent<?> event;

        ElementEventRunner(IElementEventHandler hand, IElementEvent<?> event) throws IOException {
            log.debug("Constructing {0}", this);
            this.hand = hand;
            this.event = event;
        }

        @Override
        protected void doRun() throws IOException {
            this.hand.handleElementEvent(this.event);
        }
    }

    protected abstract class AbstractElementEventRunner
    implements Runnable {
        protected AbstractElementEventRunner() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (IOException e) {
                log.warn("Giving up element event handling {0}", ElementEventQueue.this, e);
            }
        }

        protected abstract void doRun() throws IOException;
    }
}

