/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.logging.Level;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.messaging.util.Dispatcher;

public class AlertGate {
    private final Dispatcher dispatcher;
    private final Alert alert;
    private final int vetoTime;
    private final double vetoFactor;
    private final int[] thresholds;
    private int lastValue;
    private long lastTime;
    private volatile int lastLevel = -1;

    public AlertGate(Dispatcher dispatcher, String alertID, String alertDescription, int[] thresholds, int vetoTime, double vetoFactor) {
        if (thresholds == null || thresholds.length == 0) {
            this.alert = null;
            this.thresholds = null;
        } else {
            this.alert = new Alert(alertID, alertDescription);
            this.thresholds = thresholds;
            dispatcher.registerAlert(this.alert);
        }
        this.dispatcher = dispatcher;
        this.vetoTime = vetoTime;
        this.vetoFactor = vetoFactor;
    }

    public AlertGate(Dispatcher dispatcher, String alertID, String alertDescription, int[] thresholds) {
        this(dispatcher, alertID, alertDescription, thresholds, 5000, 1.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(int value) {
        if (this.thresholds == null) {
            return;
        }
        int level = -1;
        int i = 0;
        while (i < this.thresholds.length && value > this.thresholds[i]) {
            level = i++;
        }
        if (level == -1 && this.lastLevel == -1) {
            return;
        }
        AlertGate alertGate = this;
        synchronized (alertGate) {
            if (level == -1) {
                this.lastValue = Integer.MIN_VALUE;
                this.lastTime = 0L;
                if (this.lastLevel > 0) {
                    this.dispatcher.raiseAlert(this.alert, AlertState.NOMINAL, this.getMessage(value));
                }
                this.lastLevel = -1;
            } else {
                long currentTime = System.currentTimeMillis();
                if (level != this.lastLevel || currentTime - this.lastTime > (long)this.vetoTime || (double)value > (double)this.lastValue * this.vetoFactor) {
                    this.lastValue = value;
                    this.lastTime = currentTime;
                    String message = this.getMessage(value);
                    Level logLevel = level == 0 ? Level.INFO : (level == 1 ? Level.WARNING : Level.SEVERE);
                    this.dispatcher.getLogger().log(logLevel, message);
                    if (level != 0 || this.lastLevel != -1) {
                        this.dispatcher.raiseAlert(this.alert, AlertState.values()[level], this.getMessage(value));
                    }
                    this.lastLevel = level;
                }
            }
        }
    }

    protected String getMessage(int value) {
        return "High value of " + this.alert.getAlertId() + " : " + value;
    }
}

