/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;

public class AlertEvent
extends EventObject {
    private final Alert alert;
    private final RaisedAlertSummary summary;
    private final List<String> clear;
    private final AlertEventType type;

    public AlertEvent(String source, Alert alert, RaisedAlertSummary summary, AlertEventType type) {
        super(source);
        this.alert = alert;
        this.summary = summary;
        this.clear = null;
        this.type = type;
    }

    public AlertEvent(String source, String[] clearedIDs, RaisedAlertSummary summary, AlertEventType type) {
        super(source);
        this.alert = null;
        this.summary = summary;
        this.clear = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(clearedIDs)));
        this.type = type;
    }

    @Override
    public String getSource() {
        return (String)super.getSource();
    }

    public Alert getAlert() {
        return this.alert;
    }

    public AlertState getLevel() {
        return this.alert == null ? AlertState.NOMINAL : this.summary.getRaisedAlert(this.alert.getAlertId()).getLatestAlertState();
    }

    public RaisedAlertSummary getSummary() {
        return this.summary;
    }

    public List<String> getClearedIds() {
        return this.clear;
    }

    public AlertEventType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.getSource() + ": " + this.getAlert();
    }

    public boolean isPartialClear(String id) {
        if (this.type != AlertEventType.ALERT_CLEARED) {
            throw new RuntimeException("This method can only be invoked for an ALERT_CLEARED event type (was " + (Object)((Object)this.type) + ")");
        }
        if (this.clear.contains(id)) {
            return this.summary.getRaisedAlert(id) != null;
        }
        throw new IllegalArgumentException("Alert id = " + id + " was not cleared.");
    }

    public AlertState getStateForClearedAlert(String id) {
        if (this.type != AlertEventType.ALERT_CLEARED) {
            throw new RuntimeException("This method can only be invoked for an ALERT_CLEARED event type (was " + (Object)((Object)this.type) + ")");
        }
        if (this.clear.contains(id)) {
            RaisedAlertHistory history = this.summary.getRaisedAlert(id);
            return history == null ? AlertState.NOMINAL : history.getHighestAlertState();
        }
        throw new IllegalArgumentException("Alert id = " + id + " was not cleared.");
    }

    public static enum AlertEventType {
        AGENT_CONNECTION,
        AGENT_DISCONNECTION,
        ALERT_RAISED,
        ALERT_CLEARED;

    }
}

