/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.utilities.logging.Logger;

final class LookupInjectUtils {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.lookupInject");

    private LookupInjectUtils() {
    }

    static void injectComponents(ComponentLookup lookup) {
        LookupInjectUtils.injectComponents(lookup, false, false);
    }

    static void injectComponents(ComponentLookup lookup, boolean useFullPath, boolean throwException) {
        TreeWalkerUtils.proceduralBiWalk(lookup, null, Object.class, (n, target) -> {
            try {
                for (Class<?> cls = target.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                    List<Field> fields = LookupInjectUtils.getFields(target);
                    for (Field field : fields) {
                        if (field.isAnnotationPresent(LookupField.class)) {
                            LookupInjectUtils.inject(lookup, n, target, field, useFullPath, throwException);
                        }
                        if (!field.getType().equals(String.class)) continue;
                        String value = null;
                        if (field.isAnnotationPresent(LookupName.class)) {
                            value = n.getKey();
                        } else if (field.isAnnotationPresent(LookupPath.class)) {
                            value = n.getPath();
                        }
                        if (value == null) continue;
                        field.setAccessible(true);
                        field.set(target, value);
                        field.setAccessible(false);
                    }
                }
            }
            catch (Exception ex) {
                log.warn((Object)("At node : " + n.getKey() + " : " + ex.getMessage()), (Throwable)ex);
                throw ex instanceof RuntimeException ? (RuntimeException)ex : new IllegalArgumentException(ex);
            }
        }, null);
    }

    private static <T> List<Field> getFields(T t) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field f : clazz.getDeclaredFields()) {
                if (fields.contains(f)) continue;
                fields.add(f);
            }
            for (Field f : clazz.getFields()) {
                if (fields.contains(f)) continue;
                fields.add(f);
            }
        }
        return fields;
    }

    private static void inject(ComponentLookup lookup, ComponentNode componentNode, Object obj, Field f, boolean useFullPath, boolean throwException) throws IllegalAccessException {
        LookupField lf = f.getAnnotation(LookupField.class);
        ArrayList<Object> extractedNodes = new ArrayList<Object>();
        Class<?> fieldClass = f.getType();
        Class<Object> elemClass = fieldClass;
        boolean isSingleElement = true;
        if (Collection.class.isAssignableFrom(fieldClass) || Map.class.isAssignableFrom(fieldClass) || fieldClass.isArray()) {
            isSingleElement = false;
            Type type = f.getGenericType();
            if (type instanceof ParameterizedType) {
                Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
                elemClass = (Class<Object>)typeArgs[typeArgs.length - 1];
            } else {
                elemClass = fieldClass.isArray() ? fieldClass.getComponentType() : Object.class;
            }
        }
        switch (lf.strategy()) {
            case TOP: {
                extractedNodes.add(lookup.getTopComponentNode());
                break;
            }
            case DESCENDANTS: {
                TreeWalkerUtils.proceduralBiWalk(lookup, componentNode, elemClass, (n, o) -> {
                    if (!n.getPath().equals(componentNode.getPath())) {
                        extractedNodes.add(n);
                    }
                }, null);
                break;
            }
            case CHILDREN: {
                List children = componentNode.getChildren();
                for (ComponentNode c : children) {
                    if (!elemClass.isAssignableFrom(c.getComponent().getClass())) continue;
                    extractedNodes.add(c);
                }
                break;
            }
            case SIBLINGS: {
                ComponentNode parent = componentNode.getParent();
                if (parent == null) break;
                List siblings = parent.getChildren();
                for (Object s : siblings) {
                    if (s.getPath().equals(componentNode.getPath()) || !elemClass.isAssignableFrom(s.getComponent().getClass())) continue;
                    extractedNodes.add(s);
                }
                break;
            }
            case TREE: {
                TreeWalkerUtils.proceduralBiWalk(lookup, null, elemClass, (n, o) -> extractedNodes.add(n), null);
                break;
            }
            case ANCESTORS: {
                for (ComponentNode node = componentNode.getParent(); node != null; node = node.getParent()) {
                    if (!elemClass.isAssignableFrom(node.getComponent().getClass())) continue;
                    extractedNodes.add(node);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("strategy " + lf.strategy() + " incompatible with filling collections of type : " + fieldClass);
            }
        }
        ComponentNode targetNode = lookup.getComponentNodeForObject(obj);
        String pathFilter = lf.pathFilter();
        LinkedHashMap<ComponentNode, String> filteredNodes = new LinkedHashMap<ComponentNode, String>();
        Pattern filterPattern = !pathFilter.isEmpty() ? Pattern.compile(pathFilter) : null;
        for (ComponentNode componentNode2 : extractedNodes) {
            if (filterPattern != null) {
                String string = LookupInjectUtils.getPathForMap(componentNode2, targetNode, useFullPath, lf.strategy());
                if (!filterPattern.matcher(string).matches()) continue;
                filteredNodes.put(componentNode2, string);
                continue;
            }
            filteredNodes.put(componentNode2, "");
        }
        if (!pathFilter.isEmpty() && filteredNodes.isEmpty()) {
            log.warning((Object)("Cound not find any matches for path filter " + pathFilter + " for component " + componentNode.getPath() + " " + componentNode.getComponent().getClass()));
        }
        if (!filteredNodes.isEmpty()) {
            log.fine((Object)("lookup strategy " + lf.strategy() + " collected " + filteredNodes.size() + " elements for field " + f.getName() + " of node " + componentNode.getPath()));
            f.setAccessible(true);
            if (isSingleElement) {
                if (filteredNodes.size() > 1) {
                    ArrayList<String> additionalNodes = new ArrayList<String>();
                    for (ComponentNode componentNode3 : filteredNodes.keySet()) {
                        additionalNodes.add(componentNode3.getPath());
                    }
                    log.warning((Object)("Found more than one element " + additionalNodes + " when setting field " + f.getName() + " of type " + f.getType() + " on node " + componentNode.getPath()));
                }
                f.set(obj, ((ComponentNode)filteredNodes.keySet().iterator().next()).getComponent());
            } else if (Map.class.isAssignableFrom(fieldClass)) {
                Map mapObj = (Map)f.get(obj);
                if (mapObj == null) {
                    log.severe((Object)"Field Maps must be instantiated in class.");
                }
                mapObj.clear();
                for (Map.Entry entry : filteredNodes.entrySet()) {
                    String path = (String)entry.getValue();
                    if (path.isEmpty()) {
                        path = LookupInjectUtils.getPathForMap((ComponentNode)entry.getKey(), targetNode, useFullPath, lf.strategy());
                    }
                    if (throwException && mapObj.containsKey(path)) {
                        RuntimeException e = new RuntimeException("Path " + path + " has already been added to the selected objects in the Lookup injection process");
                        throw e;
                    }
                    mapObj.put(path, ((ComponentNode)entry.getKey()).getComponent());
                }
            } else if (List.class.isAssignableFrom(fieldClass) || Set.class.isAssignableFrom(fieldClass)) {
                Collection colObj = (Collection)f.get(obj);
                if (colObj == null) {
                    log.severe((Object)"Field collections must be instantiated in class.");
                }
                colObj.clear();
                for (ComponentNode componentNode4 : filteredNodes.keySet()) {
                    colObj.add(componentNode4.getComponent());
                }
            } else if (fieldClass.isArray()) {
                ArrayList<Object> filteredObjects = new ArrayList<Object>();
                for (ComponentNode componentNode5 : filteredNodes.keySet()) {
                    filteredObjects.add(componentNode5.getComponent());
                }
                f.set(obj, filteredObjects.toArray((Object[])Array.newInstance(elemClass, filteredObjects.size())));
            }
            f.setAccessible(false);
        } else {
            log.fine((Object)("lookup strategy " + lf.strategy() + " collected no elements for field " + f.getName() + " of node " + componentNode.getPath()));
        }
    }

    private static String getPathForMap(ComponentNode node, ComponentNode targetNode, boolean useFullPath, LookupField.Strategy strategy) {
        if (!useFullPath) {
            return node.getKey();
        }
        switch (strategy) {
            case DESCENDANTS: {
                return LookupInjectUtils.getRelativePath(node, targetNode);
            }
            case TOP: 
            case CHILDREN: 
            case SIBLINGS: {
                return node.getKey();
            }
            case TREE: 
            case ANCESTORS: {
                return node.getPath();
            }
        }
        throw new IllegalArgumentException("Cannot use strategy " + strategy);
    }

    private static String getRelativePath(ComponentNode node, ComponentNode targetNode) {
        return LookupInjectUtils.getRelativePath("", node, targetNode);
    }

    private static String getRelativePath(String path, ComponentNode node, ComponentNode targetNode) {
        if (!path.isEmpty()) {
            path = "/" + path;
        }
        path = node.getKey() + path;
        if (node.getParent() == targetNode) {
            return path;
        }
        return LookupInjectUtils.getRelativePath(path, node.getParent(), targetNode);
    }
}

