/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.TokenizedCommand;

class DefaultDictionaryCompleter
implements DictionaryCompleter,
Serializable {
    private static final long serialVersionUID = 8413764867907456999L;
    private final Dictionary dict;

    public DefaultDictionaryCompleter(Dictionary dict) {
        this.dict = dict;
    }

    @Override
    public int complete(String buffer, int index, List<CharSequence> list) {
        TreeSet<String> set;
        boolean isCompletingOption;
        boolean endsWithWhiteSpace;
        TokenizedCommand tc = new TokenizedCommand(buffer.substring(0, index));
        int argCount = tc.getArgumentCount();
        boolean bl = endsWithWhiteSpace = !tc.isEmpty() && Character.isWhitespace(buffer.charAt(index - 1));
        if (endsWithWhiteSpace) {
            ++argCount;
        }
        if (this.dict == null) {
            return index;
        }
        boolean bl2 = isCompletingOption = tc.getLastToken() != null && tc.getLastToken().isOption();
        if (isCompletingOption) {
            boolean isShortOption = tc.getLastToken().isShortOption();
            String startOpt = tc.getLastToken().getString();
            ArrayList<List<SupportedOption>> supportedOptions = new ArrayList<List<SupportedOption>>();
            String commandName = tc.getCommand();
            for (DictionaryCommand dictionaryCommand : this.dict.filterByVisibilityIterator()) {
                String command = dictionaryCommand.getCommandName();
                if (!command.equals(commandName) || !dictionaryCommand.hasOptions() || dictionaryCommand.getArguments().length < argCount && !dictionaryCommand.isVarArgs()) continue;
                supportedOptions.add(dictionaryCommand.getSupportedOptions());
            }
            if (supportedOptions.size() == 1) {
                List opts = (List)supportedOptions.get(0);
                for (SupportedOption opt : opts) {
                    if (isShortOption) {
                        if (tc.getOptions().hasOption(opt.getName()) || tc.getOptions().hasOption(opt.getSingleLetterName())) continue;
                        list.add(opt.getSingleLetterName() + " ");
                        continue;
                    }
                    if (!startOpt.isEmpty() && opt.getName().startsWith(startOpt)) {
                        list.add(opt.getName() + " ");
                        continue;
                    }
                    if (!startOpt.isEmpty() || tc.getOptions().hasOption(opt.getName()) || tc.getOptions().hasOption(opt.getSingleLetterName())) continue;
                    list.add(opt.getName() + " ");
                }
            }
            if (isShortOption) {
                return index;
            }
            return tc.getLastToken().getLocation();
        }
        if (tc.isEmpty()) {
            set = new TreeSet<String>();
            for (DictionaryCommand def : this.dict.filterByVisibilityIterator()) {
                String command = def.getCommandName();
                command = command + " ";
                set.add(command);
                for (String alias : def.getAliases()) {
                    alias = alias + " ";
                    set.add(alias);
                }
            }
        } else {
            if (argCount == 0) {
                String prefix = tc.getCommand();
                TreeSet<String> set2 = new TreeSet<String>();
                HashSet<DictionaryCommand> uniqueCommands = new HashSet<DictionaryCommand>();
                for (DictionaryCommand def : this.dict.filterByVisibilityIterator()) {
                    String string = def.getCommandName();
                    if (string.startsWith(prefix)) {
                        String string2 = string + " ";
                        set2.add(string2);
                        uniqueCommands.add(def);
                    }
                    for (String alias : def.getAliases()) {
                        if (!alias.startsWith(prefix)) continue;
                        alias = alias + " ";
                        set2.add(alias);
                        uniqueCommands.add(def);
                    }
                }
                if (set2.size() > 1 && uniqueCommands.size() == 1) {
                    list.add(((DictionaryCommand)uniqueCommands.iterator().next()).getCommandName() + " ");
                } else {
                    list.addAll(set2);
                }
                return tc.getCommandLocation();
            }
            String command = tc.getCommand();
            String lastArg = endsWithWhiteSpace ? "" : tc.getArgument(argCount - 1);
            ArrayList<String> defaultCompletions = new ArrayList<String>();
            boolean useDefaultCompletions = true;
            for (DictionaryCommand dictionaryCommand : this.dict.filterByVisibilityIterator()) {
                if (!dictionaryCommand.matchesCommandOrAlias(command) || dictionaryCommand.getArguments().length < argCount && !dictionaryCommand.isVarArgs()) continue;
                int currentArgIndex = Math.min(argCount, dictionaryCommand.getArguments().length) - 1;
                DictionaryArgument currentArg = dictionaryCommand.getArguments()[currentArgIndex];
                boolean skipCurrentCommand = false;
                for (int i = currentArgIndex - 1; i >= 0; --i) {
                    DictionaryArgument previousArg = dictionaryCommand.getArguments()[i];
                    if (previousArg.getAllowedValues().size() <= 0 || previousArg.getAllowedValues().contains(tc.getArgument(i))) continue;
                    skipCurrentCommand = true;
                }
                if (skipCurrentCommand) continue;
                List<String> values = currentArg.getAllowedValues();
                if (values.isEmpty()) {
                    String helpStr = "# " + currentArg.getName() + " " + currentArg.getSimpleType() + " " + currentArg.getDescription();
                    if (defaultCompletions.contains(helpStr)) continue;
                    defaultCompletions.add(helpStr);
                    continue;
                }
                useDefaultCompletions = false;
                for (String value : values) {
                    if (!DefaultDictionaryCompleter.startsWithIgnoreCase(value, lastArg) || list.contains(value = value + " ")) continue;
                    list.add(value);
                }
            }
            if (useDefaultCompletions) {
                for (String string : defaultCompletions) {
                    list.add(string);
                }
            }
            return endsWithWhiteSpace ? index : tc.getArgumentLocation(argCount - 1);
        }
        list.addAll(set);
        return index;
    }

    private static boolean startsWithIgnoreCase(String reference, String test) {
        if (test.length() > reference.length()) {
            return false;
        }
        return reference.substring(0, test.length()).equalsIgnoreCase(test);
    }
}

