import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.subsystem.daq.DaqStoreManageDevice;
import org.lsst.ccs.subsystem.daq.DaqSubsystem;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["daq-monitor"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()

Class storeManagerClass = Class.forName("org.lsst.ccs.subsystem.daq.DaqStoreManageDevice");

builder.daq (DaqSubsystem)
{
    store(storeManagerClass)
    {
        Capacity (Channel, description:"total disk space",
                  devcName:"store", type:"DAQ_CAPACITY",
                  units:"Gbytes", format:"%.2f",
                  checkLo:"none", checkHi:"none")
        FreeSpace (Channel, description:"available disk space",
                   devcName:"store",type:"DAQ_REMAINING",
                   units:"Gbytes", format:"%.2f",
                   checkLo:"none", checkHi:"none")
        FreeFraction (Channel, description:"available-space fraction",
                      devcName:"store",type:"DAQ_FREE_FRACTION",
                      units:"", format:"%.4f", checkHi:"none", 
                      checkLo:"flag", limitLo:0.10, dbandLo:0.10)
    }
}
