/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.daq;

import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.daq.DaqStoreManageDevice;

public class DaqSubsystem
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private DaqStoreManageDevice storeManager;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alert;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupName
    private String name;
    private static final Logger LOG = Logger.getLogger(DaqSubsystem.class.getName());

    public DaqSubsystem() {
        super("daqsub", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void postInit() {
    }

    public void start() {
        if (!RunMode.isSimulation() && !this.storeManager.isOnline()) {
            throw new RuntimeException("DAQ store not connected");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="purge", description="Purge older files in DAQ two-day store")
    public void purge() throws DAQException {
        this.storeManager.purge();
    }
}

