/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.utilities.location.Location;

class ReadoutConfig {
    private static final Map<Location.LocationType, int[]> DATA_SEGMENT_MAP = new HashMap<Location.LocationType, int[]>();
    private static final Map<Location.LocationType, int[]> DATA_SENSOR_MAP = new HashMap<Location.LocationType, int[]>();
    private static final Map<Location.LocationType, Integer> XOR_MAP = new HashMap<Location.LocationType, Integer>();
    private final Location.LocationType sourceType;

    ReadoutConfig(Location.LocationType sourceType) {
        this.sourceType = sourceType;
    }

    int[] getDataSegmentMap() {
        return DATA_SEGMENT_MAP.get(this.sourceType);
    }

    int[] getDataSensorMap() {
        return DATA_SENSOR_MAP.get(this.sourceType);
    }

    int getXor() {
        return XOR_MAP.get(this.sourceType);
    }

    static {
        DATA_SEGMENT_MAP.put(Location.LocationType.SCIENCE, new int[]{15, 14, 13, 12, 11, 10, 9, 8, 0, 1, 2, 3, 4, 5, 6, 7});
        DATA_SEGMENT_MAP.put(Location.LocationType.GUIDER, new int[]{7, 6, 5, 4, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8});
        DATA_SEGMENT_MAP.put(Location.LocationType.WAVEFRONT, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        DATA_SENSOR_MAP.put(Location.LocationType.SCIENCE, new int[]{2, 1, 0});
        DATA_SENSOR_MAP.put(Location.LocationType.GUIDER, new int[]{1, 0});
        DATA_SENSOR_MAP.put(Location.LocationType.WAVEFRONT, new int[]{0, 1});
        XOR_MAP.put(Location.LocationType.SCIENCE, 131071);
        XOR_MAP.put(Location.LocationType.GUIDER, 131072);
        XOR_MAP.put(Location.LocationType.WAVEFRONT, 131072);
    }
}

