/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices;

import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePWM;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;

public class Maq20PWMControl
implements HasLifecycle,
Maq20Device.Maq20DiscControl {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Maq20Device maqDevc;
    @ConfigurationParameter
    private double frequency = 1000.0;
    @ConfigurationParameter
    private double dutyCycle1 = 0.0;
    @ConfigurationParameter
    private double dutyCycle2 = 0.0;
    private String type;
    private static final Logger LOG = Logger.getLogger(Maq20PWMControl.class.getName());
    private Maq20Device.ModuleData modData;
    private Maq20DiscretePWM pwm;
    private int funcNum;
    private boolean inited = false;

    public void init() {
        String[] words;
        if (this.type == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "type", "not specified");
        }
        if ((words = this.type.split(":")).length != 2) {
            ErrorUtils.reportConfigError(LOG, this.name, "type", "doesn't have exactly two elements");
        }
        try {
            int modIx = Integer.decode(words[0]);
            this.modData = this.maqDevc.getModuleData(modIx);
            if (this.modData == null) {
                ErrorUtils.reportConfigError(LOG, this.name, "module " + modIx, "doesn't exist");
            }
        }
        catch (NumberFormatException ex) {
            ErrorUtils.reportConfigError(LOG, this.name, "module index (" + words[0] + ")", "is not numeric");
        }
        if (!words[1].equals("0") && !words[1].equals("1")) {
            ErrorUtils.reportConfigError(LOG, this.name, "function number (" + words[1] + ")", "is not 0 or 1");
        }
        this.funcNum = Integer.decode(words[1]);
    }

    @Override
    public void initialize() throws DriverException {
        this.pwm = this.modData.maqDiscPWM;
        this.inited = true;
        this.checkPWM();
        if (this.pwm.isEnabled(this.funcNum)) {
            this.fetch();
        } else {
            this.pwm.enable(this.funcNum);
        }
        this.load();
    }

    @ConfigurationParameterChanger
    public void setFrequency(double freq) throws DriverException {
        double d = this.frequency = freq > 0.0 && freq <= 1000.0 ? freq : 1000.0;
        if (this.inited) {
            this.load();
        }
    }

    @Command(description="Get frequency")
    public double getFrequency() {
        return this.frequency;
    }

    @ConfigurationParameterChanger
    public void setDutyCycle1(double duty) throws DriverException {
        this.dutyCycle1 = Math.min(Math.max(duty, 0.0), 1.0);
        if (this.inited) {
            this.checkPWM();
            int period = (int)(1000000.0 / this.frequency);
            this.pwm.setLowTime1(this.funcNum, (int)((double)period * (1.0 - this.dutyCycle1)));
            this.pwm.armFunction(this.funcNum);
        }
    }

    @Command(description="Get duty cycle 1")
    public double getDutyCycle1() {
        return this.dutyCycle1;
    }

    @ConfigurationParameterChanger
    public void setDutyCycle2(double duty) throws DriverException {
        this.dutyCycle2 = Math.min(Math.max(duty, 0.0), 1.0);
        if (this.inited) {
            this.checkPWM();
            int period = (int)(1000000.0 / this.frequency);
            this.pwm.setLowTime2(this.funcNum, (int)((double)period * (1.0 - this.dutyCycle2)));
            this.pwm.enableOutput2(this.funcNum, this.dutyCycle2 != 0.0);
            this.pwm.armFunction(this.funcNum);
        }
    }

    @Command(description="Get duty cycle 2")
    public double getDutyCycle2() {
        return this.dutyCycle2;
    }

    private void load() throws DriverException {
        this.checkPWM();
        this.pwm.setTimebase(this.funcNum, 2);
        double period = 1000000.0 / this.frequency;
        this.pwm.setPeriod(this.funcNum, (int)period);
        this.pwm.setLowTime1(this.funcNum, (int)(period * (1.0 - this.dutyCycle1)));
        this.pwm.setLowTime2(this.funcNum, (int)(period * (1.0 - this.dutyCycle2)));
        this.pwm.enableOutput2(this.funcNum, this.dutyCycle2 != 0.0);
        this.pwm.armFunction(this.funcNum);
    }

    private void fetch() throws DriverException {
        this.checkPWM();
        int timeBase = this.pwm.getTimebase(this.funcNum);
        int mult = timeBase == 2 ? 1 : (timeBase == 1 ? 1000 : 1000000);
        double period = mult * this.pwm.getPeriod(this.funcNum);
        this.setDutyCycle1(1.0 - (double)(mult * this.pwm.getLowTime1(this.funcNum)) / period);
        this.setDutyCycle2(1.0 - (double)(mult * this.pwm.getLowTime2(this.funcNum)) / period);
    }

    private void checkPWM() throws DriverException {
        if (this.pwm == null) {
            throw new DriverException("Cannot access PWM function");
        }
    }
}

