/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.optpage.LsstOptionalPageService;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Console
extends Subsystem {
    private static final Jas3Console agent = new Jas3Console();
    private final AgentStatusAggregator aggregator = new AgentStatusAggregator();
    private int statusMessageID = 0;
    private final TreeMap<Integer, String> statusMessageHistory = new TreeMap();
    private final int STATUS_HISTORY_SIZE = 30;

    protected Console() {
        super("CCS-Graphical-Console", AgentInfo.AgentType.CONSOLE);
    }

    public void preStart() {
        this.aggregator.initialize();
        this.getConsoleLookup().add((Object)this.aggregator);
        try {
            Enumeration<URL> e2 = ((Object)((Object)this)).getClass().getClassLoader().getResources("gui/lookup.txt");
            while (e2.hasMoreElements()) {
                URL url = e2.nextElement();
                try {
                    InputStream ins = url.openStream();
                    Throwable throwable = null;
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(ins));
                        Throwable throwable2 = null;
                        try {
                            String[] ss;
                            String line;
                            while ((line = in.readLine()) != null && (ss = line.trim().split("=")).length == 2) {
                                if (ss[0].isEmpty()) {
                                    this.getConsoleLookup().add((Object)ss[1]);
                                    continue;
                                }
                                this.getConsoleLookup().add((Object)ss[1], ss[0]);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ins == null) continue;
                        if (throwable != null) {
                            try {
                                ins.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        ins.close();
                    }
                }
                catch (IOException ins) {}
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        AbstractAction act = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.save();
            }
        };
        this.addMenu(act, "", "File:-2:3", "Session:1");
        act = new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.saveAs();
            }
        };
        this.addMenu(act, "", "File:-2:3", "Session:2");
        act = new AbstractAction("Restore"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.restore();
            }
        };
        this.addMenu(act, "", "File:-2:3", "Session:3");
        act = new AbstractAction("Restore From..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.restoreFrom();
            }
        };
        this.addMenu(act, "", "File:-2:3", "Session:4");
        act = new AbstractAction("CCS Console Developer's Guide"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.showInBrowser("https://confluence.slac.stanford.edu/display/LSSTCAM/Graphical+Console+Plugin+Developer%27s+Guide");
            }
        };
        this.addMenu(act, "", "Help", "Documentation:300");
        final PanelManager panMan = this.getPanelManager();
        AbstractAction saveAsAct = new AbstractAction("Save..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = panMan.getSelectedPanel(PanelType.DATA);
                try {
                    Consumer task = (Consumer)panMan.get(c, Panel.ON_SAVE_AS);
                    task.accept((JComponent)c);
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        };
        saveAsAct.setEnabled(false);
        this.addMenu(saveAsAct, "", "File:-2:4", "Page:1");
        AbstractAction editAct = new AbstractAction("Edit..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = panMan.getSelectedPanel(PanelType.DATA);
                try {
                    Consumer task = (Consumer)panMan.get(c, Panel.ON_EDIT);
                    task.accept((JComponent)c);
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        };
        editAct.setEnabled(false);
        this.addMenu(editAct, "", "File:-2:4", "Page:2");
        panMan.addListener(e -> {
            Component c;
            Panel eventType = e.getStandardKey();
            if ((eventType == Panel.SELECTED || eventType == Panel.OPEN) && (c = panMan.getSelectedPanel(PanelType.DATA)) instanceof JComponent) {
                JComponent panel = (JComponent)c;
                saveAsAct.setEnabled(panMan.get((Component)panel, Panel.ON_SAVE_AS) != null);
                editAct.setEnabled(panMan.get((Component)panel, Panel.ON_EDIT) != null);
            }
        });
    }

    public void afterStart() {
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void disconnected(AgentInfo ... agents) {
                SwingUtilities.invokeLater(() -> {
                    for (AgentInfo agent : agents) {
                        Console.getConsole().removeMenu("CCS Subsystems", agent.getName());
                    }
                });
            }
        });
    }

    public void preShutdown() {
        this.aggregator.shutdown();
    }

    public static Console getConsole() {
        return agent;
    }

    public <T> T getSingleton(Class<T> clazz) {
        if (AgentStatusAggregator.class.equals(clazz)) {
            return (T)this.aggregator;
        }
        if (PanelManager.class.equals(clazz)) {
            return (T)this.getPanelManager();
        }
        if (AgentService.class.isAssignableFrom(clazz)) {
            return (T)this.getAgentService(clazz);
        }
        return (T)this.getConsoleLookup().lookup(clazz);
    }

    public abstract FreeHEPLookup getConsoleLookup();

    public abstract Window getWindow();

    public Logger getLoggerUI() {
        return Logger.getLogger((String)"org.lsst.ccs.ui");
    }

    public abstract Path getHomeDirectory();

    public abstract PanelManager getPanelManager();

    public AgentStatusAggregator getStatusAggregator() {
        return this.aggregator;
    }

    public abstract void error(String var1);

    public abstract void error(String var1, Exception var2);

    public abstract void showInBrowser(String var1);

    public abstract void setStatusMessage(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setStatusMessage(String message, int id) {
        TreeMap<Integer, String> treeMap = this.statusMessageHistory;
        synchronized (treeMap) {
            block14: {
                block15: {
                    if (id == 0) {
                        if (message == null) {
                            this.statusMessageHistory.clear();
                            this.statusMessageID = 0;
                            this.setStatusMessage(null);
                            break block14;
                        } else {
                            int n = this.statusMessageID = this.statusMessageHistory.isEmpty() ? 1 : this.statusMessageHistory.lastKey() + 1;
                            if (this.statusMessageID == Integer.MAX_VALUE) {
                                this.statusMessageHistory.clear();
                                this.statusMessageID = 1;
                            }
                            while (true) {
                                if (this.statusMessageHistory.size() <= 30) {
                                    this.statusMessageHistory.put(this.statusMessageID, message);
                                    this.setStatusMessage(message);
                                    return this.statusMessageID;
                                }
                                this.statusMessageHistory.pollFirstEntry();
                            }
                        }
                    }
                    if (id != this.statusMessageID) break block15;
                    if (message == null) {
                        this.statusMessageHistory.remove(id);
                        Map.Entry<Integer, String> e = this.statusMessageHistory.lastEntry();
                        if (e == null) {
                            this.statusMessageID = 0;
                            this.setStatusMessage(null);
                            break block14;
                        } else {
                            this.statusMessageID = e.getKey();
                            this.setStatusMessage(e.getValue());
                        }
                        break block14;
                    } else {
                        this.statusMessageHistory.replace(id, message);
                        this.setStatusMessage(message);
                    }
                    break block14;
                }
                if (message == null) {
                    this.statusMessageHistory.remove(id);
                } else {
                    this.statusMessageHistory.replace(id, message);
                }
            }
            return id;
        }
    }

    @Deprecated
    public void addOptionalPage(OptionalPage descriptor) {
        LsstOptionalPageService service = (LsstOptionalPageService)this.getConsoleLookup().lookup(LsstOptionalPageService.class);
        if (service != null) {
            service.add(descriptor);
        }
    }

    @Deprecated
    public void removeOptionalPage(String path) {
        LsstOptionalPageService service = (LsstOptionalPageService)this.getConsoleLookup().lookup(LsstOptionalPageService.class);
        if (service != null) {
            service.remove(path);
        }
    }

    @Deprecated
    public void removeOptionalPage(OptionalPage descriptor) {
        LsstOptionalPageService service = this.getOptionalPageService();
        if (service != null) {
            service.remove(descriptor);
        }
    }

    public LsstOptionalPageService getOptionalPageService() {
        return (LsstOptionalPageService)this.getConsoleLookup().lookup(LsstOptionalPageService.class);
    }

    public abstract Object addProperty(String var1, Object var2);

    public abstract Object removeProperty(String var1);

    public abstract Object getProperty(String var1);

    public abstract Object setProperty(String var1, Object var2);

    public void setProperties(Map<String, Object> properties) {
        properties.forEach((key, value) -> this.setProperty((String)key, value));
    }

    public abstract void addPropertyListener(PropertyListener var1, String var2);

    public abstract boolean removePropertyListener(PropertyListener var1);

    public abstract void addPreference(String[] var1, String var2, String var3);

    public abstract void addMenu(Action var1, String var2, String ... var3);

    public abstract boolean removeMenu(String ... var1);

    @Deprecated
    public Object sendCommand(Duration timeout, String command, Object ... args) throws Exception {
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.getMessagingAccess());
        int i = command.lastIndexOf("/");
        if (i == -1) {
            throw new IllegalArgumentException("Illegal command: " + command + ". Use \"agent[/component]/method\" format.");
        }
        String dst = command.substring(0, i);
        String cmnd = command.substring(i + 1);
        CommandRequest cmd = new CommandRequest(dst, cmnd, args);
        return cmu.sendSynchronousCommand(cmd, timeout);
    }

    @Deprecated
    public void sendCommand(String command, Object ... args) {
        Thread t = new Thread(() -> {
            try {
                this.sendCommand(Duration.ofSeconds(1L), command, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, "Temporary thread sending command");
        t.start();
    }

    public abstract void restore();

    public abstract void restoreFrom();

    public abstract void save();

    public abstract void saveAs();

    public static interface PropertyListener {
        public void propertiesChanged(Object var1, Map<String, Object> var2);
    }
}

