/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.crypto.SecretKey;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Encrypt;

@MBean(description="Symmetric encryption protocol. The (shared) shared secret key is configured up front, e.g. via a key store, or injection")
public class SYM_ENCRYPT
extends Encrypt<KeyStore.SecretKeyEntry> {
    @Property(description="File on classpath that contains keystore repository")
    protected String keystore_name;
    @Property(description="The type of the keystore. Types are listed in http://docs.oracle.com/javase/8/docs/technotes/tools/unix/keytool.html")
    protected String keystore_type = "pkcs12";
    @Property(description="Password used to check the integrity/unlock the keystore. Change the default", exposeAsManagedAttribute=false)
    protected String store_password = "changeit";
    @Property(description="Password for recovering the key. Change the default", exposeAsManagedAttribute=false)
    protected String key_password;
    @Property(name="alias", description="Alias used for recovering the key. Change the default", exposeAsManagedAttribute=false)
    protected String alias = "mykey";

    public String keystoreName() {
        return this.keystore_name;
    }

    public SYM_ENCRYPT keystoreName(String n) {
        this.keystore_name = n;
        return this;
    }

    public String alias() {
        return this.alias;
    }

    public SYM_ENCRYPT alias(String a) {
        this.alias = a;
        return this;
    }

    public String storePassword() {
        return this.store_password;
    }

    public SYM_ENCRYPT storePassword(String pwd2) {
        this.store_password = pwd2;
        return this;
    }

    @Override
    public SYM_ENCRYPT setKeyStoreEntry(KeyStore.SecretKeyEntry entry) {
        return this.setSecretKey(entry.getSecretKey());
    }

    public SYM_ENCRYPT setSecretKey(SecretKey key) {
        String key_algorithm = key.getAlgorithm();
        if (this.sym_algorithm == null) {
            this.sym_algorithm = key_algorithm;
        } else if (!SYM_ENCRYPT.getAlgorithm(this.sym_algorithm).equals(key_algorithm)) {
            if (SYM_ENCRYPT.getModeAndPadding(this.sym_algorithm) != null) {
                this.log.warn("%s: replacing sym_algorithm %s with key algorithm %s", this.local_addr, this.sym_algorithm, key_algorithm);
            }
            this.sym_algorithm = key_algorithm;
        }
        this.secret_key = key;
        return this;
    }

    @Override
    public void init() throws Exception {
        if (this.secret_key == null) {
            this.readSecretKeyFromKeystore();
        }
        super.init();
    }

    protected void readSecretKeyFromKeystore() throws Exception {
        KeyStore store = KeyStore.getInstance(this.keystore_type != null ? this.keystore_type : KeyStore.getDefaultType());
        if (this.key_password == null && this.store_password != null) {
            this.key_password = this.store_password;
            this.log.debug("%s: key_password used is same as store_password", this.local_addr);
        }
        try (InputStream inputStream = this.getKeyStoreSource();){
            store.load(inputStream, this.store_password.toCharArray());
        }
        if (!store.entryInstanceOf(this.alias, KeyStore.SecretKeyEntry.class)) {
            throw new Exception("Key '" + this.alias + "' from keystore " + this.keystore_name + " is not a secret key");
        }
        KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)store.getEntry(this.alias, new KeyStore.PasswordProtection(this.key_password.toCharArray()));
        if (entry == null) {
            throw new Exception("Key '" + this.alias + "' not found in keystore " + this.keystore_name);
        }
        this.setKeyStoreEntry(entry);
    }

    protected InputStream getKeyStoreSource() throws FileNotFoundException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keystore_name);
        return inputStream == null ? new FileInputStream(this.keystore_name) : inputStream;
    }
}

