/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisType;
import jas.plot.CoordinateTransformation;
import jas.plot.PlotGraphics;
import jas.plot.StringCoordinateTransformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;

public final class StringAxis
extends AxisType
implements StringCoordinateTransformation {
    public static final int CENTER_TEXT_IN_DIVISION = 1;
    public static final int TEXT_BESIDE_DIVISION = 2;
    private int labelPlacementStyle;
    private Hashtable hash;
    private final int majorTickLength = 5;
    private final int minorTickLength = 3;
    private final int minSpaceBetweenLabels = 3;
    private String[] labels;
    private int[] layers;

    public StringAxis() {
        this(1);
    }

    public StringAxis(int labelPlacementStyle) {
        this.labelPlacementStyle = labelPlacementStyle;
    }

    public void setLabelPlacementStyle(int labelPlacementStyle) {
        this.labelPlacementStyle = labelPlacementStyle;
    }

    public int getLabelPlacementStyle() {
        return this.labelPlacementStyle;
    }

    public void setLabels(String[] labels) {
        if (this.hash == null) {
            this.hash = new Hashtable(labels.length);
        } else {
            this.hash.clear();
        }
        this.labels = labels;
        for (int i = 0; i < labels.length; ++i) {
            this.hash.put(labels[i], new Integer(i));
        }
        if (this.axis != null && this.axis.getAxisOrientation() == 2 && (this.layers == null || this.layers.length != labels.length)) {
            this.layers = new int[labels.length];
        }
        this.labelsValid = false;
    }

    public String[] getLabels() {
        return this.labels;
    }

    @Override
    CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    @Override
    void assumeAxisLength(int lengthOfAxisLine) {
        int distanceFromEnd;
        if (this.labels == null || this.labels.length == 0) {
            return;
        }
        this.labelsValid = true;
        Font font = this.axis.getFont();
        FontMetrics fm = this.axis.getToolkit().getFontMetrics(font);
        int n = distanceFromEnd = this.labelPlacementStyle == 1 ? lengthOfAxisLine / this.labels.length / 2 : 0;
        if (this.axis.getAxisOrientation() == 2) {
            this.spaceRequirements.flowPastEnd = this.labelPlacementStyle == 1 ? Math.max(fm.stringWidth(this.labels[this.labels.length - 1]) / 2 - lengthOfAxisLine / this.labels.length / 2, 0) : fm.stringWidth(this.labels[this.labels.length - 1]) / 2;
            this.spaceRequirements.width = Math.max(0, fm.stringWidth(this.labels[0]) / 2 - distanceFromEnd);
            int extraRows = 0;
            if (lengthOfAxisLine > 0) {
                int[] lastTakenPixelOnRow = new int[3];
                int n2 = this.labelPlacementStyle == 2 ? this.labels.length - 1 : this.labels.length;
                int xStart = this.spaceRequirements.width + 3;
                if (this.labelPlacementStyle == 1) {
                    xStart += lengthOfAxisLine / this.labels.length / 2;
                }
                for (int i = 0; i < this.labels.length; ++i) {
                    int x = xStart + i * lengthOfAxisLine / n2;
                    int row = 0;
                    int halfOfStringWidth = fm.stringWidth(this.labels[i]) / 2;
                    if (i != 0) {
                        while (x - halfOfStringWidth < lastTakenPixelOnRow[row]) {
                            if (++row < lastTakenPixelOnRow.length) continue;
                            int[] newArray = new int[lastTakenPixelOnRow.length * 2];
                            System.arraycopy(lastTakenPixelOnRow, 0, newArray, 0, lastTakenPixelOnRow.length);
                            lastTakenPixelOnRow = newArray;
                        }
                    }
                    if (row > extraRows) {
                        extraRows = row;
                    }
                    lastTakenPixelOnRow[row] = x + halfOfStringWidth + 3;
                    this.layers[i] = row;
                }
            }
            this.spaceRequirements.height = fm.getMaxAscent() + fm.getMaxDescent() + 7 + extraRows * fm.getHeight();
        } else {
            this.spaceRequirements.width = this.longestStringLength(fm, this.labels) + 7;
            this.spaceRequirements.height = Math.max(0, fm.getAscent() / 2 + fm.getMaxDescent() - distanceFromEnd);
            this.spaceRequirements.flowPastEnd = this.labelPlacementStyle == 1 ? Math.max(fm.getMaxAscent() - fm.getAscent() / 2 - lengthOfAxisLine / this.labels.length / 2, 0) : fm.getMaxAscent() - fm.getAscent() / 2;
        }
    }

    @Override
    void paintAxis(PlotGraphics g, double originX, double originY, double length, Color textColor, Color majorTickColor, Color minorTickColor) {
        block4: {
            if (this.labels == null) break block4;
            int n = this.labelPlacementStyle == 2 ? this.labels.length - 1 : this.labels.length;
            FontMetrics fm = g.getFontMetrics();
            if (this.axis.getAxisOrientation() == 2) {
                double xStart = this.labelPlacementStyle == 2 ? originX : originX + length / (double)this.labels.length / 2.0;
                double y = originY + (double)fm.getMaxAscent() + 7.0;
                double lineHeight = fm.getHeight();
                for (int i = 0; i < this.labels.length; ++i) {
                    double x = xStart + (double)i * length / (double)n;
                    g.setColor(majorTickColor);
                    g.drawLine(x, originY + 5.0, x, originY - 5.0);
                    g.setColor(textColor);
                    g.drawString(this.labels[i], x - (double)(fm.stringWidth(this.labels[i]) / 2), y + (double)this.layers[i] * lineHeight);
                }
            } else {
                double x = this.axis.onLeftSide ? originX - 7.0 : originX + 7.0;
                double yStart = this.labelPlacementStyle == 2 ? originY : originY - length / (double)this.labels.length / 2.0;
                double height = fm.getAscent() / 2;
                for (int i = 0; i < this.labels.length; ++i) {
                    double y = yStart - (double)i * length / (double)n;
                    g.setColor(textColor);
                    g.drawString(this.labels[i], this.axis.onLeftSide ? x - (double)fm.stringWidth(this.labels[i]) : x, y + height);
                    g.setColor(majorTickColor);
                    g.drawLine(originX + 5.0, y, originX - 5.0, y);
                }
            }
        }
    }

    @Override
    int getMajorTickMarkLength() {
        return 5;
    }

    private int longestStringLength(FontMetrics fm, String[] labels) {
        int longestLength = 0;
        for (int i = 0; i < labels.length; ++i) {
            int length = fm.stringWidth(labels[i]);
            if (length <= longestLength) continue;
            longestLength = length;
        }
        return longestLength;
    }

    private double indexToLocation(int index) {
        double minL = this.axis.getMinLocation();
        double maxL = this.axis.getMaxLocation();
        if (this.labelPlacementStyle == 1) {
            return minL + (maxL - minL) * (double)index / (double)this.labels.length + (maxL - minL) / (double)this.labels.length / 2.0;
        }
        return minL + (maxL - minL) * (double)index / (double)this.labels.length;
    }

    @Override
    public double convert(String s) {
        try {
            return this.indexToLocation((Integer)this.hash.get(s));
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    @Override
    public double binWidth() {
        return (double)(this.axis.getMaxLocation() - this.axis.getMinLocation()) / (double)this.labels.length;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.labelPlacementStyle);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.labelPlacementStyle = in.readInt();
    }
}

