/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.PasswordManager;
import com.mchange.util.impl.SyncedProperties;
import java.io.File;
import java.io.IOException;

public class PlaintextPropertiesPasswordManager
implements PasswordManager {
    private static final String PASSWORD_PROP_PFX = "password.";
    private static final String HEADER = "com.mchange.util.impl.PlaintextPropertiesPasswordManager data";
    SyncedProperties props;

    public PlaintextPropertiesPasswordManager(File propsFile) throws IOException {
        this.props = new SyncedProperties(propsFile, HEADER);
    }

    public boolean validate(String username, String password) throws IOException {
        return password.equals(this.props.getProperty(PASSWORD_PROP_PFX + username));
    }

    public boolean updatePassword(String username, String oldPassword, String newPassword) throws IOException {
        if (!this.validate(username, oldPassword)) {
            return false;
        }
        this.props.put(PASSWORD_PROP_PFX + username, newPassword);
        return true;
    }
}

