/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IFunction;
import hep.aida.IManagedObject;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.FunctionChangedEvent;
import hep.aida.ref.function.FunctionCoreListener;
import hep.aida.ref.function.FunctionDispatcher;
import hep.aida.ref.function.FunctionListener;
import jas.hist.DataSource;
import jas.hist.ExtendedStatistics;
import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.FunctionValueUndefined;
import jas.hist.Handle;
import jas.hist.HasHandles;
import jas.hist.InvalidFunctionParameter;

public class AIDAFunctionAdapter
extends Fittable1DFunction
implements ExtendedStatistics,
HasHandles,
FunctionListener,
FunctionCoreListener {
    private IFunction function;
    private double[] d = new double[1];
    private boolean notify = true;
    private String title = "function";

    static DataSource create(IFunction function) {
        if (function.dimension() == 1) {
            return new AIDAFunctionAdapter(function);
        }
        throw new IllegalArgumentException("Only 1-D functions supported");
    }

    public AIDAFunctionAdapter(IFunction function) {
        this.function = function;
        if (function instanceof FunctionDispatcher) {
            ((FunctionDispatcher)function).addFunctionListener(this);
            this.notify = false;
        }
        if (function instanceof BaseModelFunction) {
            ((BaseModelFunction)function).core().addCoreListener(this);
        }
        if (function instanceof IManagedObject) {
            this.title = ((IManagedObject)function).name();
        }
    }

    public void setParameter(int index, double value) throws InvalidFunctionParameter {
        this.function.setParameter(this.function.parameterNames()[index], value);
        if (this.notify) {
            this.functionChanged(new FunctionChangedEvent(FunctionChangedEvent.PARAMETER_VALUE_CHANGED));
        }
    }

    public String[] getParameterNames() {
        return this.function.parameterNames();
    }

    public double[] getParameterValues() {
        return this.function.parameters();
    }

    public double valueAt(double x) throws FunctionValueUndefined {
        this.d[0] = x;
        double result = this.function.value(this.d);
        if (Double.isNaN(result)) {
            throw new FunctionValueUndefined();
        }
        return result;
    }

    public double valueAt(double x, double[] values) throws FunctionValueUndefined {
        for (int i = 0; i < values.length; ++i) {
            try {
                this.setParameter(i, values[i]);
                continue;
            }
            catch (InvalidFunctionParameter ifp) {
                throw new FunctionValueUndefined();
            }
        }
        return this.valueAt(x);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (this.function instanceof ManagedObject) {
            ((ManagedObject)this.function).setName(title);
        }
        this.title = title;
    }

    public void setFit(Fitter fitter, double[] values) throws InvalidFunctionParameter {
        for (int i = 0; i < values.length; ++i) {
            try {
                this.setParameter(i, values[i]);
                continue;
            }
            catch (InvalidFunctionParameter ifp) {
                throw new InvalidFunctionParameter(this.getParameterNames()[i]);
            }
        }
        this.setFit(fitter);
        this.setChanged();
    }

    public IFunction function() {
        return this.function;
    }

    public Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        Handle[] handles;
        if (!(this.function instanceof BaseModelFunction)) {
            handles = new Handle[]{};
        } else {
            BaseModelFunction modelFunction = (BaseModelFunction)this.function;
            handles = modelFunction.core().getHandles(xLow, xHigh, yLow, yHigh);
        }
        if (handles == null) {
            handles = new Handle[]{};
        }
        return handles;
    }

    @Override
    public void functionChanged(FunctionChangedEvent event) {
        int eventId = event.eventId();
        if (eventId == FunctionChangedEvent.PARAMETER_VALUE_CHANGED || eventId == FunctionChangedEvent.RANGE_CHANGED) {
            this.clearFit();
        }
        this.setChanged();
    }

    @Override
    public void coreChanged() {
        this.clearFit();
        this.setChanged();
    }
}

