/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationView
implements Serializable {
    private static final long serialVersionUID = -1596767856817881046L;
    private ConfigurationDescription configDesc;
    private final Map<String, Map<String, String>> componentsMap = new ConcurrentSkipListMap<String, Map<String, String>>();
    private static final Logger LOG = Logger.getLogger(ConfigurationView.class.getName());

    public ConfigurationView() {
    }

    public ConfigurationView(ConfigurationView view) {
        this(view.getConfigurationDescription());
        this.putAll(view);
    }

    public ConfigurationView(ConfigurationDescription configDesc) {
        this.configDesc = configDesc;
    }

    public ConfigurationView(SingleCategoryTagData tagData) {
        SingleCategoryTag singleCatTag = tagData.getSingleCategoryTag();
        this.configDesc = new ConfigurationDescription(Collections.singleton(singleCatTag.getCategory()));
        this.configDesc.putSourcedTagForCategory(singleCatTag.getCategory(), singleCatTag.getTag(), singleCatTag.getSource(), singleCatTag.getVersion());
        Map<String, String> data = tagData.getConfigurationData();
        for (String path : data.keySet()) {
            this.putParameterValue(path, data.get(path));
        }
    }

    public final void putParameterValue(String parameterFullName, String value) {
        try {
            ParameterPath pp = ParameterPath.valueOf((String)parameterFullName);
            this.putParameterValue(pp.getComponentName(), pp.getParameterName(), value);
        }
        catch (Exception e) {
            LOG.log(Level.FINER, "Skipping property " + parameterFullName + " " + value);
        }
    }

    public void putParameterValue(String componentName, String parmName, String value) {
        Map<String, String> subMap = this.componentsMap.get(componentName);
        if (subMap == null) {
            subMap = new ConcurrentSkipListMap<String, String>();
            this.componentsMap.put(componentName, subMap);
        }
        subMap.put(parmName, value);
    }

    public void putAll(ConfigurationView cv) {
        this.configDesc = cv.configDesc;
        for (Map.Entry<String, Map<String, String>> entry : cv.componentsMap.entrySet()) {
            Map<String, String> subMap = this.componentsMap.get(entry.getKey());
            if (subMap == null) {
                subMap = new HashMap<String, String>();
                this.componentsMap.put(entry.getKey(), subMap);
            }
            subMap.putAll(entry.getValue());
        }
    }

    public Map<ParameterPath, String> getAsParameterPathMap() {
        TreeMap<ParameterPath, String> res = new TreeMap<ParameterPath, String>();
        for (Map.Entry<String, Map<String, String>> e1 : this.componentsMap.entrySet()) {
            for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                res.put(new ParameterPath(e1.getKey(), e2.getKey()), e2.getValue());
            }
        }
        return res;
    }

    public Properties getAsProperties() {
        TreeMap<String, String> res = new TreeMap<String, String>();
        for (Map.Entry<String, Map<String, String>> e1 : this.componentsMap.entrySet()) {
            for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                res.put(new ParameterPath(e1.getKey(), e2.getKey()).toString(), e2.getValue());
            }
        }
        Properties p = new Properties();
        p.putAll((Map<?, ?>)res);
        return p;
    }

    public ConfigurationView diff(ConfigurationView other) {
        ConfigurationView diff = new ConfigurationView();
        for (Map.Entry<String, Map<String, String>> e1 : this.componentsMap.entrySet()) {
            String comp = e1.getKey();
            for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                Map<String, String> subMap;
                String otherVal;
                String parm = e2.getKey();
                String val = e2.getValue();
                if (val.equals(otherVal = (subMap = other.getValuesForComponent(comp)) == null ? null : subMap.get(parm))) continue;
                diff.putParameterValue(comp, parm, otherVal);
            }
        }
        return diff;
    }

    public boolean containsPath(ParameterPath path) {
        return this.componentsMap.containsKey(path.getComponentName()) && this.componentsMap.get(path.getComponentName()).containsKey(path.getParameterName());
    }

    public String getPathValue(ParameterPath path) {
        if (!this.componentsMap.containsKey(path.getComponentName())) {
            throw new RuntimeException("Parameter " + path.getParameterName() + " does not exist for component " + path.getComponentName() + " in this view.");
        }
        return this.componentsMap.get(path.getComponentName()).get(path.getParameterName());
    }

    public ConfigurationDescription getConfigurationDescription() {
        return this.configDesc;
    }

    public void setConfigurationDescription(ConfigurationDescription configDesc) {
        this.configDesc = configDesc;
    }

    public boolean isEmpty() {
        return this.getAsParameterPathMap().isEmpty();
    }

    public Map<String, String> getValuesForComponent(String componentName) {
        return this.componentsMap.get(componentName);
    }

    public void putValuesForComponent(String componentName, Map<String, String> values) {
        for (Map.Entry<String, String> e : values.entrySet()) {
            this.putParameterValue(componentName, e.getKey(), e.getValue());
        }
    }

    public void removeValueForPath(ParameterPath pp) {
        Map<String, String> map = this.componentsMap.get(pp.getComponentName());
        if (map != null) {
            map.remove(pp.getParameterName());
        }
    }
}

