/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer.filters;

import java.util.HashSet;
import java.util.logging.Level;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusAgentInfo;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusStateBundle;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.plugins.tracer.filters.StandardFormatter;

public class StandardConfigurableFilter
implements MessageFilter {
    private final HashSet<String> agents;
    private final int logLevel;
    private final StandardFormatter formatter;

    public StandardConfigurableFilter(String agent, Level level, boolean brief) {
        if (agent == null || agent.trim().isEmpty()) {
            this.agents = null;
        } else {
            String[] ss = agent.split(",");
            HashSet<String> aa = new HashSet<String>(ss.length * 2);
            for (String s : ss) {
                if ((s = s.trim()).isEmpty()) continue;
                aa.add(s);
            }
            HashSet<String> hashSet = this.agents = aa.isEmpty() ? null : aa;
        }
        if (level == null) {
            level = Level.INFO;
        }
        this.logLevel = level.intValue();
        this.formatter = new StandardFormatter(brief, this.agents == null);
    }

    @Override
    public FilteredMessage apply(FilteredMessage filteredMessage) {
        BusMessage bm = filteredMessage.getMessage();
        if (this.agents != null && !this.agents.contains(bm.getOriginAgentInfo().getName())) {
            return null;
        }
        if (bm instanceof LogMessage) {
            String level = ((LogMessage)bm).getLevel();
            if (StandardConfigurableFilter.parseLevel(level).intValue() < this.logLevel) {
                return null;
            }
        } else {
            if (bm instanceof StatusHeartBeat || bm instanceof StatusAgentInfo || bm instanceof StatusStateBundle) {
                return null;
            }
            if (bm instanceof CommandAck) {
                return null;
            }
        }
        filteredMessage = this.formatter.apply(filteredMessage);
        return filteredMessage;
    }

    public static Level parseLevel(String level) {
        if (level == null) {
            return Level.ALL;
        }
        switch (level.toUpperCase()) {
            case "OFF": 
            case "O": {
                return Level.OFF;
            }
            case "SEVERE": 
            case "FATAL": 
            case "ERROR": 
            case "S": 
            case "E": {
                return Level.SEVERE;
            }
            case "WARNING": 
            case "WARN": 
            case "W": {
                return Level.WARNING;
            }
            case "INFO": 
            case "I": {
                return Level.INFO;
            }
            case "CONFIG": 
            case "C": {
                return Level.CONFIG;
            }
            case "FINE": 
            case "DEBUG": 
            case "F": 
            case "D": {
                return Level.FINE;
            }
            case "FINER": {
                return Level.FINER;
            }
            case "FINEST": 
            case "TRACE": 
            case "T": {
                return Level.FINEST;
            }
            case "ALL": 
            case "A": {
                return Level.ALL;
            }
        }
        return Level.ALL;
    }

    @Create(category="Tracer", name="Default", path="Built-In/Core/Default", description="Default message viewer that displays a minimal set of messages for each subsystem, with default formatting.")
    public static Tracer defaultTracer(@Par(def="_null_", desc="Viewer name. Optional.") String name, @Par(def="_null_", desc="Subsystem name. If not given, all subsystems are included.") String subsystem) {
        Tracer tracer = new Tracer();
        tracer.getDescriptor().setName(name);
        tracer.setFilter(new StandardConfigurableFilter(subsystem, Level.INFO, true));
        return tracer;
    }

    @Create(category="Tracer", name="Messages", path="Built-In/Core/Standard", description="Standard configurable message viewer, with default formatting.")
    public static Tracer standardTracer(@Par(def="_null_", desc="Viewer name. Optional.") String name, @Par(def="_null_", desc="Comma-separated list of subsystem names. If not given, all subsystems are included.") String subsystem, @Par(def="INFO", desc="Log messages at or above this level are displayed.") String level, @Par(def="true", desc="Use brief formatting.") boolean brief) {
        Tracer tracer = new Tracer();
        tracer.getDescriptor().setName(name);
        tracer.setFilter(new StandardConfigurableFilter(subsystem, StandardConfigurableFilter.parseLevel(level), brief));
        return tracer;
    }
}

