/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida;

import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.style.editor.IStyleEditor;
import jas.hist.Basic1DFunction;
import jas.hist.JASHist;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlotAdapter;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.extension.aida.AIDARegion;
import org.freehep.jas.plugin.plotter.DefaultPlotter;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.services.PlotFactory;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.FreeHEPLookup;

class AIDAPlot
extends DefaultPlotter
implements HasPopupItems,
ActionListener {
    private static final String separator = ". ";
    private final AIDAPlotAdapter adapter;
    private final PlotFactory factory;
    private AIDARegion region;

    AIDAPlot(PlotFactory factory, AIDAPlugin thePlugin, Studio studio) {
        super(factory);
        this.adapter = new AIDAPlotAdapter(thePlugin, studio);
        this.factory = factory;
    }

    void setPlotterRegion(AIDARegion region) {
        this.region = region;
    }

    public void plot(Object data, int mode, Object style, String options) {
        JAS3DataSource jas3DataSource;
        if (this.region == null) {
            this.region = new AIDARegion(this.factory, this.factory.currentPage().currentRegion());
            this.region.setPlot((JASHist)this.getPlot());
        }
        if (mode == 0) {
            this.clear();
        }
        if ((jas3DataSource = data instanceof JAS3DataSource ? (JAS3DataSource)data : this.adapter.adapt(data)).dataSource() instanceof Basic1DFunction && this.getPlot().getNumberOfDataSources() == 0) {
            throw new IllegalArgumentException("Currently it is not possible to plot a function on an empty plot.");
        }
        this.getPlot().addJAS3Data(jas3DataSource);
        this.region.add(jas3DataSource.dataSource(), (IPlotterStyle)style, mode, data, options);
        this.getPlot().addJAS3Data(jas3DataSource);
        this.getData().add(data);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command.equals("editAllAIDAStyles")) {
            String[] names = this.region.getAllDataNames();
            String title = "AIDA Region Styles";
            if (names == null) {
                return;
            }
            IPlotterStyle[] styles = new IPlotterStyle[names.length];
            for (int i = 0; i < names.length; ++i) {
                styles[i] = this.region.getStyleForName(names[i]);
            }
            IStyleEditor styleEditor = (IStyleEditor)FreeHEPLookup.instance().lookup(IStyleEditor.class);
            styleEditor.edit(styles, title, false);
        } else if (command.equals("editAIDAStyle")) {
            int index;
            Object obj = actionEvent.getSource();
            String dataTitle = obj.toString();
            if (obj instanceof JMenuItem) {
                dataTitle = ((JMenuItem)obj).getText();
            }
            if ((index = dataTitle.indexOf(separator)) >= 0) {
                dataTitle = dataTitle.substring(index + separator.length());
            }
            IPlotterStyle sty = this.region.getStyleForName(dataTitle);
            IStyleEditor styleEditor = (IStyleEditor)FreeHEPLookup.instance().lookup(IStyleEditor.class);
            styleEditor.edit(sty, dataTitle, false);
        }
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        IStyleEditor styleEditor = (IStyleEditor)FreeHEPLookup.instance().lookup(IStyleEditor.class);
        if (styleEditor == null) {
            return menu;
        }
        JMenu styleMenu = new JMenu("Edit AIDA Style for");
        String[] names = this.region.getAllDataNames();
        if (names == null) {
            return menu;
        }
        JMenuItem item = new JMenuItem("Whole Region");
        item.setActionCommand("editAllAIDAStyles");
        item.addActionListener(this);
        styleMenu.add(item);
        for (int i = 0; i < names.length; ++i) {
            item = new JMenuItem(i + separator + names[i]);
            item.setActionCommand("editAIDAStyle");
            item.addActionListener(this);
            styleMenu.add(item);
        }
        menu.add(styleMenu);
        return menu;
    }
}

