/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAnnotation;
import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ref.Annotation;
import hep.aida.ref.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freehep.util.FreeHEPLookup;

public abstract class AidaUtils {
    private static Pattern stringPattern = Pattern.compile("\\s*((\"(.*?)\")|([^,;$]*))\\s*?(,|;|$)");
    private static Pattern pattern = Pattern.compile("([\\w|\\.]+)\\s*((=\\s*(\"(.*?)\"|([^,;$]*)))\\s*)?(,|;|$)");

    public static void fillPath(ITree tree, IManagedObject mo) {
        if (tree != null && mo != null) {
            IAnnotation an = null;
            if (mo instanceof IBaseHistogram) {
                an = ((IBaseHistogram)mo).annotation();
            } else if (mo instanceof IDataPointSet) {
                an = ((IDataPointSet)mo).annotation();
            } else if (mo instanceof IFunction) {
                an = ((IFunction)mo).annotation();
            } else if (mo instanceof ITuple) {
                an = ((ITuple)mo).annotation();
            }
            String path = tree.findPath(mo);
            if (an == null) {
                return;
            }
            try {
                if (an.hasKey(Annotation.aidaPathKey)) {
                    an.setValue(Annotation.aidaPathKey, path);
                } else {
                    an.addItem(Annotation.aidaPathKey, path, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String name = tree.name();
            if (name == null || name.trim().equals("")) {
                name = tree.storeName();
            }
            String fullPath = "/" + name + path;
            try {
                Tree aidaMasterTree = (Tree)FreeHEPLookup.instance().lookup(ITree.class);
                if (aidaMasterTree != null) {
                    fullPath = aidaMasterTree.findPath(mo);
                }
                if (an.hasKey(Annotation.fullPathKey)) {
                    an.setValue(Annotation.fullPathKey, fullPath);
                } else {
                    an.addItem(Annotation.fullPathKey, fullPath, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map parseOptions(String options) {
        if (options == null || options.trim().length() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> hashValues = new HashMap<String, String>();
        Matcher matcher = pattern.matcher(options);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(5);
            if (value == null && (value = matcher.group(6)) != null) {
                value = value.trim();
            }
            if (value == null) {
                value = "true";
            }
            hashValues.put(key, value);
            if (matcher.end() != options.length()) continue;
            return hashValues;
        }
        throw new IllegalArgumentException("Invalid options: " + options);
    }

    public static String createOptionsString(Map options) {
        String tmp = "";
        if (options == null || options.size() == 0) {
            return tmp;
        }
        for (Object key : options.keySet()) {
            Object value = options.get(key);
            tmp = tmp + ", " + key.toString() + "=\"" + value.toString() + "\"";
        }
        return tmp;
    }

    public static String[] parseString(String options) {
        if (options == null || options.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = stringPattern.matcher(options);
        while (matcher.find()) {
            int g = matcher.groupCount();
            String value = matcher.group(3);
            if (value == null) {
                value = matcher.group(1);
            }
            if (value != null) {
                list.add(value.trim());
            }
            if (matcher.end() != options.length()) continue;
            String[] array = new String[list.size()];
            if (list.size() > 0) {
                array = list.toArray(array);
            }
            return array;
        }
        throw new IllegalArgumentException("Invalid options: " + options);
    }

    public static String[] stringToArray(String path) {
        String[] result = null;
        if (path == null || path.equals("")) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            while (token.endsWith("\\")) {
                token = token.substring(0, token.length() - 1) + "/";
                if (!tokenizer.hasMoreTokens()) continue;
                token = token + tokenizer.nextToken();
            }
            list.add(token);
        }
        result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String modifyName(String name) {
        if (name.indexOf(47) < 0) {
            return name;
        }
        String newName = "";
        int index = -1;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '/' || i > 0 && name.charAt(i - 1) == '\\') continue;
            if (i > index) {
                newName = newName + name.substring(index + 1, i) + "\\/";
                index = i;
                continue;
            }
            if (i != index) continue;
            newName = newName + "\\/";
        }
        newName = newName + name.substring(index + 1);
        return newName;
    }

    public static String parseName(String pathString) {
        if (pathString == null || pathString.equals("/") || pathString.endsWith("/")) {
            return "";
        }
        if (pathString.indexOf("/") < 0) {
            return pathString;
        }
        String[] path = AidaUtils.stringToArray(pathString);
        String name = path[path.length - 1];
        return name;
    }

    public static String parseDirName(String pathString) {
        String[] path;
        if (pathString == null || pathString.equals("/") || pathString.endsWith("/")) {
            return pathString;
        }
        if (pathString.indexOf("/") < 0) {
            return "";
        }
        String dirName = "";
        if (pathString.startsWith("/")) {
            dirName = "/";
        }
        if ((path = AidaUtils.stringToArray(pathString)).length <= 1) {
            return dirName;
        }
        for (int i = 0; i < path.length - 1; ++i) {
            dirName = dirName + path[i] + "/";
        }
        return dirName;
    }

    public static int findInArray(String string, String[] array) {
        int index = -1;
        if (string == null || array == null || array.length == 0) {
            return index;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!string.equals(array[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    public static boolean isPathInDir(String dir, String path) {
        if (dir.indexOf("//") >= 0) {
            dir.replaceAll("//", "/");
        }
        if (path.indexOf("//") >= 0) {
            path.replaceAll("//", "/");
        }
        if (path.equals(dir)) {
            return false;
        }
        if (!path.startsWith(dir)) {
            return false;
        }
        String tmp = path.substring(dir.length());
        if (tmp.startsWith("/")) {
            tmp = tmp.substring(1);
        }
        if (tmp.trim().equals("")) {
            return false;
        }
        int index = tmp.indexOf("/");
        return index < 0 || index >= tmp.length() - 1;
    }

    public static double roundDown(double x, int order) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x == Double.MIN_VALUE) {
            return x;
        }
        if (x < 0.0) {
            return -1.0 * AidaUtils.roundUp(Math.abs(x), order);
        }
        if (x == 0.0) {
            return x;
        }
        double mant = Math.floor(Math.log(x) / Math.log(10.0));
        double factor = Math.pow(10.0, (double)order - mant);
        double tmp = Math.floor(x * factor) / factor;
        return tmp;
    }

    public static double roundUp(double x, int order) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x == Double.MAX_VALUE) {
            return x;
        }
        if (x < 0.0) {
            return -1.0 * AidaUtils.roundDown(Math.abs(x), order);
        }
        if (x == 0.0) {
            return x;
        }
        double mant = Math.floor(Math.log(x) / Math.log(10.0));
        double factor = Math.pow(10.0, (double)order - mant);
        double tmp = Math.ceil(x * factor) / factor;
        return tmp;
    }
}

