/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentHandle;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;

public class AgentStatusAggregator {
    private Agent localAgent;
    private ConcurrentMessagingUtils messenger;
    final ThreadPoolExecutor exec;
    final ArrayList<GlobalListenerHandle> listeners = new ArrayList(0);
    private final AgentPresenceListener agentPresenceListener;
    private final StatusMessageListener statusMessageListener;
    private final ConcurrentHashMap<String, Instant> times = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AgentHandle> agentHandles = new ConcurrentHashMap();

    public AgentStatusAggregator() {
        ThreadFactory threadFactory = run -> {
            Thread thread = new Thread(run, "AgentStatusAggregator");
            thread.setDaemon(true);
            return thread;
        };
        this.exec = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.agentPresenceListener = new AgentPresenceListener(){

            public void disconnected(AgentInfo ... agents) {
                AgentStatusAggregator.this.exec.execute(() -> {
                    for (AgentInfo agent : agents) {
                        AgentStatusAggregator.this.processDisconnect(agent.getName());
                    }
                });
            }
        };
        this.statusMessageListener = this::onStatusMessage;
    }

    public void initialize(Agent agent) {
        this.localAgent = agent;
        AgentMessagingLayer messagingAccess = agent.getMessagingAccess();
        this.messenger = new ConcurrentMessagingUtils(messagingAccess);
        messagingAccess.addStatusMessageListener(this.statusMessageListener);
        messagingAccess.getAgentPresenceManager().addAgentPresenceListener(this.agentPresenceListener);
    }

    public void shutdown() {
        AgentMessagingLayer messagingAccess = this.localAgent.getMessagingAccess();
        messagingAccess.removeStatusMessageListener(this.statusMessageListener);
        messagingAccess.getAgentPresenceManager().removeAgentPresenceListener(this.agentPresenceListener);
        this.exec.shutdownNow();
        this.messenger = null;
        this.localAgent = null;
    }

    public Agent getAgent() {
        return this.localAgent;
    }

    public ConcurrentMessagingUtils getMessenger() {
        return this.messenger;
    }

    public List<AgentInfo> getAgents() {
        return this.agentHandles.values().stream().map(a -> a.getAgent()).collect(Collectors.toList());
    }

    public AgentInfo getAgent(String agentName) {
        AgentHandle data = this.agentHandles.get(agentName);
        return data == null ? null : data.getAgent();
    }

    public boolean hasAgent(String agentName) {
        return this.agentHandles.get(agentName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AgentChannel> getChannels(String ... channels) {
        ArrayList<AgentChannel> out = new ArrayList<AgentChannel>();
        Iterator<AgentHandle> iterator = this.agentHandles.values().iterator();
        while (iterator.hasNext()) {
            AgentHandle agentHandle;
            AgentHandle agentHandle2 = agentHandle = iterator.next();
            synchronized (agentHandle2) {
                if (channels.length > 0) {
                    for (AgentChannel agentChannel : agentHandle.getChannels()) {
                        for (String s : channels) {
                            if (AgentHandle.isSelector(s)) {
                                if (!AgentHandle.acceptSelector(agentChannel, s)) continue;
                                out.add(agentChannel);
                                continue;
                            }
                            if (!AgentHandle.matchTemplate(agentChannel.getPath(), s)) continue;
                            out.add(agentChannel);
                        }
                    }
                } else {
                    out.addAll(agentHandle.getChannels());
                }
            }
        }
        out.trimToSize();
        return out;
    }

    public AgentChannel getChannel(String path) {
        int i = path.indexOf("/");
        if (i == -1) {
            return null;
        }
        String agentName = path.substring(0, i);
        AgentHandle agentHandle = this.agentHandles.get(agentName);
        return agentHandle == null ? null : agentHandle.getChannel(path.substring(i + 1));
    }

    public StateBundle getAgentState(String agentName) {
        AgentHandle agentHandle = this.agentHandles.get(agentName);
        return agentHandle == null ? null : agentHandle.getState();
    }

    public void addListener(AgentStatusListener listener, AgentChannelsFilter filter) {
        List<String> display;
        List<String> agents = filter.getAgents();
        List<String> channels = filter.getOriginChannels();
        if ((agents == null || channels == null) && (display = filter.getDisplayChannels()) != null) {
            ArrayList<String> reconChannels = new ArrayList<String>(display.size());
            for (String d : display) {
                String path = filter.getOriginPath(d);
                if (path == null) continue;
                reconChannels.add(path);
            }
            if (agents == null) {
                agents = new ArrayList<String>();
                for (String path : reconChannels) {
                    String name = path.substring(0, path.indexOf("/"));
                    if (agents.contains(name)) continue;
                    agents.add(name);
                }
            }
            if (channels == null) {
                channels = reconChannels;
            }
        }
        ArrayList<String> finalAgents = agents == null ? null : new ArrayList<String>(agents);
        ArrayList<String> finalChannels = channels == null ? Collections.singletonList("/") : new ArrayList<String>(channels);
        this.exec.submit(() -> this.executeAddListener(listener, finalAgents, finalChannels));
    }

    public void addListener(AgentStatusListener listener, Collection<String> agents, Collection<String> channels) {
        ArrayList<String> finalAgents = agents == null ? null : new ArrayList<String>(agents);
        ArrayList<String> finalChannels = channels == null ? Collections.singletonList("/") : new ArrayList<String>(channels);
        this.exec.submit(() -> this.executeAddListener(listener, finalAgents, finalChannels));
    }

    public void removeListener(AgentStatusListener listener) {
        this.exec.submit(() -> this.executeRemoveListener(listener));
    }

    private void executeAddListener(AgentStatusListener listener, List<String> agents, List<String> channels) {
        GlobalListenerHandle handle = new GlobalListenerHandle(listener, agents, channels);
        this.listeners.add(handle);
        for (AgentHandle agentHandle : this.agentHandles.values()) {
            agentHandle.addListener(handle);
        }
    }

    private void executeRemoveListener(AgentStatusListener listener) {
        Set removed = Collections.newSetFromMap(new IdentityHashMap());
        Iterator<GlobalListenerHandle> it = this.listeners.iterator();
        while (it.hasNext()) {
            GlobalListenerHandle global = it.next();
            if (global.listener != listener) continue;
            it.remove();
            if (removed.contains(global)) continue;
            removed.add(global);
            for (AgentHandle agentHandle : this.agentHandles.values()) {
                agentHandle.removeListener(global);
            }
        }
    }

    private void onStatusMessage(StatusMessage message) {
        AgentInfo info = message.getOriginAgentInfo();
        if (info == null || info.getType() == AgentInfo.AgentType.CONSOLE) {
            return;
        }
        String agentName = message.getOriginAgentInfo().getName();
        if (agentName == null) {
            return;
        }
        this.times.put(agentName, Instant.now());
        this.exec.execute(() -> this.processStatusMessage(message));
    }

    private void processStatusMessage(StatusMessage message) {
        AgentInfo agentInfo = message.getOriginAgentInfo();
        String agentName = agentInfo.getName();
        if (message.getState().isInState((Enum)PhaseState.OFF_LINE)) {
            this.processDisconnect(agentName);
            return;
        }
        if (!message.getState().isInState((Enum)PhaseState.OPERATIONAL) && !message.getState().isInState((Enum)PhaseState.CLOSING)) {
            return;
        }
        AgentHandle agentHandle = this.agentHandles.get(agentName);
        if (agentHandle == null) {
            agentHandle = new AgentHandle(agentInfo, this);
            agentHandle.onConnect(message);
            this.agentHandles.put(agentName, agentHandle);
        }
        agentHandle.onMessage(message);
    }

    private void processDisconnect(String agentName) {
        AgentHandle agentHandle = this.agentHandles.remove(agentName);
        if (agentHandle != null) {
            agentHandle.onDisconnect();
        }
    }

    class GlobalListenerHandle {
        AgentStatusListener listener;
        List<String> agents;
        List<String> channels;

        GlobalListenerHandle(AgentStatusListener listener, List<String> agents, List<String> channels) {
            this.listener = listener;
            this.agents = agents;
            this.channels = channels;
        }
    }
}

