package org.lsst.ccs.subsystem.daq.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 *  Enumerated Alerts for Daq subsystem
 *
 *  @author Al Eisner
 */
public enum DaqSubsystemAlerts {

    STATS_DIFF       ("StatsDiff", "Incremental count summed over REBs too high");
    private final String id, description;
    
    DaqSubsystemAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert newAlert() {
        return new Alert(getId(), getDescription());
    }

}
