package org.lsst.ccs.subsystem.daq.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 *  Enumerated Alerts for Daq subsystem
 *
 *  @author Al Eisner
 */
public enum DaqSubsystemAlerts {

    STATS_DIFF   ("StatsDiff", "Incremental count summed over REBs too high"),
    PURGE_FAIL   ("PurgeFail", "Auto-purge failed too many times in a row"),
    SPACE_LOW    ("SpaceLow", "Free space in Store too low");

    private final String id, description;
    
    DaqSubsystemAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }

    public String getId(String key) {
	String subId = key.substring(key.lastIndexOf("/") + 1);
	return (id + "_" + subId);
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert newAlert() {
        return new Alert(getId(), getDescription());
    }

    public Alert newAlert(String key) {
        return new Alert(getId(key), getDescription());
    }

}
