package org.lsst.ccs.subsystems.console.jython;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;

import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/**
 * Supports running scripts in 3 modes:
 * <ul>
 * <li>By interactively reading scripts from stdin</li>
 * <li>By executing a script provided as a command line argument</li>
 * <li>By sending a script to a remote JythonInterpreterConsole</li>
 * </ul>
 *
 * @author The LSST CCS Team
 *
 */
public class JythonScriptExecutor {

    private static CommandLine line;
    static Options shellOptions;

    /**
     * @param args the command line arguments
     * @throws org.apache.commons.cli.ParseException
     * @throws java.io.FileNotFoundException
     */
    public static void main(String[] args) throws ParseException, FileNotFoundException, IOException {

        parseCommandLineArguments(args);

        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(80, "ccs-script", "", shellOptions, "", true);
        } else {

            List<String> argList = line.getArgList();
            String scriptPath = argList.isEmpty() ? null : argList.remove(0);

            boolean submit = line.hasOption("submit");
            if (submit) {
                int port = 4444;
                if (line.hasOption("jythonPort")) {
                    port = Integer.parseInt(line.getOptionValue("jythonPort"));
                }
                String host = "localhost";
                if (line.hasOption("jythonHost")) {
                    host = line.getOptionValue("jythonHost");
                }
                InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);

                JythonConsoleSocketConnection jythonConsoleSocketConnection = new JythonConsoleSocketConnection("ScriptSubmission_" + System.currentTimeMillis(), port, host);
                jythonConsoleSocketConnection.setPrintStream(System.out);
                jythonConsoleSocketConnection.synchFileExecution(is, argList.toArray(new String[0]));
                jythonConsoleSocketConnection.close();
            } else if (scriptPath == null) {
                JythonScriptExecutorUtils.executeInteractive();
            } else {
                InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);
                try {
                    JythonScriptExecutorUtils.executeScript(is, scriptPath, System.out, argList.toArray(new String[0]));
                } catch (Throwable t) {
                    JythonScriptExecutorUtils.handleExecutionException(t);
                }
            }
        }
        System.exit(0);

    }

    static void parseCommandLineArguments(String[] args) throws ParseException {
        shellOptions = new Options();
        shellOptions.addOption("h", "help", false, "Print the help message");

        shellOptions.addOption("jhost", "jythonHost", true, "The host of the JythonInterpreterConsole");
        shellOptions.addOption("jport", "jythonPort", true, "The port of the JythonInterpreterConsole");
        shellOptions.addOption("submit", false, "Submit the script to a JythonInterpreterConsole");

        CommandLineParser parser = new BasicParser();
        line = parser.parse(shellOptions, args, true);
    }

    static List<String> getLeftoverArguments() {
        return line.getArgList();
    }

}
