/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.services.PeriodicTaskComponent;

public class AgentPeriodicTask {
    private final Runnable runnable;
    private final String taskName;
    private boolean isFixedRate = true;
    private Level logLevel = Level.SEVERE;
    private Duration period = Duration.ofSeconds(1L);
    private ConfigurationParameterDescription parameterDescription;
    private boolean autoStart = true;
    private PeriodicTaskComponent taskComponent;

    public AgentPeriodicTask(String taskName, Runnable runnable) {
        this.runnable = runnable;
        this.taskName = taskName;
    }

    public AgentPeriodicTask withIsFixedRate(boolean isFixedRate) {
        this.isFixedRate = isFixedRate;
        return this;
    }

    public AgentPeriodicTask withLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public AgentPeriodicTask withPeriod(Duration period) {
        this.period = period;
        return this;
    }

    public AgentPeriodicTask withPeriodParameterDescription(ConfigurationParameterDescription parameterDescription) {
        this.parameterDescription = parameterDescription;
        return this;
    }

    public AgentPeriodicTask withAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public boolean isIsFixedRate() {
        return this.isFixedRate;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public Duration getPeriod() {
        return this.period;
    }

    public ConfigurationParameterDescription getPeriodParameterDescription() {
        return this.parameterDescription;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public boolean startPeriodicTask(long delay, TimeUnit timeUnit) {
        if (this.getAutoStart()) {
            throw new RuntimeException("Cannot invoke this method on tasks that are configured to autoStart");
        }
        return this.taskComponent.startPeriodicTask(delay, timeUnit);
    }

    public void stopPeriodicTask(long timeout, TimeUnit timeUnits) throws InterruptedException, TimeoutException {
        if (this.getAutoStart()) {
            throw new RuntimeException("Cannot invoke this method on tasks that are configured to autoStart");
        }
        this.taskComponent.stopPeriodicTask(timeout, timeUnits);
    }

    public void setPeriodicTaskComponent(PeriodicTaskComponent periodicTaskComponent) {
        this.taskComponent = periodicTaskComponent;
    }
}

