/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public class PeriodicTaskExceptionHandler {
    public static final Logger LOG = Logger.getLogger(PeriodicTaskExceptionHandler.class.getCanonicalName());
    private boolean skipOverdueExecutions = false;
    private int longExecutionThreshold = 0;
    private volatile int maxFailures = -1;
    private boolean resetFailureCountOnSuccess = true;
    private Level level;
    private final DateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");

    public void setSkipOverdueExecutions(boolean skipOverdueExecutions) {
        this.skipOverdueExecutions = skipOverdueExecutions;
    }

    public void setDetectLongExecutions(boolean detectLongExecutions) {
        this.longExecutionThreshold = detectLongExecutions ? -1 : 0;
    }

    public void setLongExecutionThreshold(int longExecutionThreshold, TimeUnit unit) {
        this.longExecutionThreshold = longExecutionThreshold == 0 ? 0 : (unit == null ? -longExecutionThreshold : (int)unit.toMillis(longExecutionThreshold));
    }

    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public void setResetFailureCountOnSuccess(boolean resetFailureCountOnSuccess) {
        this.resetFailureCountOnSuccess = resetFailureCountOnSuccess;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean isSkipOverdueExecutions() {
        return this.skipOverdueExecutions;
    }

    public boolean isDetectLongExecutions() {
        return this.longExecutionThreshold != 0;
    }

    public int getLongExecutionThreshold() {
        return this.longExecutionThreshold;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    public boolean isResetFailureCountOnSuccess() {
        return this.resetFailureCountOnSuccess;
    }

    public Level getLevel() {
        return this.level;
    }

    public void onSkippedExecutions(PeriodicTask task, int nSkipped) {
        Logger logger = this.getLogger(task);
        if (logger.isLoggable(this.level)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Periodic task ").append(task.getTaskName()).append(" skipped ").append(nSkipped).append(" executions.");
            sb.append(" Timing relative to ");
            long t = task.timeBegin;
            sb.append(this.millisToTime(t)).append(", ms: PREVIOUS: from 0 to ");
            long delta = task.timeEnd - t;
            sb.append(delta);
            if (delta > 1L) {
                sb.append(" (");
                if (task.timeAfterOnSkippedExecutions > 0L) {
                    delta = task.timeBeforeOnSkippedExecutions - t;
                    if (delta > 0L) {
                        sb.append(" before onSkipped : ").append(delta);
                    }
                    if ((delta = task.timeAfterOnSkippedExecutions - task.timeBeforeOnSkippedExecutions) > 0L) {
                        sb.append(" onSkipped : ").append(delta);
                    }
                    t = task.timeAfterOnSkippedExecutions;
                }
                if (task.timeAfterTimer > 0L) {
                    delta = task.timeBeforeTimer - t;
                    if (delta > 0L) {
                        sb.append(" before timer : ").append(delta);
                    }
                    if ((delta = task.timeAfterTimer - task.timeBeforeTimer) > 0L) {
                        sb.append(" timer : ").append(delta);
                    }
                    t = task.timeAfterTimer;
                }
                if ((delta = task.timeBeforeRun - t) > 0L) {
                    sb.append(" before run : ").append(delta);
                }
                if ((delta = task.timeAfterRun - task.timeBeforeRun) > 0L) {
                    sb.append(" run : ").append(delta);
                }
                t = task.timeAfterRun;
                if (task.timeBeforeCancel > 0L) {
                    delta = task.timeBeforeCancel - t;
                    if (delta > 0L) {
                        sb.append(" before cancel : ").append(delta);
                    }
                    if ((delta = task.timeEnd - task.timeBeforeCancel) > 0L) {
                        sb.append(" cancel : ").append(delta);
                    }
                } else {
                    delta = task.timeEnd - t;
                    if (delta > 0L) {
                        sb.append(" after run : ").append(delta);
                    }
                }
                sb.append(")");
            }
            t = task.timeFirstSkipped - task.timeBegin;
            sb.append("; FIRST SKIPPED: expected ").append(t + task.delayFirstSkipped).append(", started ").append(t);
            long currentTime = System.currentTimeMillis();
            sb.append("; NOW: ").append(currentTime - task.timeBegin);
            try {
                RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
                long base = task.timeBegin - rt.getStartTime();
                sb.append("; GC: ");
                boolean hasGC = false;
                for (java.lang.management.GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                    GcInfo info;
                    if (!(gc instanceof GarbageCollectorMXBean) || (info = ((GarbageCollectorMXBean)gc).getLastGcInfo()) == null) continue;
                    sb.append(gc.getName()).append(" from ").append(info.getStartTime() - base).append(" to ").append(info.getEndTime() - base).append(" for ").append(info.getDuration()).append(", ");
                    hasGC = true;
                }
                if (hasGC) {
                    sb.delete(sb.length() - 2, sb.length());
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            sb.append(".");
            logger.log(this.level, sb.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onLongExecution(PeriodicTask task) {
        block10: {
            StringBuilder sb;
            Logger logger;
            block14: {
                long delta;
                long t;
                block26: {
                    block28: {
                        block27: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block17: {
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                block11: {
                                                                    block16: {
                                                                        block15: {
                                                                            block13: {
                                                                                block12: {
                                                                                    logger = this.getLogger(task);
                                                                                    if (!logger.isLoggable(this.level)) break block10;
                                                                                    sb = new StringBuilder();
                                                                                    sb.append("Periodic task ").append(task.getTaskName()).append(" did not finish execution by the end of its period of ");
                                                                                    sb.append(task.getPeriod(TimeUnit.MILLISECONDS)).append(" ms. ");
                                                                                    sb.append(task.getThread() != null ? "Still runnung" : "Finished by now");
                                                                                    sb.append(". Timing (unreliable!) relative to ");
                                                                                    t = task.timeBegin;
                                                                                    sb.append(this.millisToTime(t)).append(", ms: started 0, ");
                                                                                    delta = 0L;
                                                                                    if (task.timeBeforeOnSkippedExecutions <= 0L) break block11;
                                                                                    delta = task.timeBeforeOnSkippedExecutions - t;
                                                                                    if (delta <= 0L) break block12;
                                                                                    sb.append(" before onSkipped : ").append(delta);
                                                                                    break block13;
                                                                                }
                                                                                if (delta >= 0L) break block13;
                                                                                sb.append(" before onSkipped : ").append("unfinished");
                                                                                break block14;
                                                                            }
                                                                            delta = task.timeAfterOnSkippedExecutions - task.timeBeforeOnSkippedExecutions;
                                                                            if (delta <= 0L) break block15;
                                                                            sb.append(" onSkipped : ").append(delta);
                                                                            break block16;
                                                                        }
                                                                        if (delta >= 0L) break block16;
                                                                        sb.append(" onSkipped : ").append("unfinished");
                                                                        break block14;
                                                                    }
                                                                    t = task.timeAfterOnSkippedExecutions;
                                                                }
                                                                if (task.timeBeforeTimer <= 0L) break block17;
                                                                delta = task.timeBeforeTimer - t;
                                                                if (delta <= 0L) break block18;
                                                                sb.append(" before timer : ").append(delta);
                                                                break block19;
                                                            }
                                                            if (delta >= 0L) break block19;
                                                            sb.append(" before timer : ").append("unfinished");
                                                            break block14;
                                                        }
                                                        delta = task.timeAfterTimer - task.timeBeforeTimer;
                                                        if (delta <= 0L) break block20;
                                                        sb.append(" timer : ").append(delta);
                                                        break block21;
                                                    }
                                                    if (delta >= 0L) break block21;
                                                    sb.append(" timer : ").append("unfinished");
                                                    break block14;
                                                }
                                                t = task.timeAfterTimer;
                                            }
                                            if ((delta = task.timeBeforeRun - t) <= 0L) break block22;
                                            sb.append(" before run : ").append(delta);
                                            break block23;
                                        }
                                        if (delta >= 0L) break block23;
                                        sb.append(" before run : ").append("unfinished");
                                        break block14;
                                    }
                                    delta = task.timeAfterRun - task.timeBeforeRun;
                                    if (delta <= 0L) break block24;
                                    sb.append(" run : ").append(delta);
                                    break block25;
                                }
                                if (delta >= 0L) break block25;
                                sb.append(" run : ").append("unfinished");
                                break block14;
                            }
                            t = task.timeAfterRun;
                            if (task.timeBeforeCancel <= 0L) break block26;
                            delta = task.timeBeforeCancel - t;
                            if (delta <= 0L) break block27;
                            sb.append(" before cancel : ").append(delta);
                            break block28;
                        }
                        if (delta >= 0L) break block28;
                        sb.append(" before cancel : ").append("unfinished");
                        break block14;
                    }
                    delta = task.timeEnd - task.timeBeforeCancel;
                    if (delta > 0L) {
                        sb.append(" cancel : ").append(delta);
                        break block14;
                    } else if (delta < 0L) {
                        sb.append(" cancel : ").append("unfinished");
                    }
                    break block14;
                }
                delta = task.timeEnd - t;
                if (delta > 0L) {
                    sb.append(" after run : ").append(delta);
                } else if (delta < 0L) {
                    sb.append(" after run : ").append("unfinished");
                }
            }
            long currentTime = System.currentTimeMillis();
            sb.append("; NOW: ").append(currentTime - task.timeBegin);
            try {
                RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
                long base = task.timeBegin - rt.getStartTime();
                sb.append("; GC: ");
                boolean hasGC = false;
                for (java.lang.management.GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                    GcInfo info;
                    if (!(gc instanceof GarbageCollectorMXBean) || (info = ((GarbageCollectorMXBean)gc).getLastGcInfo()) == null) continue;
                    sb.append(gc.getName()).append(" from ").append(info.getStartTime() - base).append(" to ").append(info.getEndTime() - base).append(" for ").append(info.getDuration()).append(", ");
                    hasGC = true;
                }
                if (hasGC) {
                    sb.delete(sb.length() - 2, sb.length());
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            sb.append(".");
            logger.log(this.level, sb.toString());
        }
    }

    public void onException(PeriodicTask task, Throwable exception) {
        Logger logger = this.getLogger(task);
        if (logger.isLoggable(this.level)) {
            logger.log(this.level, "Exception thrown by periodic task " + task.getTaskName(), exception);
        }
    }

    public void onFinalException(PeriodicTask task, Throwable exception) {
        Logger logger = this.getLogger(task);
        if (logger.isLoggable(this.level)) {
            logger.log(this.level, "Exception thrown by periodic task " + task.getTaskName() + ", task terminated.", exception);
        }
    }

    private String millisToTime(long time) {
        return this.formatter.format(new Date(time));
    }

    private Logger getLogger(PeriodicTask task) {
        Logger logger = task.getLog();
        return logger == null ? LOG : logger;
    }
}

