/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.config.RemoteFileServer;

public class RemoteDictionaryDAO {
    private static final Logger LOG = Logger.getLogger(RemoteDictionaryDAO.class.getName());
    private final RemoteFileServer remoteFileServer;

    public RemoteDictionaryDAO(String descName, String mountPoint) {
        LOG.log(Level.INFO, "Created Remote Dictionary DAO for description {0}", descName);
        this.remoteFileServer = new RemoteFileServer(descName, mountPoint);
    }

    /*
     * Exception decompiling
     */
    public byte[] getDictionary(String dictionaryName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isDictionaryAvailable(String dictionaryName) {
        Path dictionaryPath = this.pathFromFileName(dictionaryName);
        return this.remoteFileServer.exists(dictionaryPath);
    }

    public void writeDictionaryIfNeeded(String dictionaryName, byte[] dict) throws Exception {
        Path dictionaryPath = this.pathFromFileName(dictionaryName);
        try (OutputStream os = this.remoteFileServer.getOutputStream(dictionaryPath, new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW});){
            LOG.log(Level.INFO, "Writing dictionary {0} to remote server.", dictionaryPath);
            os.write(dict);
        }
        catch (FileAlreadyExistsException ioe) {
            LOG.log(Level.INFO, "Dictionary {0} already exists in remote server.", dictionaryPath);
        }
    }

    private Path pathFromFileName(String fileName) {
        String[] split = fileName.split("/");
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 1; i < split.length; ++i) {
            args.add(split[i]);
        }
        return this.remoteFileServer.getFileSystem().getPath(split[0], args.toArray(new String[0]));
    }
}

