package org.lsst.ccs.subsystems.console;

import org.lsst.ccs.Subsystem;

import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.StatusMessageListener;

public class Tracer extends Subsystem implements StatusMessageListener , HasLifecycle {
    public static void main(String[] args) {
        Tracer t = new Tracer();
        t.startAgent();
    }

    public Tracer() {
        super("tracer", AgentInfo.AgentType.LISTENER);
    }

    @Override
    public void start() {
        getMessagingAccess().addStatusMessageListener(this);
    }


    
    @Override
    public void onStatusMessage(org.lsst.ccs.bus.messages.StatusMessage s) {
        System.out.println(s);
    }

}
