/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jline.console.ConsoleReader;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.AgentLockServiceCommands;
import org.lsst.ccs.subsystem.shell.BusCommandSet;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleSocketConnection;

public class ConsoleCommandShell
implements AgentCommandDictionaryService.AgentCommandDictionaryListener {
    private final AgentMessagingLayer messagingAccess;
    private final RouteSelectionCommandSet rsc;
    private final ConcurrentMessagingUtils sci;
    private final BusMasterCommands busMasterCommands = new BusMasterCommands();
    private final CompositeCommandSet builtInsCommandSet;
    private static final int timeoutMillis = 10000;
    private JythonConsoleSocketConnection jythonConsoleSocketConnection = null;
    private String showJythonOutput = "false";
    private final Agent agent;

    ConsoleCommandShell(Agent agent) {
        this.messagingAccess = agent.getMessagingAccess();
        this.sci = new ConcurrentMessagingUtils(this.messagingAccess, Duration.ofMillis(10000L));
        this.rsc = new RouteSelectionCommandSet();
        CommandSetBuilder builder = new CommandSetBuilder();
        this.builtInsCommandSet = new CompositeCommandSet();
        this.builtInsCommandSet.add(builder.buildCommandSet((Object)this.busMasterCommands));
        this.builtInsCommandSet.add(builder.buildCommandSet((Object)new AgentLockServiceCommands((AgentLockService)agent.getAgentService(AgentLockService.class), (AgentLoginService)agent.getAgentService(AgentLoginService.class), this.rsc)));
        this.rsc.add((CommandSet)this.builtInsCommandSet);
        this.rsc.getCommandDictionary().setLevelForTypes(-1, new Command.CommandType[0]);
        this.rsc.getCommandDictionary().setLevelForTypes(0, new Command.CommandType[]{Command.CommandType.QUERY});
        this.builtInsCommandSet.getCommandDictionary().setLevelForTypes(99999, new Command.CommandType[0]);
        this.agent = agent;
        ((AgentCommandDictionaryService)agent.getAgentService(AgentCommandDictionaryService.class)).addAgentCommandDictionaryListener((AgentCommandDictionaryService.AgentCommandDictionaryListener)this);
    }

    public RouteSelectionCommandSet getConsoleCommandSet() {
        return this.rsc;
    }

    public void commandDictionaryUpdate(AgentCommandDictionaryService.AgentCommandDictionaryEvent evt) {
        if (!evt.getAgentInfo().getType().equals((Object)AgentInfo.AgentType.LISTENER)) {
            String agentName = evt.getAgentInfo().getName();
            if (evt.getEventType().equals((Object)AgentCommandDictionaryService.AgentCommandDictionaryEvent.EventType.ADDED)) {
                if (!this.rsc.containsPath(agentName)) {
                    this.agent.getScheduler().execute(() -> {
                        for (String path : evt.getDictionary().keySet()) {
                            String route = path;
                            if (!route.startsWith(agentName)) {
                                route = agentName + (route.isEmpty() ? "" : "/") + route;
                            }
                            if (!path.startsWith(agentName)) {
                                path = agentName + (path.isEmpty() ? "" : "/") + path;
                            }
                            this.rsc.addRoutingCommandSet(route, path, (CommandSet)new BusCommandSet(this.sci, path, (Dictionary)evt.getDictionary().get(path)));
                        }
                    });
                }
            } else if (evt.getEventType().equals((Object)AgentCommandDictionaryService.AgentCommandDictionaryEvent.EventType.REMOVED)) {
                this.rsc.removeRoute(agentName);
            }
        }
    }

    BusMasterCommands getBusMasterCommands() {
        return this.busMasterCommands;
    }

    public static JLineShell createJLineShell(Agent agent, ConsoleReader reader) throws IOException {
        ConsoleCommandShell comShell = new ConsoleCommandShell(agent);
        return new JLineShell((CommandSet)comShell.getConsoleCommandSet(), reader, "${target} ccs>");
    }

    public static ConsoleCommandShell createConsoleCommandShell(Agent agent) {
        ConsoleCommandShell comShell = new ConsoleCommandShell(agent);
        return comShell;
    }

    public static void main(String[] argv) throws Exception {
        Subsystem busMaster = new Subsystem("ccs-shell", AgentInfo.AgentType.CONSOLE);
        busMaster.startAgent();
        ConsoleCommandShell comShell = new ConsoleCommandShell((Agent)busMaster);
        JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        shell.run();
        System.exit(0);
    }

    public class BusMasterCommands {
        public List<String> listSubsystems() {
            return this.listSubsystems(new Options(), "Worker", true);
        }

        @Option(name="host", description="Show the host information")
        @Command(name="listSubsystems", description="List the subsystems on the CCS buses for a given Agent type", alias="ls")
        public List<String> listSubsystems(Options options, @Argument(name="Agent type", defaultValue="Worker") String agentType, @Argument(defaultValue="true") boolean allTypesAbove) {
            AgentInfo.AgentType referenceType = AgentInfo.AgentType.valueOf((String)agentType.toUpperCase());
            ArrayList<String> result = new ArrayList<String>();
            for (AgentInfo agent : ConsoleCommandShell.this.messagingAccess.getAgentPresenceManager().listConnectedAgents()) {
                if ((!allTypesAbove || agent.getType().ordinal() < referenceType.ordinal()) && agent.getType().ordinal() != referenceType.ordinal()) continue;
                result.add(this.getAgentInformation(agent, options));
            }
            Collections.sort(result);
            return result;
        }

        private String getAgentInformation(AgentInfo agentInfo, Options options) {
            StringBuilder sb = new StringBuilder();
            sb.append(agentInfo.getName());
            if (options.hasOption("host")) {
                sb.append("[");
                String host = agentInfo.getAgentProperty("org.lsst.ccs.agent.hostname");
                if (host != null && !host.isEmpty()) {
                    sb.append("host=").append(host);
                    String jmxport = agentInfo.getAgentProperty("org.lsst.ccs.agent.jmxport");
                    if (jmxport != null && !jmxport.isEmpty()) {
                        sb.append(":").append(jmxport);
                    }
                }
                sb.append("]");
            }
            return sb.toString();
        }

        @Command(description="Set Console parameters")
        public void set(@Argument(name="item") ConsoleParameters what, @Argument(name="value") String value) {
            if (what == ConsoleParameters.TIMEOUT) {
                ConsoleCommandShell.this.sci.setDefaultTimeout(Duration.ofMillis(Long.valueOf(value)));
            } else if (what == ConsoleParameters.SHOW_JYTHON_OUTPUT) {
                if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                    ConsoleCommandShell.this.jythonConsoleSocketConnection.setPrintStream(value.equals("true") ? System.out : null);
                }
                ConsoleCommandShell.this.showJythonOutput = value;
            }
        }

        @Command(description="Set Dictionary Category Visibility")
        public void set(@Argument(name="item") Visibility what, @Argument(name="category") Command.CommandCategory category, boolean visibility) {
            if (what == Visibility.VISIBILITY) {
                ConsoleCommandShell.this.rsc.getCommandDictionary().setCategoryVisible(category, visibility);
            }
        }

        @Command(description="Get Dictionary Category Visibility")
        public boolean get(@Argument(name="item") Visibility what, @Argument(name="category") Command.CommandCategory category) {
            if (what == Visibility.VISIBILITY) {
                return ConsoleCommandShell.this.rsc.getCommandDictionary().isCategoryVisible(category);
            }
            throw new UnsupportedOperationException("Unknown item " + (Object)((Object)what));
        }

        @Command(description="Get a Console parameter")
        public String get(@Argument(name="item") ConsoleParameters what) {
            if (what == ConsoleParameters.TIMEOUT) {
                return String.valueOf(ConsoleCommandShell.this.sci.getDefaultTimeout().toMillis());
            }
            if (what == ConsoleParameters.SHOW_JYTHON_OUTPUT) {
                return ConsoleCommandShell.this.showJythonOutput;
            }
            return null;
        }

        @Command(description="Execute a Jython script")
        public void executeScript(@Argument(name="scriptPath") String scriptPath, String ... args) throws IOException {
            JythonScriptExecutorUtils.executeScript((String)scriptPath, (String[])args);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void connectToJythonConsole(@Argument(name="host", defaultValue="localhost") String host, @Argument(name="port", defaultValue="4444") int port) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                throw new RuntimeException("There is already a connection established. There can be only one! Please \"closeConnectionWithJythonConsole\" before opening a new one.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection = new JythonConsoleSocketConnection("CommandShellConnection_" + System.currentTimeMillis(), port, host);
            ConsoleCommandShell.this.jythonConsoleSocketConnection.setPrintStream(ConsoleCommandShell.this.showJythonOutput.equals("true") ? System.out : null);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void submitScript(@Argument(name="scriptPath") String scriptPath, String ... args) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("No connection was established with a JythonConsole. Please invoke \"connectToJythonConsole\" first");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.asynchFileExecution(scriptPath, args);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void closeConnectionWithJythonConsole() throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("There is open connection to a JythonConsole.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.close();
            ConsoleCommandShell.this.jythonConsoleSocketConnection = null;
        }
    }

    public static enum Visibility {
        VISIBILITY;

    }

    public static enum ConsoleParameters {
        TIMEOUT,
        SHOW_JYTHON_OUTPUT;

    }
}

