/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;

public abstract class ErrorManager {
    public static final int UNKNOWN = 0;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 16;
    public static final int USER = 256;
    public static final int EXCEPTION = 4096;
    public static final int ERROR = 65536;
    private static DelegatingErrorManager current;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorManager getDefault() {
        Class clazz = class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ErrorManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager;
        synchronized (clazz) {
            if (current != null) {
                return current;
            }
        }
        return ErrorManager.getDefaultDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DelegatingErrorManager getDefaultDelegate() {
        DelegatingErrorManager c = new DelegatingErrorManager("");
        c.initialize();
        Class clazz = class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ErrorManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager;
        synchronized (clazz) {
            if (current == null) {
                current = c;
                ErrorManager.current.r.addLookupListener(current);
            }
        }
        return current;
    }

    public abstract Throwable attachAnnotations(Throwable var1, Annotation[] var2);

    public abstract Annotation[] findAnnotations(Throwable var1);

    public abstract Throwable annotate(Throwable var1, int var2, String var3, String var4, Throwable var5, Date var6);

    public abstract void notify(int var1, Throwable var2);

    public final void notify(Throwable t) {
        this.notify(4096, t);
    }

    public abstract void log(int var1, String var2);

    public final void log(String s) {
        this.log(1, s);
    }

    public boolean isLoggable(int severity) {
        return true;
    }

    public boolean isNotifiable(int severity) {
        return this.isLoggable(severity);
    }

    public abstract ErrorManager getInstance(String var1);

    public final Throwable annotate(Throwable t, String localizedMessage) {
        return this.annotate(t, 4096, null, localizedMessage, null, null);
    }

    public final Throwable annotate(Throwable target, Throwable t) {
        return this.annotate(target, 4096, null, null, t, null);
    }

    public final Throwable copyAnnotation(Throwable t, Throwable copyFrom) {
        return this.annotate(t, 0, null, null, copyFrom, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Annotation {
        public String getMessage();

        public String getLocalizedMessage();

        public Throwable getStackTrace();

        public Date getDate();

        public int getSeverity();
    }

    private static class DelegatingErrorManager
    extends ErrorManager
    implements LookupListener {
        private String name = null;
        private Set delegates = new HashSet();
        private WeakSet createdByMe = new WeakSet();
        Lookup.Result r;

        public DelegatingErrorManager(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ErrorManager getInstance(String name) {
            if (name == null || "".equals(name)) {
                return this;
            }
            DelegatingErrorManager dem = new DelegatingErrorManager(name);
            DelegatingErrorManager delegatingErrorManager = this;
            synchronized (delegatingErrorManager) {
                this.attachNewDelegates(dem, name);
                this.createdByMe.add(dem);
            }
            return dem;
        }

        public Throwable attachAnnotations(Throwable t, Annotation[] arr) {
            Iterator i = this.delegates.iterator();
            while (i.hasNext()) {
                ErrorManager em = (ErrorManager)i.next();
                em.attachAnnotations(t, arr);
            }
            return t;
        }

        public Annotation[] findAnnotations(Throwable t) {
            Iterator i = this.delegates.iterator();
            while (i.hasNext()) {
                ErrorManager em = (ErrorManager)i.next();
                Annotation[] res = em.findAnnotations(t);
                if (res == null || res.length <= 0) continue;
                return res;
            }
            return new Annotation[0];
        }

        public Throwable annotate(Throwable t, int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
            Iterator i = this.delegates.iterator();
            while (i.hasNext()) {
                ErrorManager em = (ErrorManager)i.next();
                em.annotate(t, severity, message, localizedMessage, stackTrace, date);
            }
            return t;
        }

        public void notify(int severity, Throwable t) {
            if (this.delegates.isEmpty()) {
                t.printStackTrace();
            }
            Iterator i = this.delegates.iterator();
            while (i.hasNext()) {
                ErrorManager em = (ErrorManager)i.next();
                em.notify(severity, t);
            }
        }

        public void log(int severity, String s) {
            if (this.delegates.isEmpty()) {
                System.err.println("Log: " + severity + " msg: " + s);
            }
            Iterator i = this.delegates.iterator();
            while (i.hasNext()) {
                ErrorManager em = (ErrorManager)i.next();
                em.log(severity, s);
            }
        }

        public boolean isLoggable(int severity) {
            if (this.delegates.isEmpty()) {
                return true;
            }
            Iterator i = this.delegates.iterator();
            while (i.hasNext()) {
                ErrorManager em = (ErrorManager)i.next();
                if (!em.isLoggable(severity)) continue;
                return true;
            }
            return false;
        }

        public boolean isNotifiable(int severity) {
            if (this.delegates.isEmpty()) {
                return true;
            }
            Iterator i = this.delegates.iterator();
            while (i.hasNext()) {
                ErrorManager em = (ErrorManager)i.next();
                if (!em.isNotifiable(severity)) continue;
                return true;
            }
            return false;
        }

        public synchronized void setDelegates(Collection newDelegates) {
            HashSet d = new HashSet(newDelegates);
            Iterator i = this.createdByMe.iterator();
            while (i.hasNext()) {
                DelegatingErrorManager dem = (DelegatingErrorManager)i.next();
                this.attachNewDelegates(dem, dem.getName());
            }
            this.delegates = d;
        }

        private String getName() {
            return this.name;
        }

        private void attachNewDelegates(DelegatingErrorManager dem, String name) {
            HashSet<ErrorManager> newDelegatesForDem = new HashSet<ErrorManager>();
            Iterator j = this.delegates.iterator();
            while (j.hasNext()) {
                ErrorManager e = (ErrorManager)j.next();
                newDelegatesForDem.add(e.getInstance(name));
            }
            dem.setDelegates(newDelegatesForDem);
        }

        public void initialize() {
            this.r = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ErrorManager.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager));
            Collection instances = this.r.allInstances();
            this.setDelegates(instances);
        }

        public void resultChanged(LookupEvent ev) {
            if (this.r != null) {
                Collection instances = this.r.allInstances();
                this.setDelegates(instances);
            }
        }
    }
}

