/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups.tester;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.tests.Probe;

public class Node {
    private static final AtomicInteger ID = new AtomicInteger();
    private static final String CLUSTER_NAME = "DEF_CLUSTER";
    private final String name;
    private final boolean showGUI;
    private JChannel channel;
    private JFrame frame;
    private int level = Level.INFO.intValue();

    public Node() {
        this(Integer.toString(ID.getAndIncrement()), true);
    }

    public Node(String name, boolean showGUI) {
        this.name = name;
        this.showGUI = showGUI;
    }

    private void start() {
        if (this.showGUI) {
            SwingUtilities.invokeLater(this::makeGUI);
        }
    }

    private void stop() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.channel.close();
    }

    private void makeGUI() {
        this.frame = new JFrame(this.name);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Node.this.stop();
            }
        });
        Box root = Box.createVerticalBox();
        this.frame.add(new JScrollPane(root));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Output level: "));
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        Level[] levels = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINER, Level.FINEST};
        JComboBox<Level> combo = new JComboBox<Level>(levels);
        combo.setSelectedItem(Level.INFO);
        combo.addActionListener(e -> {
            JComboBox c = (JComboBox)e.getSource();
            this.level = ((Level)c.getSelectedItem()).intValue();
        });
        box.add(combo);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        JButton b = new JButton("Create channel");
        b.addActionListener(e -> {
            ((JButton)e.getSource()).setEnabled(false);
            this.createChannel();
        });
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        b = new JButton("Connect");
        b.addActionListener(e -> {
            if (e.getActionCommand().equals("Connect")) {
                ((JButton)e.getSource()).setText("Disconnect");
                this.connectChannel();
            } else {
                ((JButton)e.getSource()).setText("Connect");
                this.disconnectChannel();
            }
        });
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        b = new JButton("Send");
        b.addActionListener(e -> this.sendMessage());
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        b = new JButton("View");
        b.addActionListener(e -> this.logView());
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        box.add(new JLabel("Probe"));
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        JTextField f = new JTextField();
        f.addActionListener(e -> this.probe(e.getActionCommand()));
        box.add(f);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        root.add(Box.createVerticalGlue());
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void createChannel() {
        try {
            this.channel = new JChannel(System.getProperty("user.dir") + "/src/main/java/org/lsst/ccs/messaging/jgroups/tester/udp_0.xml");
            this.channel.setName(this.name);
            String text = "Channel configuration:\n" + this.channel.getProperties();
            this.log(text, Level.FINE);
            this.channel.setReceiver((Receiver)new MessageReceiver());
        }
        catch (Exception x) {
            throw new RuntimeException("Error creating channel", x);
        }
    }

    private void connectChannel() {
        try {
            this.channel.connect(CLUSTER_NAME);
        }
        catch (Exception x) {
            throw new RuntimeException("Error connecting channel", x);
        }
    }

    private void disconnectChannel() {
        try {
            this.channel.disconnect();
        }
        catch (Exception x) {
            throw new RuntimeException("Error disconnecting channel", x);
        }
    }

    private void sendMessage() {
        try {
            this.channel.send(null, (Object)"default payload");
        }
        catch (Exception x) {
            throw new RuntimeException("Error sending message", x);
        }
    }

    private void logView() {
        this.log(this.channel.getViewAsString(), Level.OFF);
    }

    private void probe(String text) {
        Object[] ss = text.split("\\s");
        this.log(Arrays.toString(ss), Level.FINE);
        try {
            Probe.main((String[])ss);
        }
        catch (Exception x) {
            this.log(x, Level.WARNING);
        }
    }

    private void log(Object what, Level level) {
        if (level.intValue() >= this.level) {
            System.out.println("");
            System.out.println("From " + this.name + ": ");
            System.out.println(what);
        }
    }

    public static void main(String ... args) throws Exception {
        Node node = new Node();
        node.start();
        node = new Node();
        node.start();
        node = new Node();
        node.start();
    }

    private class MessageReceiver
    extends ReceiverAdapter {
        private MessageReceiver() {
        }

        public void unblock() {
            Node.this.log("unblock()", Level.FINEST);
        }

        public void block() {
            Node.this.log("block()", Level.FINEST);
        }

        public void suspect(Address mbr) {
            Node.this.log("suspect() " + mbr, Level.FINEST);
        }

        public void viewAccepted(View view) {
            Node.this.log("viewAccepted() " + view, Level.FINEST);
        }

        public void setState(InputStream input) throws Exception {
            super.setState(input);
        }

        public void getState(OutputStream output) throws Exception {
            super.getState(output);
        }

        public void receive(Message msg) {
            Node.this.log("receive() " + msg.getSrc(), Level.FINEST);
        }
    }
}

