/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.SingleCategoryTag;

public class ConfigurationDescription
implements Serializable {
    private static final long serialVersionUID = 2262886830605244842L;
    @Deprecated
    public static final String DEFAULT_CONFIG_NAME = "";
    @Deprecated
    public static final String DEFAULT_INITIAL_CONFIG_NAME = "defaultInitial";
    @Deprecated
    public static final String DEFAULT_CAT = "";
    @Deprecated
    public static final String SAFE_CONFIG_NAME = "safe";
    @Deprecated
    private String name = null;
    private int version = -3;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, CategoryDescription> categoryTagsMap = new TreeMap<String, CategoryDescription>();

    public ConfigurationDescription() {
    }

    public ConfigurationDescription(Set<String> categories) {
        this.categories.addAll(categories);
    }

    public static ConfigurationDescription initialDefaultConfiguration(Set<String> categories, String defaultSource) {
        ConfigurationDescription res = new ConfigurationDescription(categories);
        return res.withDefaultInitial(true, defaultSource);
    }

    @Deprecated
    public final ConfigurationDescription parseConfigurationString(String defaultSource, String ... taggedCategories) {
        if (taggedCategories == null || taggedCategories.length == 0) {
            return this;
        }
        for (String s : taggedCategories) {
            CategoryDescription categoryTag = CategoryDescription.parseCategoryTagInput(s, defaultSource);
            this.addCategoryTag(categoryTag);
        }
        return this;
    }

    public final ConfigurationDescription parseConfigurationDescription(String description, String defaultSource) {
        String[] taggedCategories = description.split(",");
        if (taggedCategories == null || taggedCategories.length == 0) {
            return this;
        }
        for (String s : taggedCategories) {
            CategoryDescription categoryTag = CategoryDescription.parseCategoryTagInput(s, defaultSource);
            this.addCategoryTag(categoryTag);
        }
        return this;
    }

    public void removeCategory(String cat) {
        this.categories.remove(cat);
        this.categoryTagsMap.remove(cat);
    }

    public ConfigurationDescription withDefaultInitial(boolean withDefaults, String defaultSource) {
        if (withDefaults) {
            for (String cat : this.categories) {
                if (this.categoryTagsMap.containsKey(cat)) continue;
                this.putSourcedTagForCategory(cat, DEFAULT_INITIAL_CONFIG_NAME, defaultSource, "d");
            }
        }
        return this;
    }

    public void addCategoryTag(CategoryDescription categoryTag) {
        String cat = categoryTag.getCategoryName();
        this.categories.add(cat);
        CategoryDescription newCat = new CategoryDescription(categoryTag.getCategoryName()).merge(categoryTag);
        newCat.setHasChanges(categoryTag.hasChanges);
        this.categoryTagsMap.put(cat, newCat);
    }

    @Deprecated
    public void putTagForCategory(String cat, String tag, String version) {
        this.putSourcedTagForCategory(cat, tag, null, version);
    }

    public void putSourcedTagForCategory(String cat, String tag, String source, String version) {
        CategoryDescription catTag = this.categoryTagsMap.get(cat);
        if (catTag == null) {
            catTag = new CategoryDescription(cat);
            this.categoryTagsMap.put(cat, catTag);
        }
        catTag.addOrUpdadateSingleTagVersion(source, tag, version);
    }

    public void putSingleTagForCategory(String cat, SingleCategoryTag sourcedTag, String version) {
        CategoryDescription catTag = this.categoryTagsMap.get(cat);
        if (catTag == null) {
            catTag = new CategoryDescription(cat);
            this.categoryTagsMap.put(cat, catTag);
        }
        catTag.addSingleTagVersion(sourcedTag, version, true);
    }

    public Set<String> getCategoriesSet() {
        return Collections.unmodifiableSet(this.categoryTagsMap.keySet());
    }

    public CategoryDescription getCategoryTag(String category) {
        return this.categoryTagsMap.get(category);
    }

    public boolean isEmpty() {
        return this.categoryTagsMap.isEmpty();
    }

    public boolean containsCategory(String category) {
        return this.categoryTagsMap.containsKey(category);
    }

    public String getDescriptionName() {
        return "[" + this.toString() + "]";
    }

    public int getVersion() {
        return this.version;
    }

    public ConfigurationDescription merge(ConfigurationDescription input) {
        for (String category : input.getCategoriesSet()) {
            CategoryDescription inputCategoryTag = input.getCategoryTag(category);
            CategoryDescription thisCategoryTag = this.getCategoryTag(category);
            if (thisCategoryTag == null) {
                this.categories.add(category);
                this.addCategoryTag(inputCategoryTag);
                continue;
            }
            for (SingleCategoryTag singleTag : inputCategoryTag.getSingleCategoryTags()) {
                thisCategoryTag.addOrUpdadateSingleTag(singleTag);
            }
        }
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.categoryTagsMap);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationDescription other = (ConfigurationDescription)obj;
        return this.categoryTagsMap.equals(other.categoryTagsMap);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(0);
        for (Map.Entry<String, CategoryDescription> e : this.categoryTagsMap.entrySet()) {
            CategoryDescription catTag = e.getValue();
            sb.append(catTag.toString());
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static ConfigurationDescription fromConfigurationInfo(ConfigurationInfo ci, Set<String> categories, String defaultSource) {
        ConfigurationDescription res = new ConfigurationDescription();
        for (String cat : ci.getConfigurationDescriptionObject().getCategoriesSet()) {
            if (!categories.contains(cat)) continue;
            res.addCategoryTag(ci.getConfigurationDescriptionObject().getCategoryTag(cat));
        }
        return res;
    }

    public static ConfigurationDescription fromConfigurationInfo(ConfigurationInfo ci, String defaultSource) {
        return ConfigurationDescription.fromConfigurationInfo(ci, ci.getCategorySet(), defaultSource);
    }
}

