/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ChecksumUtils;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ConfigurationDAOWrapper;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class ConfigurationService
implements ServiceLifecycle,
ClearAlertHandler,
AgentPresenceListener,
AgentService,
HasDataProviderInfos,
HasLifecycle {
    private static final Logger conf_sub_log = Logger.getLogger(ConfigurationService.class.getName());
    private static final Alert CS_ALERT_1 = new Alert("CCSCFGSRV", "configuration service unavailable");
    private static final Alert CS_ALERT_2 = new Alert("CCSCFGOP", "operator error");
    private ConfigurationDAOWrapper configurationDao;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, ComponentConfigurationEnvironment> keyEnvironmentMap = new HashMap<String, ComponentConfigurationEnvironment>();
    private String descriptionName;
    private String agentName;
    private boolean useFullPaths = false;
    private ConfigurationView groovyView = null;
    private boolean saveInitialConfiguration = false;
    private boolean migrateConfigurationFiles = false;
    private final Map<String, Serializable> configurationDataAttributes = new HashMap<String, Serializable>();
    private boolean publishChecksum = false;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();
    private boolean allowLoadingOfBuildCategory = true;
    private ConfigurationInfo currentConfigInfo;
    private ConfigurationHandlerSet configurationHandler;
    private ConfigurationView currentView;
    private ConfigurationDescription defaultInitialDescription = null;
    private ConfigurationView initialView;
    private volatile long lastPublishedConfigurationInfoMillis = 0L;
    private boolean canGoToConfigured = false;
    private final boolean testContext = System.getProperty("org.lsst.ccs.testcontext", "false").equals("true");
    private final List<ConfigurationListener> configurationListeners = new CopyOnWriteArrayList<ConfigurationListener>();
    private String userProvidedConfiguration = null;

    @Override
    public String getAgentServiceName() {
        return "configurationService";
    }

    public static Properties getBuildProperties(String agentName, String descriptionName) {
        try (ConfigurationDAOWrapper configurationProxy = new ConfigurationDAOWrapper(descriptionName);){
            Properties properties = ConfigurationService.getBuildProperties(configurationProxy, agentName, descriptionName);
            return properties;
        }
    }

    private static Properties getBuildProperties(ConfigurationDAOWrapper dao, String agentName, String descriptionName) {
        Properties res = new Properties();
        Properties inputProperties = BootUtils.getInputBuildProperties();
        if (inputProperties != null) {
            res = inputProperties;
        }
        if (descriptionName != null) {
            try {
                res.putAll((Map<?, ?>)dao.getConfigurationProperties("defaultInitial", "build", descriptionName));
            }
            catch (ConfigurationServiceException configurationServiceException) {
                // empty catch block
            }
        }
        if (agentName != null) {
            try {
                res.putAll((Map<?, ?>)dao.getConfigurationProperties("defaultInitial", "build", agentName));
            }
            catch (ConfigurationServiceException configurationServiceException) {
                // empty catch block
            }
        }
        return res;
    }

    public Properties getBuildProperties() {
        return ConfigurationService.getBuildProperties(this.configurationDao, this.agentName, this.descriptionName);
    }

    @Override
    public void shutdown() {
        if (this.configurationDao != null) {
            this.configurationDao.close();
        }
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        if (CS_ALERT_1.getAlertId().equals(alert.getAlertId())) {
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        if (CS_ALERT_2.getAlertId().equals(alert.getAlertId())) {
            return this.stateService.isInState((Enum)ConfigurationState.CONFIGURED) ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    @Override
    public void preBuild() {
        if (this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            this.configurationDataAttributes.put("type", (Serializable)((Object)"configuration-data-checksum"));
            this.publishChecksum = true;
        }
        if (BootstrapResourceUtils.getBootstrapSystemProperties().getOrDefault((Object)"org.lsst.ccs.config.remote", "false").equals("true")) {
            this.agentPropertiesService.setAgentProperty("org.lsst.ccs.config.remote", "true");
        }
        this.userProvidedConfiguration = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("startupConfig");
        if (this.userProvidedConfiguration != null && this.userProvidedConfiguration.isEmpty()) {
            this.userProvidedConfiguration = "defaultInitial";
        }
        String migrateConfigurationFilesStr = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("migrateConfigurationFiles");
        this.migrateConfigurationFiles = "true".equals(migrateConfigurationFilesStr);
        if (this.migrateConfigurationFiles) {
            System.setProperty("org.lsst.ccs.config.remote", "migrate");
        }
        String saveInitialConfigurationStr = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("saveInitialConfiguration");
        this.saveInitialConfiguration = "true".equals(saveInitialConfigurationStr);
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode configServiceNode = lookup.getComponentNodeForObject((Object)this);
        ComponentNode topNode = lookup.getTopComponentNode();
        String descName = (String)topNode.getTag("descriptionName");
        this.descriptionName = descName == null ? this.agent.getClass().getSimpleName() : descName;
        this.agentName = this.agent.getName();
        this.configurationDao = new ConfigurationDAOWrapper(this.descriptionName, this);
        lookup.addComponentNodeToLookup(configServiceNode, new ComponentNode("configurationDAO", (Object)this.configurationDao));
        this.currentView = this.initialView = this.scanTreeAndBuildInitialView(true);
        this.initialView.putAll(this.buildUserProvidedConfigurationView(true));
        if (this.hasBuildParameters()) {
            this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, this.initialView, this.agentName, true, true);
            this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD, false);
        }
    }

    private ConfigurationView buildUserProvidedConfigurationView(boolean isBuild) {
        String[] providedConfs;
        this.categories.clear();
        this.categories.addAll(this.configurationHandler.getCategorySet());
        this.defaultInitialDescription = new ConfigurationDescription(this.categories).withDefaultInitial(true, null);
        if (this.userProvidedConfiguration != null) {
            this.defaultInitialDescription.parseConfigurationString(null, this.userProvidedConfiguration.split(","));
        }
        ConfigurationView userProvidedConfigurationView = this.groovyView != null ? this.groovyView : new ConfigurationView();
        Set<Object> categoriesToLoad = new HashSet();
        ConfigurationDescription startupDescription = null;
        String[] stringArray = providedConfs = this.userProvidedConfiguration != null ? this.userProvidedConfiguration.split(",") : new String[]{};
        if (isBuild) {
            if (this.hasBuildParameters()) {
                categoriesToLoad.add("build");
                startupDescription = new ConfigurationDescription(categoriesToLoad).withDefaultInitial(true, null);
                for (String conf : providedConfs) {
                    if (!conf.contains("build")) continue;
                    startupDescription = startupDescription.parseConfigurationString(conf, new String[0]);
                }
            }
        } else {
            categoriesToLoad = this.categories;
            if (this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
                startupDescription = new ConfigurationDescription(categoriesToLoad).parseConfigurationString(null, providedConfs).withDefaultInitial(true, null);
            }
        }
        if (startupDescription != null) {
            startupDescription = this.checkStartupConfigurationForImplicitSources(startupDescription, isBuild);
            ConfigurationView additionalUserProvidedConfigurationView = this.configurationDao.initialLoadConfiguration(startupDescription);
            userProvidedConfigurationView.putAll(additionalUserProvidedConfigurationView);
            this.defaultInitialDescription = userProvidedConfigurationView.getConfigurationDescription();
        }
        if (userProvidedConfigurationView.getConfigurationDescription() == null) {
            userProvidedConfigurationView.setConfigurationDescription(this.defaultInitialDescription);
        }
        return userProvidedConfigurationView;
    }

    @Override
    public void preInit() {
        this.allowLoadingOfBuildCategory = false;
        this.currentView = this.initialView = this.scanTreeAndBuildInitialView(false);
        ConfigurationView userProvided = this.buildUserProvidedConfigurationView(false);
        this.initialView.putAll(userProvided);
        this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, userProvided, this.agentName, false, true);
        this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD);
        if (this.saveInitialConfiguration) {
            this.saveFullConfiguration();
            System.exit(0);
        }
        if (this.migrateConfigurationFiles) {
            System.exit(0);
        }
    }

    ConfigurationView getCurrentConfigurationView() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = new ConfigurationView(this.currentView);
            return configurationView;
        }
    }

    private boolean hasBuildParameters() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            for (String category : this.categories) {
                CategoryHandler categoryHandler = this.configurationHandler.getCategoryHandler(category);
                for (ConfigurationParameterHandler cph : categoryHandler.getParameters()) {
                    if (!cph.isBuild()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    private ConfigurationView scanTreeAndBuildInitialView(boolean isBuild) {
        boolean useFullPathsFromBuild = this.useFullPaths;
        this.useFullPaths = "true".equals(this.agent.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
        if (!isBuild && useFullPathsFromBuild != this.useFullPaths) {
            conf_sub_log.log(Level.WARNING, "Inconsistent value of property \"org.lsst.ccs.use.full.paths\" detected between the BUILD and INIT phases.\nThis could cause serious problems to che ConfigurationService when applying build level properties. Please update your code to set such property earlier in the Agent lifecycle. Please refer to https://jira.slac.stanford.edu/browse/LSSTCCS-1757 on how that could be done.");
        }
        boolean checkConfigViews = this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0;
        boolean failOnViewProblems = checkConfigViews && !this.saveInitialConfiguration;
        this.configurationHandler = new ConfigurationHandlerSet(this.useFullPaths, checkConfigViews, failOnViewProblems);
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode topNode = lookup.getTopComponentNode();
        TreeWalkerUtils.proceduralNodeWalk(lookup, null, n -> {
            String nodeName = this.useFullPaths ? n.getPath() : n.getKey();
            Object component = n.getComponent();
            ConfigurationHandler ch = this.configurationHandler.addConfigurationHandlerForObject(nodeName, n.getPath(), component);
            if (ch != null && !isBuild && ch.hasRuntimeParameters()) {
                ComponentConfigurationEnvironment cce = new ComponentConfigurationEnvironment(nodeName, this);
                this.keyEnvironmentMap.put(nodeName, cce);
                this.agentCommandDictionaryService.addCommandSetToObject(cce, n.getPath());
            }
        }, null);
        ConfigurationView initialView = new ConfigurationView();
        initialView.putAll(this.configurationHandler.getLiveConfigurationView());
        if (this.groovyView == null) {
            this.groovyView = new ConfigurationView();
            Map topNodeTags = topNode.getTags();
            for (Map.Entry entry : topNodeTags.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                try {
                    ParameterPath path;
                    String[] split;
                    String value = TypeUtils.stringify(entry.getValue());
                    String parPath = (String)entry.getKey();
                    if (!this.useFullPaths && (split = parPath.split("/")).length > 1) {
                        parPath = split[split.length - 2] + "/" + split[split.length - 1];
                    }
                    if (!this.isParameterConfigurable((path = ParameterPath.valueOf((String)parPath)).getComponentName(), path.getParameterName())) continue;
                    this.groovyView.putParameterValue(path.toString(), value);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        initialView.putAll(this.groovyView);
        return initialView;
    }

    @Override
    public void preStart() {
        this.canGoToConfigured = true;
        if (this.currentConfigInfo.getConfigurationState() != ConfigurationState.CONFIGURED) {
            this.currentConfigInfo.setConfigurationState(ConfigurationState.CONFIGURED);
            this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD);
        }
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    @Override
    public List<DataProviderInfo> getDataProviderInfos() {
        List dataList = this.configurationHandler.getDataPoviderInfoList();
        if (this.publishChecksum) {
            for (String category : this.categories) {
                DataProviderInfo data = new DataProviderInfo("config/data/" + (category.isEmpty() ? "default" : category) + "/checksum", DataProviderInfo.Type.TRENDING, "config/data/" + (category.isEmpty() ? "default" : category) + "/checksum");
                data.addAttribute(DataProviderInfo.Attribute.UNITS, "unitless");
                data.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Configuration data checksum for category " + (category.isEmpty() ? "default" : category));
                data.addAttribute(DataProviderInfo.Attribute.DO_NOT_TREND, "true");
                dataList.add(data);
            }
        }
        return dataList;
    }

    @Override
    public void publishDataProviderCurrentData(AgentInfo agentInfo) {
        if (agentInfo != null && agentInfo.getAgentOperationalTime().getUTCInstant().isBefore(CCSTimeStamp.currentTimeFromMillis(this.lastPublishedConfigurationInfoMillis).getUTCInstant())) {
            conf_sub_log.log(Level.FINER, "Skipping configuration info publication. Last published on {0} compared to {1}", new Object[]{CCSTimeStamp.currentTimeFromMillis(this.lastPublishedConfigurationInfoMillis).getUTCInstant(), agentInfo.getAgentOperationalTime().getUTCInstant()});
            return;
        }
        this.publishConfigurationInfo();
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String getConfigurationParameterValue(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName) {
        StringBuilder sb = new StringBuilder();
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        return (String)view.getValuesForComponent(componentName).get(parameterName);
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String printConfigurationParameters(@Argument(defaultValue="[]") Set<String> cats) {
        return this.printConfigParameters(false, cats);
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String printDirtyConfigurationParameters(@Argument(defaultValue="[]") Set<String> cats) {
        return this.printConfigParameters(true, cats);
    }

    private String printConfigParameters(boolean dirtyOnly, Set<String> cats) {
        StringBuilder sb = new StringBuilder();
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
            Set<String> categories = this.getCategories();
            for (String category : categories) {
                if (!cats.isEmpty() && !cats.contains(category)) continue;
                sb.append("Category : ").append(category).append("\n");
                CategoryHandler catHandler = this.configurationHandler.getCategoryHandler(category);
                for (ConfigurationParameterHandler par : catHandler.getParameters()) {
                    ParameterPath path = par.getParameterPath();
                    ConfigurationParameterInfo cpi = this.getConfigurationInfo().getCurrentParameterInfo(path.toString());
                    if (dirtyOnly && !cpi.isDirty()) continue;
                    String configType = par.isFinal() ? "final" : (par.isBuild() ? "build" : (par.isReadOnly() ? "read-only" : ""));
                    sb.append(path).append(cpi.isDirty() ? "*" : "").append(" ").append(view.getPathValue(path)).append(" ").append(par.getUnits()).append(configType.isEmpty() ? "" : " (" + configType + ")").append("\n");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Deprecated
    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void saveAllChanges() {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkForSubmittedChanges();
            this.saveAllChanges(false);
        }
    }

    private void saveAllChanges(boolean fullConfiguration) {
        ConfigurationDescription cd = this.getPartialConfigurationDescription(this.categories.toArray(new String[1]));
        this.saveChangesForCategoriesInternal(cd, fullConfiguration);
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void saveFullConfiguration() {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkForSubmittedChanges();
            this.saveAllChanges(true);
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void saveChangesForCategories(String ... categories) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkForSubmittedChanges();
            ConfigurationDescription currentDescription = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo, (String)this.agentName);
            ConfigurationDescription saveDescription = new ConfigurationDescription();
            for (String category : categories) {
                CategoryDescription categoryTag = null;
                if (category.contains(":")) {
                    categoryTag = CategoryDescription.parseCategoryTagInput((String)category, (String)this.agentName);
                    if (categoryTag.getSingleCategoryTags().size() > 1) {
                        throw new IllegalArgumentException("When saving configurations we accept only one tag. Illegal input: " + categoryTag);
                    }
                } else {
                    categoryTag = currentDescription.getCategoryTag(category);
                }
                String cat = categoryTag.getCategoryName();
                categoryTag = new CategoryDescription(cat).merge(this.defaultInitialDescription.getCategoryTag(cat)).merge(categoryTag);
                saveDescription.addCategoryTag(categoryTag);
            }
            this.saveChangesForCategoriesInternal(saveDescription, false);
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void saveFullConfigurationForCategories(String ... categories) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkForSubmittedChanges();
            ConfigurationDescription currentDescription = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo, (String)this.agentName);
            ConfigurationDescription saveDescription = new ConfigurationDescription();
            for (String category : categories) {
                CategoryDescription categoryTag = null;
                if (category.contains(":")) {
                    categoryTag = CategoryDescription.parseCategoryTagInput((String)category, (String)this.agentName);
                    if (categoryTag.getSingleCategoryTags().size() > 1) {
                        throw new IllegalArgumentException("When saving configurations we accept only one tag. Illegal input: " + categoryTag);
                    }
                } else {
                    categoryTag = currentDescription.getCategoryTag(category);
                }
                String cat = categoryTag.getCategoryName();
                categoryTag = new CategoryDescription(cat).merge(this.defaultInitialDescription.getCategoryTag(cat)).merge(categoryTag);
                saveDescription.addCategoryTag(categoryTag);
            }
            this.saveChangesForCategoriesInternal(saveDescription, true);
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    @Deprecated
    public void saveChangesForCategoriesAs(String ... taggedCategories) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkForSubmittedChanges();
            ConfigurationDescription cd = new ConfigurationDescription(this.categories);
            cd.parseConfigurationString(this.agentName, taggedCategories);
            for (String category : cd.getCategoriesSet()) {
                CategoryDescription categoryTag = cd.getCategoryTag(category);
                if (categoryTag.getSingleCategoryTags().size() <= 1) continue;
                throw new IllegalArgumentException("When saving configurations we accept only one tag. Illegal input: " + categoryTag);
            }
            ConfigurationDescription res = new ConfigurationDescription();
            for (String category : cd.getCategoriesSet()) {
                CategoryDescription ct = new CategoryDescription(category).merge(this.defaultInitialDescription.getCategoryTag(category));
                CategoryDescription saveTag = cd.getCategoryTag(category);
                if (ct == null) {
                    ct = saveTag;
                } else {
                    ct.merge(saveTag);
                }
                res.addCategoryTag(ct);
            }
            this.saveChangesForCategoriesInternal(res, false);
        }
    }

    private void saveChangesForCategoriesInternal(ConfigurationDescription configDesc, boolean fullConfiguration) {
        this.checkValidStates(true);
        if (configDesc.isEmpty()) {
            return;
        }
        this.checkCategories(configDesc.getCategoriesSet());
        try {
            ConfigurationView currentView = this.configurationHandler.getLiveConfigurationView();
            ConfigurationView diff = this.extractConfigurationViewFromCurrentConfigurationInfo().diff(currentView);
            if (!diff.isEmpty()) {
                StringBuilder sb = new StringBuilder("the following parameters have had their value changed without notifying the configuration service : \n");
                for (ParameterPath parm : diff.getAsParameterPathMap().keySet()) {
                    sb.append(parm).append(" expected ").append(this.currentConfigInfo.getCurrentValueForParameter(parm.toString())).append(" was ").append(currentView.getPathValue(parm)).append("\n");
                }
                throw new BulkSettingException(sb.toString());
            }
            currentView.setConfigurationDescription(configDesc);
            ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(currentView);
            ConfigurationInfo ci = ciBuilder.build();
            ConfigurationDescription desc = this.configurationDao.saveChangesForCategoriesAs(configDesc, ci, fullConfiguration);
            this.updateStateAndSendStatusConfigurationInfo(ci, ConfigurationListener.ConfigurationOperation.SAVE);
        }
        catch (RuntimeException ex) {
            this.handleException(ex, ConfigurationListener.ConfigurationOperation.SAVE);
        }
    }

    private ConfigurationDescription getPartialConfigurationDescription(String ... categories) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(categories));
        return ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo, set, (String)this.agentName);
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropAllChanges() {
        this.dropChangesInternal(this.categories);
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropChangesForCategories(String ... categories) {
        HashSet<String> catSet = new HashSet<String>();
        catSet.addAll(Arrays.asList(categories));
        this.dropChangesInternal(catSet);
    }

    private void dropChangesInternal(Set<String> categories) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            this.checkCategories(categories);
            try {
                ConfigurationView view = new ConfigurationView(this.getPartialConfigurationDescription(categories.toArray(new String[1])));
                for (ConfigurationParameterInfo cpi : this.currentConfigInfo.getAllParameterInfo()) {
                    if (!categories.contains(cpi.getCategoryName())) continue;
                    view.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getConfiguredValue());
                }
                ConfigurationView res = this.configurationHandler.loadCategories(view);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.DROP);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.DROP);
            }
        }
    }

    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void loadConfiguration(String ... taggedCategories) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(false);
            this.checkForSubmittedChanges();
            ConfigurationDescription res = new ConfigurationDescription();
            res.merge(this.defaultInitialDescription);
            ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(this.agentName, taggedCategories);
            res.merge(configDesc);
            this.loadCategoriesInternal(res);
        }
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void loadCategories(String ... taggedCategories) {
        if (taggedCategories.length == 0) {
            return;
        }
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            this.checkForSubmittedChanges();
            ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(this.agentName, taggedCategories);
            ConfigurationDescription res = new ConfigurationDescription();
            for (String category : configDesc.getCategoriesSet()) {
                CategoryDescription catTag = new CategoryDescription(category);
                catTag.merge(this.defaultInitialDescription.getCategoryTag(category));
                catTag.merge(configDesc.getCategoryTag(category));
                res.addCategoryTag(catTag);
            }
            this.loadCategoriesInternal(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCategoriesInternal(ConfigurationDescription configDesc) {
        this.checkCategories(configDesc.getCategoriesSet());
        if (!this.allowLoadingOfBuildCategory) {
            configDesc.removeCategory("build");
        }
        ConfigurationView view = this.currentView;
        ConfigurationView loadedView = null;
        Exception exception = null;
        try {
            loadedView = this.configurationDao.loadConfiguration(configDesc);
            if (this.testContext) {
                for (String category : configDesc.getCategoriesSet()) {
                    for (ConfigurationParameterHandler cph : this.getCategoryParameters(category)) {
                        ParameterPath parPath = cph.getParameterPath();
                        if (loadedView.containsPath(parPath)) continue;
                        loadedView.putParameterValue(parPath.toString(), this.getInitialView().getPathValue(parPath));
                    }
                }
            }
            loadedView = this.configurationHandler.loadCategories(loadedView);
        }
        catch (Exception e) {
            exception = e;
            conf_sub_log.log(Level.WARNING, "Failed to load configuration " + configDesc.getDescriptionName(), e);
            this.notifyConfigurationListeners(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD, e);
        }
        finally {
            if (exception != null) {
                conf_sub_log.log(Level.WARNING, "Rolling back to previously loade configuration: {0}", view.getConfigurationDescription().getDescriptionName());
                loadedView = this.configurationHandler.loadCategories(view);
                loadedView.setConfigurationDescription(new ConfigurationDescription());
            }
            ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(loadedView);
            this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.LOAD);
            if (exception != null) {
                this.handleException((RuntimeException)((Object)new ConfigurationServiceException("Failed Loading " + configDesc.getDescriptionName(), (Throwable)exception)), ConfigurationListener.ConfigurationOperation.LOAD);
            }
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public ConfigurationInfo getConfigurationInfo() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationInfo configurationInfo = this.currentConfigInfo;
            return configurationInfo;
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE)
    public String getConfigurationState() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            String string = this.currentConfigInfo.toString();
            return string;
        }
    }

    public void setReadOnlyParameter(String componentName, String parameterName, Object value) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            if (!this.isParameterReadOnly(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a read-only configuration parameter");
            }
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value, true);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    @Command(description="publish a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void publishConfigurationInfo() {
        this.lastPublishedConfigurationInfoMillis = System.currentTimeMillis();
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationInfo ci = this.getConfigurationInfo();
            this.agent.sendStatusMessage((StatusMessage)new StatusConfigurationInfo(ci));
            if (this.publishChecksum) {
                long start = System.currentTimeMillis();
                KeyValueDataList dataList = new KeyValueDataList("", this.configurationDataAttributes);
                for (String category : this.categories) {
                    TreeMap values = new TreeMap(ci.getCurrentValuesForCategory(category));
                    dataList.addData("config/data/" + (category.isEmpty() ? "default" : category) + "/checksum", (Serializable)Long.valueOf(ChecksumUtils.evaluateChecksum(values)));
                }
                this.agent.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
                long delta = System.currentTimeMillis() - start;
                conf_sub_log.log(Level.FINER, "Checksum evaluation tool {0} ms.", delta);
            }
        }
    }

    @Command(description="Submits a single change to be processed immediately", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void change(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName, Object value) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            if (!this.isParameterConfigurable(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a configuration parameter");
            }
            if (this.isParameterReadOnly(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is a read-only configuration parameter");
            }
            this.checkForSubmittedChanges();
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    public List<String> getAllConfigurableComponents() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ArrayList<String> arrayList = new ArrayList<String>(this.configurationHandler.getConfigurableComponents());
            return arrayList;
        }
    }

    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChange(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName, Object value) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            this.configurationHandler.submitChange(componentName, parameterName, value);
        }
    }

    @Command(description="Submits changes of parameters to be validated later", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChanges(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, Map<String, Object> changes) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            for (Map.Entry<String, Object> entry : changes.entrySet()) {
                this.configurationHandler.submitChange(componentName, entry.getKey(), entry.getValue());
            }
        }
    }

    @Command(description="processes the bulk change", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void commitBulkChange() {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            try {
                ConfigurationView view = this.configurationHandler.commitBulkChange(null);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
                conf_sub_log.log(Level.FINEST, this.currentConfigInfo.getLatestChanges().size() + " successfully set parameters");
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    @Command(description="Drops the submitted changes for all components", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropAllSubmittedChanges() {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.configurationHandler.dropAllSubmittedChanges();
        }
    }

    @Command(description="Drops the submitted changes for the given component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents", description="the component name") String name) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.configurationHandler.dropSubmittedChangesForComponent(name);
        }
    }

    @Command(description="Returns the current submitted changes for the given component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, String> getSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents", description="the component name") String name) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getSubmittedChangesForComponent(name);
            return map;
        }
    }

    @Command(description="Returns the current submitted changes for each component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getAllSubmittedChanges();
            return map;
        }
    }

    @Command(description="returns the categories of this subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE)
    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    List<String> getCategoriesList() {
        return new ArrayList<String>(this.getCategories());
    }

    @Command(description="returns the current values for a given component that belong to the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public Map<String, String> getCurrentValuesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, Set<String> categorySet) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getCurrentValuesForComponent(componentName, categorySet);
            return map;
        }
    }

    @Command(type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public boolean isParameterConfigurable(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            boolean bl = this.configurationHandler.isParameterConfigurable(componentName, parameterName);
            return bl;
        }
    }

    public boolean isParameterReadOnly(String componentName, String parameterName) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            boolean bl = this.configurationHandler.isParameterReadOnly(componentName, parameterName);
            return bl;
        }
    }

    public String getTag() {
        return this.descriptionName;
    }

    public void connected(AgentInfo ... ai) {
        for (AgentInfo a : ai) {
            if (!"true".equals(a.getAgentProperty("org.lsst.ccs.config.service"))) continue;
            this.publishConfigurationInfo();
            return;
        }
    }

    public ConfigurationLock acquireConfigurationLock() {
        return new ConfigurationLock();
    }

    public ConfigurationLock tryAcquireConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationLock(time, unit);
    }

    public ConfigurationWriteLock acquireConfigurationWriteLock() {
        return new ConfigurationWriteLock();
    }

    public ConfigurationWriteLock tryAcquireConfigurationWriteLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationWriteLock(time, unit);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Provided name cannot be null.");
        }
        ComponentConfigurationEnvironment environment = this.keyEnvironmentMap.get(name);
        if (environment == null) {
            throw new IllegalArgumentException("No Component with name \"" + name + "\" containing configuration parameters.");
        }
        return environment;
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.add(listener);
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.remove(listener);
    }

    private void notifyConfigurationListeners(ConfigurationInfo newConfigurationInfo, ConfigurationInfo oldConfigurationInfo, ConfigurationListener.ConfigurationOperation co) {
        for (ConfigurationListener l : this.configurationListeners) {
            try {
                l.configurationChanged(newConfigurationInfo, oldConfigurationInfo, co);
            }
            catch (Exception e) {
                conf_sub_log.log(Level.WARNING, "ConfigurationListener exception", e);
            }
        }
    }

    private void notifyConfigurationListeners(ConfigurationInfo configurationInfo, ConfigurationListener.ConfigurationOperation co, Exception exception) {
        for (ConfigurationListener l : this.configurationListeners) {
            try {
                l.failedConfigurationOperation(configurationInfo, co, exception);
            }
            catch (Exception e) {
                conf_sub_log.log(Level.WARNING, "ConfigurationListener exception", e);
            }
        }
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co) {
        this.updateStateAndSendStatusConfigurationInfo(ci, co, true);
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co, boolean notifyListeners) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo previousConfigurationInfo = this.currentConfigInfo;
            this.currentConfigInfo = ci;
            this.currentView = this.extractConfigurationViewFromConfigurationInfo(this.currentConfigInfo);
            this.stateService.updateInternalState(new AgentState[]{this.currentConfigInfo.getConfigurationState()});
            if (this.agent.isConnectedToTheBuses()) {
                this.publishConfigurationInfo();
            }
            if (notifyListeners) {
                this.notifyConfigurationListeners(this.currentConfigInfo, previousConfigurationInfo, co);
            }
            conf_sub_log.log(Level.INFO, "Updated configuration description to {0}", this.currentConfigInfo.getConfigurationDescription());
        }
    }

    public ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo.Builder builder = this.buildConfigurationInfoInternal(newView, true);
            return builder;
        }
    }

    public ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView, boolean mustBeComplete) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo.Builder builder = this.buildConfigurationInfoInternal(newView, mustBeComplete);
            return builder;
        }
    }

    private ConfigurationInfo.Builder buildConfigurationInfoInternal(ConfigurationView newView, boolean mustBeComplete) {
        ConfigurationDescription configDesc = newView.getConfigurationDescription();
        ConfigurationDescription fullConfigDesc = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo, (String)this.agentName);
        if (configDesc != null) {
            for (Object category : configDesc.getCategoriesSet()) {
                fullConfigDesc.addCategoryTag(configDesc.getCategoryTag((String)category));
            }
        }
        if (configDesc == null) {
            configDesc = new ConfigurationDescription(this.categories);
        }
        ConfigurationDescription cd = new ConfigurationDescription(this.categories);
        for (String cat : this.currentConfigInfo.getCategorySet()) {
            if (fullConfigDesc.containsCategory(cat)) {
                CategoryDescription categoryTag = fullConfigDesc.getCategoryTag(cat);
                cd.addCategoryTag(categoryTag);
                continue;
            }
            throw new RuntimeException("Should not have got here!");
        }
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(this.descriptionName);
        ConfigurationState nextState = ConfigurationState.CONFIGURED;
        for (Map.Entry entry : ConfigurationInfo.getParameterInfoGroupByCategory((List)this.currentConfigInfo.getAllParameterInfo()).entrySet()) {
            String category = (String)entry.getKey();
            boolean categoryCommitted = configDesc.containsCategory(category);
            boolean dirtyCat = false;
            for (ConfigurationParameterInfo cpi : (List)entry.getValue()) {
                boolean dirtyParm;
                ParameterPath path = ParameterPath.valueOf((String)cpi.getPathName());
                String currentValue = null;
                try {
                    currentValue = newView.getPathValue(path);
                }
                catch (Exception e) {
                    if (!mustBeComplete) continue;
                    throw e;
                }
                if (currentValue == null) continue;
                String configuredValue = categoryCommitted ? currentValue : cpi.getConfiguredValue();
                ciBuilder.addParameter(ParameterPath.valueOf((String)cpi.getPathName()), cpi.getActualType(), cpi.getCategoryName(), cpi.getDescription(), cpi.isFinal(), cpi.isReadOnly(), cpi.isBuild());
                boolean bl = dirtyParm = !cpi.isReadOnly() && !currentValue.equals(configuredValue);
                if (!currentValue.equals(this.currentConfigInfo.getCurrentValueForParameter(path.toString())) || dirtyParm != cpi.isDirty()) {
                    ciBuilder.addRecentChange(path.toString());
                }
                ciBuilder.updateParameter(ParameterPath.valueOf((String)cpi.getPathName()), configuredValue, currentValue, dirtyParm);
                if (!dirtyParm) continue;
                dirtyCat = true;
                nextState = ConfigurationState.DIRTY;
            }
            CategoryDescription categoryTag = cd.getCategoryTag(category);
            categoryTag.setHasChanges(dirtyCat);
        }
        if (!this.canGoToConfigured) {
            nextState = ConfigurationState.UNCONFIGURED;
        }
        return ciBuilder.setConfigurationState(nextState).setCCSTimeStamp(CCSTimeStamp.currentTime()).updateConfigurationDescription(cd.getDescriptionName());
    }

    ConfigurationView extractConfigurationViewFromCurrentConfigurationInfo() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = this.extractConfigurationViewFromConfigurationInfo(this.currentConfigInfo);
            return configurationView;
        }
    }

    ConfigurationView extractConfigurationViewFromConfigurationInfo(ConfigurationInfo ci) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = this.extractConfigurationViewFromConfigurationInfo(ci, Collections.emptySet());
            return configurationView;
        }
    }

    ConfigurationView extractConfigurationViewFromConfigurationInfo(ConfigurationInfo ci, Set<String> categories) {
        ConfigurationView cv = new ConfigurationView();
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            List list = ci.getAllParameterInfo();
            for (ConfigurationParameterInfo cpi : list) {
                String parameterCategory;
                if (!categories.isEmpty() && !categories.contains(parameterCategory = this.configurationHandler.getParameterSet(cpi.getComponentName()).getConfigurationParameterHandler(cpi.getParameterName()).getCategory())) continue;
                cv.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getCurrentValue());
            }
        }
        ConfigurationDescription cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci, (String)this.agentName);
        cv.setConfigurationDescription(cd);
        return cv;
    }

    private void checkCategories(Set<String> categories) {
        for (String cat : categories) {
            if (this.categories.contains(cat)) continue;
            throw new IllegalArgumentException("The provided category \"" + cat + "\" does not exist. Valid categories are: " + this.categories);
        }
    }

    private void checkValidStates(boolean failIfNotEM) {
        if (this.configurationHandler == null) {
            throw new IllegalStateException("the configuration service is not initialized yet");
        }
        if (failIfNotEM && !this.agent.isInEngineeringMode()) {
            throw new IllegalStateException("Fine grained configuration actions are accepted only in engineering mode");
        }
    }

    private void checkForSubmittedChanges() {
        if (this.configurationHandler.hasSubmittedChanges()) {
            throw new RuntimeException("A load/save/change operation cannot be performed while there are outstanding uncommitted changes.\nTo view the submitted changes issue the command \"getAllSubmittedChanges\".\nTo allow load/save/change operation you can either commit the submitted changes with \"commitBulkChange\" or you can drop them by issuing command \"dropAllSubmittedChanges\"");
        }
    }

    private void handleException(RuntimeException ex, ConfigurationListener.ConfigurationOperation co) {
        if (!co.equals((Object)ConfigurationListener.ConfigurationOperation.LOAD)) {
            ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
            this.updateStateAndSendStatusConfigurationInfo(this.buildConfigurationInfo(view).build(), co);
        }
        if (ex instanceof ConfigurationServiceException) {
            this.alertService.raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
        } else if (ex instanceof BulkSettingException) {
            this.alertService.raiseAlert(CS_ALERT_2, AlertState.ALARM, ex.getMessage());
        }
        throw ex;
    }

    public List<ConfigurationParameterHandler> getCategoryParameters(String category) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ArrayList result = new ArrayList(this.configurationHandler.getCategoryHandler(category).getParameters());
            List<ConfigurationParameterHandler> list = Collections.unmodifiableList(result);
            return list;
        }
    }

    public ConfigurationParameterHandler getParameterByPath(ParameterPath path) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationParameterHandler configurationParameterHandler = this.configurationHandler.getParameterSet(path.getComponentName()).getConfigurationParameterHandler(path.getParameterName());
            return configurationParameterHandler;
        }
    }

    public boolean saveInitialConfiguration() {
        return this.saveInitialConfiguration;
    }

    public ConfigurationDescription getInitialDescription() {
        ConfigurationDescription result = new ConfigurationDescription();
        if (this.defaultInitialDescription != null) {
            result.merge(this.defaultInitialDescription);
        }
        return result;
    }

    public ConfigurationView getInitialView() {
        ConfigurationView result = new ConfigurationView();
        if (this.initialView != null) {
            result.putAll(this.initialView);
        }
        return result;
    }

    private final ConfigurationDescription checkStartupConfigurationForImplicitSources(ConfigurationDescription configDescription, boolean isBuild) {
        String[] sourceNames = this.descriptionName.isEmpty() ? new String[]{this.agentName} : new String[]{this.descriptionName, this.agentName};
        if (configDescription.getDescriptionName().contains("{")) {
            conf_sub_log.log(Level.INFO, "Loading ConfigurationDescription with explicit sources: {0}", configDescription.getDescriptionName());
            return configDescription;
        }
        ConfigurationDescription sourcedConfigurationDescription = new ConfigurationDescription(configDescription.getCategoriesSet());
        for (String category : configDescription.getCategoriesSet()) {
            CategoryDescription categoryTag = configDescription.getCategoryTag(category);
            for (SingleCategoryTag sourcedTag : categoryTag.getSingleCategoryTags()) {
                if (sourcedTag.getSource() != null && !sourcedTag.getSource().equals("")) {
                    throw new RuntimeException("At this point we should only deal with empty sources: " + sourcedTag.getSource());
                }
                boolean foundSourceForTag = false;
                for (String source : sourceNames) {
                    boolean isLastSource = source.equals(sourceNames[sourceNames.length - 1]);
                    SingleCategoryTag singleCategoryTag = new SingleCategoryTag(source, sourcedTag.getTag(), category, sourcedTag.getVersion());
                    if (this.configurationDao.hasCategoryTagData(singleCategoryTag)) {
                        sourcedConfigurationDescription.putSingleTagForCategory(category, singleCategoryTag, singleCategoryTag.getVersion());
                        foundSourceForTag = true;
                    }
                    if (!isLastSource || foundSourceForTag) continue;
                    sourcedConfigurationDescription.putSingleTagForCategory(category, singleCategoryTag, singleCategoryTag.getVersion());
                }
            }
        }
        return sourcedConfigurationDescription;
    }

    public class ConfigurationWriteLock
    implements AutoCloseable {
        public final Lock writeLock;

        private ConfigurationWriteLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            this.writeLock = ConfigurationService.this.configLock.writeLock();
            if (!this.writeLock.tryLock(time, unit)) {
                throw new TimeoutException("Could not acquire a writer lock within the given time.");
            }
        }

        private ConfigurationWriteLock() {
            this.writeLock = ConfigurationService.this.configLock.writeLock();
            this.writeLock.lock();
        }

        @Override
        public void close() {
            this.writeLock.unlock();
        }
    }

    public class ConfigurationLock
    implements AutoCloseable {
        public final Lock readLock;

        private ConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            this.readLock = ConfigurationService.this.configLock.readLock();
            if (!this.readLock.tryLock(time, unit)) {
                throw new TimeoutException("Could not acquire a reader lock within the given time.");
            }
        }

        private ConfigurationLock() {
            this.readLock = ConfigurationService.this.configLock.readLock();
            this.readLock.lock();
        }

        @Override
        public void close() {
            this.readLock.unlock();
        }
    }
}

