/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerBuilder;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ConfigurationHandlerSet {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    private final List<DataProviderInfo> list = new ArrayList<DataProviderInfo>();
    private final Map<String, ConfigurationHandler> componentParameterHandlers = new LinkedHashMap<String, ConfigurationHandler>();
    private final Map<String, CategoryHandler> parametersByCategories = new HashMap<String, CategoryHandler>();
    private ConfigurationView initialView;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, String> componentToPath = new HashMap<String, String>();
    private final boolean useFullPaths;
    private static Comparator<DataProviderInfo> comparator = new Comparator<DataProviderInfo>(){

        @Override
        public int compare(DataProviderInfo o1, DataProviderInfo o2) {
            return o1.getFullPath().compareTo(o2.getFullPath());
        }
    };

    public ConfigurationHandlerSet(boolean usefullPaths) {
        this.useFullPaths = usefullPaths;
    }

    public ConfigurationHandlerSet() {
        this(true);
    }

    public boolean addConfigurationHandlerForObject(String componentName, String componentPath, Object component) {
        ConfigurationHandler handler = ConfigurationHandlerBuilder.buildParameterSetterFromObject(componentName, component);
        this.componentToPath.put(componentName, componentPath);
        if (handler == null) {
            return false;
        }
        this.componentParameterHandlers.put(componentName, handler);
        for (ConfigurationParameterHandler cph : handler.getConfigurationParameterHandlers()) {
            String category = cph.getCategory();
            CategoryHandler set = this.parametersByCategories.get(category);
            if (set == null) {
                this.categories.add(category);
                set = new CategoryHandler(category);
                this.parametersByCategories.put(category, set);
            }
            set.addParameterHandler(cph);
        }
        return true;
    }

    public ConfigurationInfo initialize(String descriptionName) {
        return this.initialize(descriptionName, new ConfigurationView(ConfigurationDescription.safeConfiguration(this.categories)));
    }

    public ConfigurationInfo initialize(String descriptionName, ConfigurationView safeView) {
        return this.initialize(descriptionName, safeView, false);
    }

    public ConfigurationInfo initialize(String descriptionName, ConfigurationView safeView, boolean isBuild) {
        this.initialView = new ConfigurationView(ConfigurationDescription.safeConfiguration(this.categories));
        this.initialView.putAll(this.getLiveConfigurationView());
        this.initialView.putAll(safeView);
        try {
            this.loadCategories(safeView, isBuild);
            for (Map.Entry<ParameterPath, String> pp : this.initialView.getAsParameterPathMap().entrySet()) {
                if (!pp.getValue().equals("_null_")) continue;
                log.warn((Object)("parameter " + pp.getKey() + " has not been assigned a safe non null value"));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("could not load safe configuration.", ex);
        }
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(descriptionName);
        for (CategoryHandler ch : this.parametersByCategories.values()) {
            ciBuilder.updateCategoryInformation(ch.getCategory(), safeView.getConfigurationDescription().getCategoryTags().get(ch.getCategory()), safeView.getConfigurationDescription().getCategoryVersions().get(ch.getCategory()), false);
            for (ConfigurationParameterHandler cph : ch.getParameters()) {
                ParameterPath pp = new ParameterPath(cph.getComponentName(), cph.getParameterName());
                ciBuilder.addParameter(pp, cph.getType(), cph.getCategory(), cph.getDescription(), cph.isFinal(), cph.isReadOnly());
                DataProviderInfo dataProviderInfo = new DataProviderInfo(this.componentToPath.get(pp.getComponentName()), DataProviderInfo.Type.CONFIGURATION, pp.getParameterName());
                if (!this.useFullPaths) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.PUBLISHED_PATH, pp.getComponentName() + "/" + pp.getParameterName());
                }
                if (!cph.getUnits().isEmpty()) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.UNITS, cph.getUnits());
                }
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.TYPE, cph.getType().getTypeName());
                if (!cph.getDescription().isEmpty()) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, cph.getDescription());
                }
                this.list.add(dataProviderInfo);
                ciBuilder.updateParameter(pp, this.initialView.getPathValue(pp), this.initialView.getPathValue(pp), false);
            }
        }
        Collections.sort(this.list, comparator);
        return ciBuilder.setConfigurationState(ConfigurationState.INITIAL_SAFE).setCCSTimeStamp(CCSTimeStamp.currentTime()).build();
    }

    public List<DataProviderInfo> getDataPoviderInfoList() {
        return this.list;
    }

    private ConfigurationHandler getParameterSet(String componentName) {
        ConfigurationHandler res = this.componentParameterHandlers.get(componentName);
        if (res == null) {
            throw new IllegalArgumentException("no such component : " + componentName);
        }
        return res;
    }

    public CategoryHandler getCategoryHandler(String category) {
        CategoryHandler res = this.parametersByCategories.get(category);
        if (res == null) {
            log.info((Object)("no such category : " + category));
        }
        return res;
    }

    public boolean isBuildParameter(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isBuildParameter(parameterName);
    }

    public boolean isFinalParameter(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isFinalParameter(parameterName);
    }

    public boolean isParameterConfigurable(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isParameterConfigurable(parameterName);
    }

    public boolean isParameterReadOnly(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isParameterReadOnly(parameterName);
    }

    public Set<String> getCategorySet() {
        return Collections.unmodifiableSet(this.parametersByCategories.keySet());
    }

    public ConfigurationView loadCategories(ConfigurationView cv) {
        return this.loadCategories(cv, false);
    }

    private ConfigurationView loadCategories(ConfigurationView cv, boolean isBuild) {
        ConfigurationDescription configDesc = cv.getConfigurationDescription();
        this.dropAllSubmittedChanges();
        StringBuilder unexpectedParms = new StringBuilder("");
        for (Map.Entry<ParameterPath, String> entry : cv.getAsParameterPathMap().entrySet()) {
            ParameterPath parm = entry.getKey();
            String componentName = parm.getComponentName();
            String parameterName = parm.getParameterName();
            if (!isBuild ? this.isBuildParameter(componentName, parameterName) : !this.isBuildParameter(componentName, parameterName)) continue;
            if (this.isParameterConfigurable(componentName, parameterName) && !this.isParameterReadOnly(componentName, parameterName)) {
                this.submitChange(componentName, parameterName, entry.getValue());
                continue;
            }
            unexpectedParms.append(parm).append(" ");
        }
        HashMap<String, String> missingParmsDigest = new HashMap<String, String>();
        for (String category : configDesc.getCategoryTags().keySet()) {
            StringBuilder missingParms = new StringBuilder("");
            CategoryHandler ch = this.getCategoryHandler(category);
            for (ConfigurationParameterHandler cph : ch.getParameters()) {
                String componentName = cph.getComponentName();
                String parameterName = cph.getParameterName();
                if (!isBuild ? this.isBuildParameter(componentName, parameterName) : !this.isBuildParameter(componentName, parameterName)) continue;
                if (cph.isReadOnly() || cph.isFinal() || cv.containsPath(new ParameterPath(componentName, parameterName))) continue;
                missingParms.append(new ParameterPath(componentName, parameterName).toString()).append(" ");
                this.submitChange(componentName, parameterName, this.initialView.getPathValue(new ParameterPath(componentName, parameterName)));
            }
            if (missingParms.toString().isEmpty() || "safe".equals(configDesc.getCategoryTags().get(category))) continue;
            missingParmsDigest.put("\"" + category + "\":\"" + configDesc.getCategoryTags().get(category) + "\"", missingParms.toString());
        }
        if (!unexpectedParms.toString().isEmpty() || !missingParmsDigest.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("the following problems occured when reading the configuration : ").append(configDesc.toString()).append("\n");
            if (!unexpectedParms.toString().isEmpty()) {
                stringBuilder.append("\t unexpected parameters : ").append(unexpectedParms.toString()).append("\n");
            }
            if (!missingParmsDigest.isEmpty()) {
                for (Map.Entry e : missingParmsDigest.entrySet()) {
                    stringBuilder.append("\t missing values for configuration ").append((String)e.getKey()).append(" : ").append((String)e.getValue()).append("\n");
                }
            }
            log.warn((Object)(stringBuilder.toString() + "Saving the problematic configurations once they are loaded will fix them."));
            if (BootstrapResourceUtils.getBootstrapSystemProperties().getOrDefault((Object)"org.lsst.ccs.config.require_complete_configurations", "false").equals("true")) {
                throw new RuntimeException(stringBuilder.append("Load aborted.").toString());
            }
        }
        return this.commitBulkChange(configDesc);
    }

    public void dropAllSubmittedChanges() {
        this.componentParameterHandlers.values().stream().forEach(ConfigurationHandler::dropSubmittedChanges);
    }

    public void dropSubmittedChangesForComponent(String name) {
        this.getParameterSet(name).dropSubmittedChanges();
    }

    public Map<String, String> getSubmittedChangesForComponent(String name) {
        return this.getParameterSet(name).getSubmittedChanges().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        TreeMap<String, Map<String, String>> res = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            Map<String, String> submittedChanges = this.getSubmittedChangesForComponent(entry.getKey());
            if (submittedChanges.isEmpty()) continue;
            res.put(entry.getKey(), new TreeMap<String, String>(submittedChanges));
        }
        return res;
    }

    public void submitChange(String componentName, String parameterName, Object value, boolean readOnlyOk) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a valid configuration parameter.");
        }
        if (this.isParameterReadOnly(componentName, parameterName) && !readOnlyOk) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is a read-only configuration parameter.");
        }
        this.getParameterSet(componentName).submitChange(parameterName, value);
    }

    public void submitChange(String componentName, String parameterName, Object value) {
        this.submitChange(componentName, parameterName, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationView commitBulkChange(ConfigurationDescription categoriesToCommit) {
        ConfigurationView submittedChanges;
        ConfigurationView before;
        block14: {
            before = this.getLiveConfigurationView();
            submittedChanges = new ConfigurationView();
            for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
                entry.getValue().trimSubmittedChanges();
                for (Map.Entry<String, String> e : entry.getValue().getSubmittedChanges().entrySet()) {
                    submittedChanges.putParameterValue(entry.getKey(), e.getKey(), e.getValue());
                }
            }
            log.fine((Object)("processing the following submitted changes :" + submittedChanges));
            BulkValidationException excThrown = null;
            try {
                for (ConfigurationHandler configurationHandler : this.componentParameterHandlers.values()) {
                    configurationHandler.invokeValidateBulkChange(ConfigurationDescription.safeConfiguration(this.categories).equals(categoriesToCommit));
                }
            }
            catch (Exception exception) {
                excThrown = new BulkValidationException(exception);
                return excThrown;
            }
            finally {
                ConfigurationView configurationView = this.getLiveConfigurationView();
                ConfigurationView configurationView2 = before.diff(configurationView);
                if (!configurationView2.isEmpty()) {
                    this.dropAllSubmittedChanges();
                    Set<ParameterPath> suspect = configurationView2.getAsParameterPathMap().keySet();
                    throw new BulkSettingException("some parameters have been modified during the validation step : " + suspect, excThrown);
                }
                if (excThrown == null) break block14;
                throw excThrown;
            }
        }
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            ConfigurationHandler ch = entry.getValue();
            try {
                ch.invokeSetParameters(before.getValuesForComponent(entry.getKey()));
            }
            catch (Exception ex) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException(ex.getMessage(), ex);
            }
        }
        ConfigurationView configurationView = this.getLiveConfigurationView();
        ConfigurationView configurationView3 = before.diff(configurationView);
        for (Map.Entry<ParameterPath, String> pathVal : configurationView3.getAsParameterPathMap().entrySet()) {
            ParameterPath path = pathVal.getKey();
            if (!submittedChanges.containsPath(path)) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException("the parameter " + path + " was not supposed to change from " + before.getPathValue(path) + " to " + pathVal.getValue());
            }
            if (submittedChanges.getPathValue(path).equals(pathVal.getValue())) continue;
            this.dropAllSubmittedChanges();
            throw new BulkSettingException("wrong value for parameter : " + path.toString() + ", expected : " + submittedChanges.getPathValue(path) + ", actual : " + pathVal.getValue());
        }
        this.dropAllSubmittedChanges();
        configurationView.setConfigurationDescription(categoriesToCommit);
        return configurationView;
    }

    public ConfigurationView setSingleParameter(String componentName, String parameterName, Object value) {
        return this.setSingleParameter(componentName, parameterName, value, false);
    }

    public ConfigurationView setSingleParameter(String componentName, String parameterName, Object value, boolean isReadOnlyOk) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            log.info((Object)("no such parameter " + new ParameterPath(componentName, parameterName)));
            return new ConfigurationView();
        }
        Map<String, Map<String, String>> previousChanges = this.getAllSubmittedChanges();
        this.dropAllSubmittedChanges();
        this.submitChange(componentName, parameterName, value, isReadOnlyOk);
        ConfigurationView view = this.commitBulkChange(null);
        this.dropAllSubmittedChanges();
        for (Map.Entry<String, Map<String, String>> entry : previousChanges.entrySet()) {
            String comp = entry.getKey();
            for (Map.Entry<String, String> e : entry.getValue().entrySet()) {
                String parmName = e.getKey();
                String parmVal = e.getValue();
                this.submitChange(comp, parmName, parmVal);
            }
        }
        return view;
    }

    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categorySet) {
        return this.getParameterSet(componentName).getCurrentValues(categorySet).entrySet().stream().collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> (String)entry.getValue()));
    }

    public ConfigurationView getLiveConfigurationView() {
        ConfigurationView res = new ConfigurationView();
        for (String compName : this.componentParameterHandlers.keySet()) {
            res.putValuesForComponent(compName, this.getCurrentValuesForComponent(compName, this.categories));
        }
        return res;
    }
}

